<?xml version="1.0" encoding="UTF-8"?>
<!-- Wijzigingen sinds 2019: 
    20260114 aangepast: 
         Aanpassingen n.a.v. versie 2026.1.
    20250523 aangepast: 
         Aanpassingen n.a.v. versie 2025.1 met nieuw blok <buitenlandadres> toegevoegd aan <adreslijst>.
    20240328 aangepast: 
         Presentatie van Schoolloopbaan verbeterd (onderwijsaanbieder, onderwijslocatie en opleidingskenmerken op aparte regel)
         Verouderde elementen uit 2019.1 verwijderd (<lgf>, <verblijf_opdc>, <sefunctioneren>, <extrahulpingroep78>, <handelingsplanlijst>, <zorg> en diens deelelementen)
         Verouderde elementen sinds 2022.1 verwijderd (<leerlinggewicht>, <bevorderd>, <examenresultaat>, <resultaatvakkenvo>, <stageLijst>, <overigvombo>) 
         verouderde elementen uit 2024.1 verwijderd (<toetsniveau>) en 
         verouderde codes uit codelijsten verwijderd 
         Aanpassingen n.a.v. versie 2024.1 met doorstroomtoets, schooladviezen en codelijsten (Overstapadvies).
    20230911 aangepast: Aanpassingen n.a.v. doorstroomtoets correctieversie (m.n. codelijsten).
        Hoofdindeling van dossier is in de categorieen van selectief uitleveren in volgorde van gegevensstructuur; benamin van categorieen consistent met documentatie
        Verwijzingen naar bijlagedocumenten in blauwe markering.
    20230222 aangepast: Herstructurering van Toetsen (toetsresultaten) om meer ruimte te maken voor toetscodes. 
        Verdere aanpassingen: alle verwijzingen naar bijlagedocumenten gelijkgetrokken en in blauw.
    20211210 aangepast: 2022.1 standaard implementatie
    20190401 Codelijst 23 Diagnoses (ICD-10) uitgebreid:
        - Z62: Overig: Ouder/kind-problemen
        - F79.VB: Verstandelijke beperking
        - F79.ZB: Zwakbegaafdheid
        - HB: Hoogbegaafdheid
        - F80: TOS (Taal Ontwikkeling Stoornis)
        - F81.9: Leerstoornis (Niet anders gespecificeerd)
        - F43.2: Aanpassingsstoornissen
    20199229 aangepast: 2019.1 standaard implementatie
        - Selectief uitleveren: cat_zorgenbegeleiding vervangen met cat_onderwijsondersteuning
        - TODO: verwijderd: Leerling -> Zorg element
        - toegevoegd: onderwijsondersteuning (na leerling -> schoolloopbaanlijst)
            - Toelichting onderwijsbehoeften (+bijlage)
            - Diagnose (verplaatst uit zorg)
            - Medicijngebruik (verplaatst uit zorg)
            - Handelingsplan (verplaatst uit leerling)
            - OPP (verplaatst uit zorg)
            - Toelaatbaarheidsverklaring (verplaatst uit zorg)
            - Arrangement cluster 1 & 2 (verplaatst uit zorg -> arrangement en hernoemd)
            - Arrangement cluster (PaO) (nieuw)
            - LWOO (verplaatst uit zorg)
            - RVC (verplaatst uit zorg)
            
         - verwijderd: artslijst
         - toegevoegd: huisarts
-->
<xsl:stylesheet version="1.0" xmlns:od="http://www.edustandaard.nl/oso_gegevensset/2026/dossier" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:output method="xml" encoding="UTF-8" indent="yes"/>

    <!-- Algemene opmaak pagina -->
    <xsl:template match="od:dossier" xmlns="http://www.edustandaard.nl/oso_gegevensset/2026/dossier">
        <fo:root>
            <fo:layout-master-set>
                <fo:simple-page-master margin="10mm 00mm 10mm 00mm" master-name="contentPage">
                    <xsl:attribute name="page-height">
                        <xsl:text>297mm</xsl:text>
                    </xsl:attribute>
                    <xsl:attribute name="page-width">
                        <xsl:text>210mm</xsl:text>
                    </xsl:attribute>
                    <fo:region-body margin-bottom="8mm" margin-left="15mm" margin-right="15mm" margin-top="8mm"/>
                    <fo:region-before/>
                    <fo:region-after/>
                </fo:simple-page-master>
                <fo:page-sequence-master master-name="PageMaster">
                    <fo:repeatable-page-master-alternatives>
                        <fo:conditional-page-master-reference master-reference="contentPage"/>
                    </fo:repeatable-page-master-alternatives>
                </fo:page-sequence-master>
            </fo:layout-master-set>
            <fo:page-sequence master-reference="PageMaster" initial-page-number="1">
                <fo:static-content flow-name="xsl-region-before" margin-left="15mm" margin-right="15mm" font-family="Arial" font-size="8pt">
                    <fo:block border-bottom="1pt solid black">Overstapdossier</fo:block>
                </fo:static-content>
                <fo:static-content flow-name="xsl-region-after" margin-left="15mm" margin-right="15mm" font-family="Arial" font-size="8pt">
                    <fo:block border-top="1pt solid black" text-align="end" padding-top="2pt">pagina <fo:page-number/></fo:block>
                </fo:static-content>
                <fo:flow flow-name="xsl-region-body" font-family="Arial" font-size="7pt">
                    <xsl:apply-templates/>
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>



    <!-- Algemene dossiergegevens -->
    <xsl:template match="od:dossier/od:metadata">
        <fo:block-container>
            <xsl:call-template name="createHeader01">
                <xsl:with-param name="headerContent">
                    <xsl:text>Algemene dossiergegevens</xsl:text>
                </xsl:with-param>
            </xsl:call-template>
            <fo:block space-after="6pt" space-before="0pt" padding="3pt" font-size="7pt" background-color="#4d4d4d" color="#ffffff">
                <xsl:text>Metagegevens over het dossier</xsl:text>
            </fo:block>
            <fo:block>
                <fo:table border="0pt">
                    <fo:table-column column-width="30%"/>
                    <fo:table-column column-width="70%"/>
                    <fo:table-body>
                        <fo:table-row>
                            <fo:table-cell padding="2pt">
                                <fo:block>
                                    <xsl:value-of select="local-name(following-sibling::od:overdrachtsoort)"/>
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell padding="2pt">
                                <fo:block>
                                    <xsl:call-template name="overdrachtsoortcodelijst">
                                        <xsl:with-param name="codeValue">
                                            <xsl:value-of select="following-sibling::od:overdrachtsoort"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                        <xsl:for-each select="child::od:*">
                            <fo:table-row>
                                <fo:table-cell padding="2pt">
                                    <fo:block>
                                        <xsl:choose>
                                            <xsl:when test="local-name() = 'categorie_uitlevering'"/>
                                            <!-- skip this field in this block -->
                                            <xsl:otherwise>
                                                <xsl:value-of select="local-name()"/>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding="2pt">
                                    <fo:block>
                                        <xsl:choose>
                                            <xsl:when test="local-name() = 'overstap'">
                                                <xsl:call-template name="overstapcodelijst">
                                                    <xsl:with-param name="codeValue">
                                                        <xsl:value-of select="node()"/>
                                                    </xsl:with-param>
                                                </xsl:call-template>
                                            </xsl:when>
                                            <xsl:when test="local-name() = 'deeldossier'">
                                                <xsl:call-template name="deeldossierlijst">
                                                    <xsl:with-param name="codeValue">
                                                        <xsl:value-of select="node()"/>
                                                    </xsl:with-param>
                                                </xsl:call-template>
                                            </xsl:when>
                                            <xsl:when test="local-name() = 'categorie_uitlevering'"/>
                                            <!-- skip this field in this block -->
                                            <xsl:otherwise>
                                                <xsl:value-of select="node()"/>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                        </xsl:for-each>
                    </fo:table-body>
                </fo:table>
            </fo:block>
        </fo:block-container>
        <xsl:apply-templates/>
    </xsl:template>




    <!-- plaats hier categorie uitlevering overzicht -->

    <xsl:template match="od:dossier/od:metadata/od:categorie_uitlevering">
        <fo:block-container>
            <xsl:call-template name="createHeader02">
                <xsl:with-param name="headerContent">
                    <xsl:text>Overzicht van categorieën van gegevens in het dossier</xsl:text>
                </xsl:with-param>
            </xsl:call-template>
            <fo:block>
                <fo:table border="0pt">
                    <fo:table-column column-width="30%"/>
                    <fo:table-column column-width="70%"/>

                    <fo:table-body>
                        <!-- Toon een rij met blokken die zijn VERPLICHT -->
                        <xsl:call-template name="categorie_uitlevering_row_template">
                            <xsl:with-param name="categorieNaam">VERPLICHT</xsl:with-param>
                        </xsl:call-template>

                        <!-- Toon een rij met blokken die zijn OPTIONEEL -->
                        <xsl:call-template name="categorie_uitlevering_row_template">
                            <xsl:with-param name="categorieNaam">OPTIONEEL</xsl:with-param>
                        </xsl:call-template>

                        <!-- Toon een rij met blokken die zijn UITGESCHAKELD -->
                        <xsl:call-template name="categorie_uitlevering_row_template">
                            <xsl:with-param name="categorieNaam">OPT-UIT</xsl:with-param>
                        </xsl:call-template>

                        <!-- Toon een rij met blokken die zijn VERBODEN -->
                        <xsl:call-template name="categorie_uitlevering_row_template">
                            <xsl:with-param name="categorieNaam">VERBODEN</xsl:with-param>
                        </xsl:call-template>

                    </fo:table-body>
                </fo:table>
            </fo:block>

            <!-- Check of er verkeerde waarde is meegegeven aan een van de catoegorieen. -->
            <!-- Toon de foutmelding. for-each / break XSLT constructie. -->
            <!--- De for-each select moet de conditie bevaten, anders werkt het niet. -->
            <xsl:for-each select="od:*[string(.) != 'VERPLICHT' and string(.) != 'OPTIONEEL' and string(.) != 'OPT-UIT' and string(.) != 'VERBODEN']">
                <xsl:if test="position() = 1">
                    <!-- Toon de foutmelding tekst (eenmalig) -->
                    <fo:block>
                        <fo:inline color="red">
                            <xsl:text>De onderstaande categorieën bevatten verkeerde waarden.</xsl:text>
                        </fo:inline>
                    </fo:block>
                </xsl:if>
            </xsl:for-each>

            <xsl:for-each select="od:*">
                <xsl:if test="string(.) != 'VERPLICHT' and string(.) != 'OPTIONEEL' and string(.) != 'OPT-UIT' and string(.) != 'VERBODEN'">
                    <fo:block>
                        <fo:table border="0pt">
                            <fo:table-column column-width="30%"/>
                            <fo:table-column column-width="70%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell padding="2pt">
                                        <fo:block>
                                            <fo:inline color="red">
                                                <xsl:call-template name="categorie_uitlevering_taglijst">
                                                    <xsl:with-param name="tagName">
                                                        <xsl:value-of select="local-name()"/>
                                                    </xsl:with-param>
                                                </xsl:call-template>
                                            </fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding="2pt">
                                        <fo:block>
                                            <fo:inline color="red">
                                                <xsl:value-of select="string(.)"/>
                                            </fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                    </fo:block>
                </xsl:if>
            </xsl:for-each>

        </fo:block-container>

    </xsl:template>


    <!-- Wordt opgepakt binnen algemene dossiergegevens -->
    <!--xsl:template match="od:dossier/od:metadata/od:*"/-->
    <!--xsl:template match="od:dossier/od:overdrachtsoort"/-->

    <!-- Inzage -->
    <xsl:template match="od:dossier/od:inzage">
        <fo:block-container>
            <xsl:call-template name="createHeader01">
                <xsl:with-param name="headerContent">
                    <xsl:text>Ouderinzage</xsl:text>
                </xsl:with-param>
            </xsl:call-template>
            <fo:block space-after="6pt" space-before="0pt" padding="3pt" font-size="7pt" background-color="#4d4d4d" color="#ffffff">
                <xsl:text>Registratie van inzage door ouders</xsl:text>
            </fo:block>
            <xsl:for-each select="child::od:*">
                <xsl:choose>
                    <xsl:when test="local-name() = 'akkoord'">
                        <xsl:call-template name="createDefaultContentTable">
                            <xsl:with-param name="codelistType">akkoordcodelijst</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="local-name() = 'toestemming'">
                        <xsl:call-template name="createDefaultContentTable">
                            <xsl:with-param name="codelistType">toestemmingcodelijst</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="createDefaultContentTable"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </fo:block-container>
        <xsl:apply-templates/>
    </xsl:template>

    <!-- Wordt opgepakt binnen inzage -->
    <xsl:template match="od:dossier/od:inzage/od:*"/>

    <!-- Huidige school gegevens -->
    <xsl:template match="od:dossier/od:huidigeschool">
        <fo:block-container>
            <xsl:call-template name="createHeader01">
                <xsl:with-param name="headerContent">
                    <xsl:text>School</xsl:text>
                </xsl:with-param>
            </xsl:call-template>
            <fo:block space-after="6pt" space-before="0pt" padding="3pt" font-size="7pt" background-color="#4d4d4d" color="#ffffff">
                <xsl:text>Huidige school van de leerling</xsl:text>
            </fo:block>

            <xsl:for-each select="child::od:*">
                <xsl:choose>
                    <xsl:when test="local-name() = 'adreslijst'"/>
                    <xsl:when test="local-name() = 'communicatielijst'"/>
                    <xsl:when test="local-name() = 'leerling'"/>
                    <xsl:when test="local-name() = 'onderwijsaanbieder'">
                        <xsl:call-template name="onderwijsaanbiederInformatie"/>
                    </xsl:when>
                    <xsl:when test="local-name() = 'onderwijslocatie'">
                        <xsl:call-template name="onderwijslocatieInformatie"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="createDefaultContentTable"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
            <!-- Adressen school -->
            <xsl:for-each select="child::od:adreslijst">
                <xsl:call-template name="createAddressList"/>
            </xsl:for-each>
            <!-- Contactgegevens school -->
            <xsl:for-each select="child::od:communicatielijst">
                <xsl:call-template name="createContactInfoList"/>
            </xsl:for-each>
        </fo:block-container>
        <xsl:apply-templates/>
    </xsl:template>

    <!-- Wordt opgepakt binnen huidige school -->
    <xsl:template match="od:dossier/od:huidigeschool/od:*[not(local-name() = 'leerling')]"/>



    <!-- Leerlinggegevens -->
    <xsl:template match="od:dossier/od:huidigeschool/od:leerling">
        <fo:block-container>
            <xsl:call-template name="createHeader01">
                <xsl:with-param name="headerContent">
                    <xsl:text>Leerling</xsl:text>
                </xsl:with-param>
            </xsl:call-template>
            <fo:block space-after="6pt" space-before="0pt" padding="3pt" font-size="7pt" background-color="#4d4d4d" color="#ffffff">
                <xsl:text>De leerling, met name administratief, demografisch en onderwijsbekostiging</xsl:text>
            </fo:block>

            <!-- Adressen leerling -->
            <xsl:for-each select="child::od:adreslijst">
                <xsl:call-template name="createAddressList"/>
            </xsl:for-each>
            <!-- Contactgegevens leerling -->
            <xsl:for-each select="child::od:communicatielijst">
                <xsl:call-template name="createContactInfoList"/>
            </xsl:for-each>
            <!-- Contactgegevens leerling -->
            <xsl:for-each select="child::od:gba">
                <xsl:call-template name="createHeader03">
                    <xsl:with-param name="headerContent">
                        <xsl:text>GBA gegevens</xsl:text>
                    </xsl:with-param>
                </xsl:call-template>
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <xsl:call-template name="createHeader03">
                <xsl:with-param name="headerContent">
                    <xsl:text>Overige leerlinggegevens</xsl:text>
                </xsl:with-param>
            </xsl:call-template>
            <xsl:for-each select="child::od:voornaam">
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <xsl:for-each select="child::od:voorletters-1">
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <xsl:for-each select="child::od:voorvoegsel">
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <xsl:for-each select="child::od:achternaam">
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <xsl:for-each select="child::od:roepnaam">
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <xsl:for-each select="child::od:geboortedatum">
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <!-- 20260114 veld geboortemaand verwijderd uit gegevensset voor versie 2026.1 -->
            <xsl:for-each select="child::od:geboortemaand">
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <xsl:for-each select="child::od:geslacht">
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <xsl:for-each select="child::od:adresgeheim">
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <!-- 20260114 veld postcode4adres verwijderd uit gegevensset voor versie 2026.1 -->
            <xsl:for-each select="child::od:postcode4adres">
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <xsl:for-each select="child::od:adresbuitenland">
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <!-- 20260114 veld geboorteplaats verwijderd uit gegevensset voor versie 2026.1 -->
            <xsl:for-each select="child::od:geboorteplaats">
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <!-- 20260114 veld nationaliteit verwijderd uit gegevensset voor versie 2026.1 -->
            <xsl:for-each select="child::od:nationaliteit">
                <xsl:call-template name="createDefaultContentTable">
                    <xsl:with-param name="codelistType">nationaliteitcodelijst</xsl:with-param>
                </xsl:call-template>
            </xsl:for-each>
            <xsl:for-each select="child::od:onderwijsnummer">
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <xsl:for-each select="child::od:bsn">
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <xsl:for-each select="child::od:leerlingid">
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <xsl:for-each select="child::od:onderwijssinds">
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <xsl:for-each select="child::od:startdatumhuidigonderwijs">
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <xsl:for-each select="child::od:datuminschrijving">
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <xsl:for-each select="child::od:datumuitschrijving">
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <xsl:for-each select="child::od:opleidingskenmerk">
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <xsl:for-each select="child::od:nnca">
                <xsl:call-template name="createDefaultContentTable">
                    <xsl:with-param name="codelistType">nncacodelijst</xsl:with-param>
                </xsl:call-template>
            </xsl:for-each>
            <xsl:for-each select="child::od:huisarts">
                <xsl:call-template name="huisarts"/>
            </xsl:for-each>

            <xsl:call-template name="createHeader01">
                <xsl:with-param name="headerContent">
                    <xsl:text>Ouders/Verzorgers</xsl:text>
                </xsl:with-param>
            </xsl:call-template>
            <fo:block space-after="6pt" space-before="0pt" padding="3pt" font-size="7pt" background-color="#4d4d4d" color="#ffffff">
                <xsl:text>De ouders/verzorgers van de leerling en/of de aansprakelijke instelling</xsl:text>
            </fo:block>
            <xsl:for-each select="child::od:verzorgersaansprakelijk">
                <xsl:call-template name="createHeader02">
                    <xsl:with-param name="headerContent">
                        <xsl:text>Verzorgers aansprakelijk?</xsl:text>
                    </xsl:with-param>
                </xsl:call-template>
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <xsl:for-each select="child::od:aansprakelijkeinstelling">
                <xsl:call-template name="aansprakelijkeInstelling"/>
            </xsl:for-each>
            <xsl:for-each select="child::od:verzorger">
                <xsl:call-template name="verzorger"/>
            </xsl:for-each>

            <xsl:for-each select="child::od:overstapadvies">
                <xsl:call-template name="overstapAdvies"/>
            </xsl:for-each>

            <xsl:for-each select="child::od:vanpeuterspeelzaal">
                <xsl:call-template name="createHeader01">
                    <xsl:with-param name="headerContent">
                        <xsl:text>VVE</xsl:text>
                    </xsl:with-param>
                </xsl:call-template>
                <fo:block space-after="6pt" space-before="0pt" padding="3pt" font-size="7pt" background-color="#4d4d4d" color="#ffffff">
                    <xsl:text>Voorschoolse en vroegschoolse educatie (programma en deelname), inclusief peuterspeelzaal</xsl:text>
                </fo:block>
                <xsl:call-template name="createHeader02">
                    <xsl:with-param name="headerContent">
                        <xsl:text>Peuterspeelzaal</xsl:text>
                    </xsl:with-param>
                </xsl:call-template>
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <xsl:for-each select="child::od:naampeuterspeelzaal">
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <xsl:for-each select="child::od:voorschools">
                <xsl:call-template name="voorschoolseInformatie"/>
            </xsl:for-each>
            <xsl:for-each select="child::od:vroegschools">
                <xsl:call-template name="vroegschoolseInformatie"/>
            </xsl:for-each>

            <xsl:for-each select="child::od:*">
                <xsl:choose>
                    <xsl:when test="local-name() = 'adreslijst'"/>
                    <xsl:when test="local-name() = 'communicatielijst'"/>
                    <xsl:when test="local-name() = 'gba'"/>
                    <xsl:when test="local-name() = 'voornaam'"/>
                    <xsl:when test="local-name() = 'voorletters-1'"/>
                    <xsl:when test="local-name() = 'voorvoegsel'"/>
                    <xsl:when test="local-name() = 'achternaam'"/>
                    <xsl:when test="local-name() = 'roepnaam'"/>
                    <xsl:when test="local-name() = 'geboortedatum'"/>
                    <xsl:when test="local-name() = 'geboortemaand'"/>
                    <xsl:when test="local-name() = 'geslacht'"/>
                    <xsl:when test="local-name() = 'adresgeheim'"/>
                    <xsl:when test="local-name() = 'postcode4adres'"/>
                    <xsl:when test="local-name() = 'adresbuitenland'"/>
                    <xsl:when test="local-name() = 'geboorteplaats'"/>
                    <xsl:when test="local-name() = 'nationaliteit'"/>
                    <xsl:when test="local-name() = 'onderwijsnummer'"/>
                    <xsl:when test="local-name() = 'bsn'"/>
                    <xsl:when test="local-name() = 'leerlingid'"/>
                    <xsl:when test="local-name() = 'onderwijssinds'"/>
                    <xsl:when test="local-name() = 'startdatumhuidigonderwijs'"/>
                    <xsl:when test="local-name() = 'datuminschrijving'"/>
                    <xsl:when test="local-name() = 'datumuitschrijving'"/>
                    <xsl:when test="local-name() = 'opleidingskenmerk'"/>
                    <xsl:when test="local-name() = 'nnca'"/>
                    <xsl:when test="local-name() = 'huisarts'"/>

                    <xsl:when test="local-name() = 'verzorgersaansprakelijk'"/>
                    <xsl:when test="local-name() = 'aansprakelijkeinstelling'"/>
                    <xsl:when test="local-name() = 'verzorger'"/>

                    <xsl:when test="local-name() = 'overstapadvies'"/>

                    <xsl:when test="local-name() = 'vanpeuterspeelzaal'"/>
                    <xsl:when test="local-name() = 'naampeuterspeelzaal'"/>
                    <xsl:when test="local-name() = 'voorschools'"/>
                    <xsl:when test="local-name() = 'vroegschools'"/>

                    <xsl:when test="local-name() = 'schoolloopbaanlijst'">
                        <xsl:call-template name="schoolloopbaanLijst"/>
                    </xsl:when>
                    <xsl:when test="local-name() = 'onderwijsondersteuning'">
                        <xsl:call-template name="onderwijsondersteuningLijst"/>
                    </xsl:when>
                    <xsl:when test="local-name() = 'verzuim'">
                        <xsl:call-template name="verzuim"/>
                    </xsl:when>
                    <xsl:when test="local-name() = 'doorstroomtoets'">
                        <xsl:call-template name="doorstroomtoets"/>
                    </xsl:when>
                    <xsl:when test="local-name() = 'toetslijst'">
                        <xsl:call-template name="toetslijst"/>
                    </xsl:when>
                    <xsl:when test="local-name() = 'cijferlijstlijst'">
                        <xsl:call-template name="createHeader01">
                            <xsl:with-param name="headerContent">
                                <xsl:text>Cijferlijsten</xsl:text>
                            </xsl:with-param>
                        </xsl:call-template>
                        <fo:block space-after="6pt" space-before="0pt" padding="3pt" font-size="7pt" background-color="#4d4d4d" color="#ffffff">
                            <xsl:text>Voortgangsrapporten en andere cijferlijsten</xsl:text>
                        </fo:block>
                        <xsl:for-each select="child::od:cijferlijst">
                            <xsl:call-template name="cijferLijst"/>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:when test="local-name() = 'overigdocumentlijst'">
                        <xsl:call-template name="createHeader02">
                            <xsl:with-param name="headerContent">
                                <xsl:text>Overige documenten</xsl:text>
                            </xsl:with-param>
                        </xsl:call-template>
                        <xsl:for-each select="child::od:document">
                            <xsl:call-template name="document"/>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="createDefaultContentTable"/>
                    </xsl:otherwise>

                </xsl:choose>
            </xsl:for-each>

        </fo:block-container>
        <xsl:apply-templates/>

        <!-- Overzicht van alle bijlagen -->
        <fo:block-container>
            <xsl:call-template name="createHeader01">
                <xsl:with-param name="headerContent">
                    <xsl:text>Bijlagedocumenten</xsl:text>
                </xsl:with-param>
            </xsl:call-template>
            <fo:block space-after="6pt" space-before="0pt" padding="3pt" font-size="7pt" background-color="#4d4d4d" color="#ffffff">
                <xsl:text>Overzicht van alle bijlagedocumenten in het dossier</xsl:text>
            </fo:block>
            <xsl:call-template name="createSpacer"/>
            <xsl:for-each select="descendant::od:document">
                <xsl:call-template name="document"/>
            </xsl:for-each>
        </fo:block-container>
    </xsl:template>

    <!-- Wordt opgepakt binnen leerling -->
    <xsl:template match="od:dossier/od:huidigeschool/od:leerling/od:*"/>



    <!-- School: Onderwijsaanbieder informatie -->
    <xsl:template name="onderwijsaanbiederInformatie">
        <fo:block-container>
            <xsl:call-template name="createHeader02">
                <xsl:with-param name="headerContent">
                    <xsl:text>Onderwijsaanbieder</xsl:text>
                </xsl:with-param>
            </xsl:call-template>
            <xsl:for-each select="child::od:onderwijsaanbiedercode">
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <xsl:for-each select="child::od:onderwijsaanbiedernaam">
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <xsl:call-template name="createSpacer"/>
        </fo:block-container>
    </xsl:template>

    <!-- School: Onderwijslocatie informatie -->
    <xsl:template name="onderwijslocatieInformatie">
        <fo:block-container>
            <xsl:call-template name="createHeader02">
                <xsl:with-param name="headerContent">
                    <xsl:text>Onderwijslocatie</xsl:text>
                </xsl:with-param>
            </xsl:call-template>
            <xsl:for-each select="child::od:onderwijslocatiecode">
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <xsl:for-each select="child::od:adresgegevens">
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <xsl:call-template name="createSpacer"/>
        </fo:block-container>
    </xsl:template>

    <!-- Leerling: Aansprakelijke instelling -->
    <xsl:template name="aansprakelijkeInstelling">
        <fo:block-container>
            <xsl:call-template name="createHeader02">
                <xsl:with-param name="headerContent">
                    <xsl:text>Aansprakelijke instelling</xsl:text>
                </xsl:with-param>
            </xsl:call-template>
            <xsl:for-each select="child::od:naam">
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <!-- Adressen school -->
            <xsl:for-each select="child::od:adreslijst">
                <xsl:call-template name="createAddressList"/>
            </xsl:for-each>
            <!-- Contactgegevens instelling -->
            <xsl:for-each select="child::od:communicatielijst">
                <xsl:call-template name="createContactInfoList"/>
            </xsl:for-each>
            <xsl:call-template name="createSpacer"/>
        </fo:block-container>
    </xsl:template>

    <!-- Leerling: Overstapadvies -->
    <xsl:template name="overstapAdvies">
        <fo:block-container>
            <xsl:call-template name="createHeader01">
                <xsl:with-param name="headerContent">
                    <xsl:text>Overstapadvies</xsl:text>
                </xsl:with-param>
            </xsl:call-template>
            <fo:block space-after="6pt" space-before="0pt" padding="3pt" font-size="7pt" background-color="#4d4d4d" color="#ffffff">
                <xsl:text>Adviezen en informatie rondom de plaatsing van de leerling op de nieuwe school</xsl:text>
            </fo:block>
            <xsl:for-each select="child::od:*">
                <xsl:choose>
                    <xsl:when test="local-name() = 'voorlopig_schooladvies' or local-name() = 'definitief_schooladvies' or local-name() = 'wensouders' or local-name() = 'wensleerling' ">
                        <xsl:call-template name="createDefaultContentTable">
                            <xsl:with-param name="codelistType">overstapadviescodelijst</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="local-name() = 'profiel'">
                        <xsl:call-template name="createDefaultContentTable">
                            <xsl:with-param name="codelistType">overstapadviesprofiellijst</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="createDefaultContentTable"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
            <xsl:call-template name="createSpacer"/>
        </fo:block-container>
    </xsl:template>

    <!-- Leerling: Voorschoolse informatie -->
    <xsl:template name="voorschoolseInformatie">
        <fo:block-container>
            <xsl:call-template name="createHeader02">
                <xsl:with-param name="headerContent">
                    <xsl:text>Voorschoolse informatie</xsl:text>
                </xsl:with-param>
            </xsl:call-template>
            <xsl:call-template name="createDefaultContentTable">
                <xsl:with-param name="codelistType">voorschoolscodelijst</xsl:with-param>
            </xsl:call-template>
            <xsl:call-template name="createSpacer"/>
        </fo:block-container>
    </xsl:template>

    <!-- Leerling: Vroegschoolse informatie -->
    <xsl:template name="vroegschoolseInformatie">
        <fo:block-container>
            <xsl:call-template name="createHeader02">
                <xsl:with-param name="headerContent">
                    <xsl:text>Vroegschoolse informatie</xsl:text>
                </xsl:with-param>
            </xsl:call-template>
            <xsl:call-template name="createDefaultContentTable">
                <xsl:with-param name="codelistType">voorschoolscodelijst</xsl:with-param>
            </xsl:call-template>
            <xsl:call-template name="createSpacer"/>
        </fo:block-container>
    </xsl:template>

    <!-- Leerling: Schoolloopbaan -->
    <xsl:template name="schoolloopbaanLijst">
        <fo:block-container>
            <xsl:call-template name="createHeader01">
                <xsl:with-param name="headerContent">
                    <xsl:text>Schoolloopbaan</xsl:text>
                </xsl:with-param>
            </xsl:call-template>
            <fo:block space-after="6pt" space-before="0pt" padding="3pt" font-size="7pt" background-color="#4d4d4d" color="#ffffff">
                <xsl:text>Historie van scholen, schoolsoort en jaargroepen van de leerling per schooljaar</xsl:text>
            </fo:block>
            <fo:block font-size="7pt">
                <fo:table>
                    <fo:table-header>
                        <fo:table-row background-color="#D8D8D8" border-width="1pt" border-color="#c6c6c6" border-style="solid">
                            <fo:table-cell padding="3pt" width="40pt">
                                <fo:block font-weight="bold">
                                    <xsl:text>Schooljaar</xsl:text>
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell padding="3pt" width="75pt">
                                <fo:block font-weight="bold" linefeed-treatment="preserve">
                                    <xsl:text>Groepcode +</xsl:text>
                                </fo:block>
                                <fo:block font-weight="bold" font-style="italic" linefeed-treatment="preserve">
                                    <xsl:text>Groepsnaam</xsl:text>
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell padding="3pt" width="40pt">
                                <fo:block font-weight="bold" text-align="center" linefeed-treatment="preserve">
                                    <xsl:text>Jaar-&#xA;groep</xsl:text>
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell padding="3pt" width="60pt">
                                <fo:block font-weight="bold" text-align="center" linefeed-treatment="preserve">
                                    <xsl:text>Begin- t/m&#xA;Einddatum</xsl:text>
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell padding="3pt" width="55pt">
                                <fo:block font-weight="bold" linefeed-treatment="preserve">
                                    <xsl:text>Instellings- en Vestigingscode</xsl:text>
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell padding="3pt" width="55pt">
                                <fo:block font-weight="bold" linefeed-treatment="preserve">
                                    <xsl:text>Schoolsoort +</xsl:text>
                                </fo:block>
                                <fo:block font-weight="bold" font-style="italic" linefeed-treatment="preserve">
                                    <xsl:text>Schooltype</xsl:text>
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell padding="3pt">
                                <fo:block font-weight="bold" linefeed-treatment="preserve">
                                    <xsl:text>VO-code +</xsl:text>
                                </fo:block>
                                <fo:block font-weight="bold" font-style="italic" linefeed-treatment="preserve">
                                    <xsl:text>VO-omschrijving</xsl:text>
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell padding="3pt">
                                <fo:block font-weight="bold">
                                    <xsl:text>Schoolsoort omschrijving</xsl:text>
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                    </fo:table-header>
                    <fo:table-body>
                        <xsl:for-each select="child::od:schoolloopbaan">
                            <fo:table-row border-width="1pt" border-color="#c6c6c6" border-style="solid">
                                <fo:table-cell padding="3pt" border-width="1pt" border-color="#c6c6c6" border-style="solid">
                                    <fo:block>
                                        <xsl:value-of select="child::od:schooljaar"/>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding="3pt" border-width="1pt" border-color="#c6c6c6" border-style="solid">
                                    <fo:block linefeed-treatment="preserve">
                                        <xsl:value-of select="child::od:groepscode"/>
                                    </fo:block>
                                    <fo:block font-style="italic" linefeed-treatment="preserve">
                                        <xsl:value-of select="child::od:groepsnaam"/>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding="3pt" border-width="1pt" border-color="#c6c6c6" border-style="solid">
                                    <fo:block text-align="center">
                                        <xsl:for-each select="child::od:jaargroep">
                                            <xsl:call-template name="jaargroepcodelijst"/>
                                        </xsl:for-each>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding="3pt" border-width="1pt" border-color="#c6c6c6" border-style="solid">
                                    <fo:block text-align="center" linefeed-treatment="preserve">
                                        <xsl:value-of select="child::od:begindatum"/>
                                        <xsl:text> t/m&#xA;</xsl:text>
                                        <xsl:value-of select="child::od:einddatum"/>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding="3pt" border-width="1pt" border-color="#c6c6c6" border-style="solid">
                                    <fo:block linefeed-treatment="preserve">
                                        <xsl:value-of select="child::od:brincode"/>
                                        <xsl:text>  </xsl:text>
                                        <xsl:value-of select="child::od:vestigingscode"/>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding="3pt" border-width="1pt" border-color="#c6c6c6" border-style="solid">
                                    <fo:block linefeed-treatment="preserve">
                                        <xsl:value-of select="child::od:schoolsoort"/>
                                    </fo:block>
                                    <fo:block font-style="italic" linefeed-treatment="preserve">
                                        <xsl:value-of select="child::od:schooltype"/>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding="3pt" border-width="1pt" border-color="#c6c6c6" border-style="solid">
                                    <fo:block linefeed-treatment="preserve">
                                        <xsl:value-of select="child::od:voelementcode"/>
                                    </fo:block>
                                    <fo:block font-style="italic" linefeed-treatment="preserve">
                                        <xsl:value-of select="child::od:voelementomschrijving"/>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding="3pt" border-width="1pt" border-color="#c6c6c6" border-style="solid">
                                    <fo:block wrap-option="wrap">
                                        <xsl:value-of select="child::od:schoolsoortomschrijving"/>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                            <xsl:for-each select="child::od:onderwijsaanbieder">
                                <fo:table-row background-color="#FFFFFF" >
                                    <!--<fo:table-cell padding="3pt" font-weight="bold" background-color="#FFFFFF" border-width="1pt" border-color="#c6c6c6" border-style="solid" number-columns-spanned="0">
                                        <fo:block/>
                                    </fo:table-cell>-->
                                    <fo:table-cell padding="3pt" font-weight="bold" background-color="#F2F2F2" text-align="right" border-width="1pt" border-color="#c6c6c6" border-style="solid" number-columns-spanned="2">
                                        <fo:block>
                                            <xsl:text>Onderwijsaanbieder</xsl:text>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding="3pt" background-color="#FFFFFF" border-width="1pt" border-color="#c6c6c6" border-style="solid" number-columns-spanned="1">
                                        <fo:block>
                                            <xsl:value-of select="child::od:onderwijsaanbiedercode"/>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding="3pt" background-color="#FFFFFF" border-width="1pt" border-color="#c6c6c6" border-style="solid" number-columns-spanned="5">
                                        <fo:block>
                                            <xsl:value-of select="child::od:onderwijsaanbiedernaam"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </xsl:for-each>
                            <xsl:for-each select="child::od:onderwijslocatie">
                                <fo:table-row background-color="#FFFFFF" >
                                    <!--<fo:table-cell padding="3pt" font-weight="bold" background-color="#FFFFFF" border-width="1pt" border-color="#c6c6c6" border-style="solid" number-columns-spanned="0">
                                        <fo:block/>
                                    </fo:table-cell>-->
                                    <fo:table-cell padding="3pt" font-weight="bold" background-color="#F2F2F2" text-align="right" border-width="1pt" border-color="#c6c6c6" border-style="solid" number-columns-spanned="2">
                                        <fo:block>
                                            <xsl:text>Onderwijslocatie</xsl:text>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding="3pt" background-color="#FFFFFF" border-width="1pt" border-color="#c6c6c6" border-style="solid" number-columns-spanned="1">
                                        <fo:block>
                                            <xsl:value-of select="child::od:onderwijslocatiecode"/>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding="3pt" background-color="#FFFFFF" border-width="1pt" border-color="#c6c6c6" border-style="solid" number-columns-spanned="5">
                                        <fo:block>
                                            <xsl:value-of select="child::od:adresgegevens"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </xsl:for-each>
                            <xsl:for-each select="child::od:opleidingskenmerk">
                                <fo:table-row background-color="#FFFFFF" >
                                    <!--<fo:table-cell padding="3pt" font-weight="bold" background-color="#FFFFFF" border-width="1pt" border-color="#c6c6c6" border-style="solid" number-columns-spanned="0">
                                        <fo:block/>
                                    </fo:table-cell>-->
                                    <fo:table-cell padding="3pt" font-weight="bold" background-color="#F2F2F2" text-align="right" border-width="1pt" border-color="#c6c6c6" border-style="solid" number-columns-spanned="2">
                                        <fo:block>
                                            <xsl:text>Opleidingskenmerk</xsl:text>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding="3pt" background-color="#FFFFFF" border-width="1pt" border-color="#c6c6c6" border-style="solid" number-columns-spanned="4">
                                        <fo:block>
                                            <xsl:value-of select="node()"/>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding="3pt" background-color="#FFFFFF" border-width="1pt" border-color="#c6c6c6" border-style="solid" number-columns-spanned="2">
                                        <fo:block>
                                            <xsl:call-template name="opleidingskenmerkenlijst"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </xsl:for-each>
                            <fo:table-row background-color="#FFFFFF" >
                                <fo:table-cell padding="1pt" background-color="#FFFFFF" number-columns-spanned="8">
                                    <fo:block/>
                                </fo:table-cell>
                            </fo:table-row>
                        </xsl:for-each>
                    </fo:table-body>
                </fo:table>
            </fo:block>
            <xsl:call-template name="createSpacer"/>
        </fo:block-container>
    </xsl:template>



    <!-- Leerling: Onderwijsondersteuning -->
    <xsl:template name="onderwijsondersteuningLijst">
        <fo:block-container>
            <xsl:call-template name="createHeader01">
                <xsl:with-param name="headerContent">
                    <xsl:text>Onderwijsondersteuning</xsl:text>
                </xsl:with-param>
            </xsl:call-template>
            <fo:block space-after="6pt" space-before="0pt" padding="3pt" font-size="7pt" background-color="#4d4d4d" color="#ffffff">
                <xsl:text>Informatie m.b.t. onderwijsondersteuning, zoals Diagnoses, TLV, OPP, Handelingsplannen, etc.</xsl:text>
            </fo:block>
            <xsl:for-each select="child::od:toelichting_onderwijsbehoeften/od:document">
                <xsl:call-template name="createHeader03">
                    <xsl:with-param name="headerContent">
                        <xsl:text>Toelichting onderwijsbehoeften</xsl:text>
                    </xsl:with-param>
                </xsl:call-template>
                <xsl:choose>
                    <xsl:when test="local-name() = 'document'">
                        <xsl:call-template name="document"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="createDefaultContentTable"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
            <xsl:for-each select="child::od:*">
                <xsl:choose>
                    <xsl:when test="local-name() = 'diagnose'">
                        <xsl:call-template name="diagnose"/>
                    </xsl:when>
                    <xsl:when test="local-name() = 'medicijngebruik'">
                        <xsl:call-template name="createHeader03">
                            <xsl:with-param name="headerContent">
                                <xsl:text>Medicijngebruik</xsl:text>
                            </xsl:with-param>
                        </xsl:call-template>
                        <xsl:call-template name="createDefaultContentTable"/>
                    </xsl:when>
                    <xsl:when test="local-name() = 'handelingsplan'">
                        <xsl:call-template name="handelingsplan"/>
                    </xsl:when>
                    <xsl:when test="local-name() = 'opp'">
                        <xsl:call-template name="ontwikkelingsperspectief"/>
                    </xsl:when>
                    <xsl:when test="local-name() = 'tlv'">
                        <xsl:call-template name="toelaatbaarheidsverklaring"/>
                    </xsl:when>
                    <xsl:when test="local-name() = 'arrangement_cluster12'">
                        <xsl:call-template name="arrangement">
                            <xsl:with-param name="arrType">Cluster 1 &amp; 2</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="local-name() = 'arrangement_pao'">
                        <xsl:call-template name="arrangement">
                            <xsl:with-param name="arrType">(PaO)</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="local-name() = 'lwoo'">
                        <xsl:call-template name="lwoo"/>
                    </xsl:when>
                    <xsl:when test="local-name() = 'rvc'">
                        <xsl:call-template name="rvc"/>
                    </xsl:when>
                </xsl:choose>
            </xsl:for-each>
        </fo:block-container>
    </xsl:template>

    <!-- Onderwijsondersteuning: TLV (toelaatbaarheidsverklaring) -->
    <xsl:template name="toelaatbaarheidsverklaring">
        <fo:block-container>
            <xsl:call-template name="createHeader03">
                <xsl:with-param name="headerContent">
                    <xsl:text>Toelaatbaarheidsverklaring (TLV)</xsl:text>
                </xsl:with-param>
            </xsl:call-template>
            <xsl:for-each select="child::od:*">
                <xsl:choose>
                    <xsl:when test="local-name() = 'tlvcategorie'">
                        <xsl:call-template name="createDefaultContentTable">
                            <xsl:with-param name="codelistType">
                                <xsl:text>tlvcategoriecodelijst</xsl:text>
                            </xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="local-name() = 'document'">
                        <xsl:call-template name="document"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="createDefaultContentTable"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
            <xsl:call-template name="createSpacer"/>
        </fo:block-container>
    </xsl:template>

    <!-- Onderwijsondersteuning: arrangement -->
    <xsl:template name="arrangement">
        <xsl:param name="arrType"/>
        <fo:block-container>
            <xsl:choose>
                <xsl:when test="local-name(preceding-sibling::od:*[1]) = 'arrangement'"/>
                <xsl:otherwise>
                    <xsl:call-template name="createHeader03">
                        <xsl:with-param name="headerContent">
                            <xsl:text>Arrangement </xsl:text>
                            <xsl:value-of select="$arrType"/>
                        </xsl:with-param>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:for-each select="child::od:*">
                <xsl:call-template name="createDefaultContentTable"/>
            </xsl:for-each>
            <xsl:call-template name="createSpacer"/>
        </fo:block-container>
    </xsl:template>

    <!-- Onderwijsondersteuning: OPP (ontwikkelingsperspectief) -->
    <xsl:template name="ontwikkelingsperspectief">
        <fo:block-container>
            <xsl:choose>
                <xsl:when test="local-name(preceding-sibling::od:*[1]) = 'opp'"/>
                <xsl:otherwise>
                    <xsl:call-template name="createHeader03">
                        <xsl:with-param name="headerContent">
                            <xsl:text>Ontwikkelingsperspectief (OPP)</xsl:text>
                        </xsl:with-param>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:for-each select="child::od:*">
                <xsl:choose>
                    <xsl:when test="local-name() = 'document'">
                        <xsl:call-template name="document"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="createDefaultContentTable"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
            <xsl:call-template name="createSpacer"/>
        </fo:block-container>
    </xsl:template>

    <!-- Onderwijsondersteuning: RVC (Regionale Verwijs Commissie) -->
    <xsl:template name="rvc">
        <fo:block-container>
            <xsl:call-template name="createHeader03">
                <xsl:with-param name="headerContent">
                    <xsl:text>Regionale Verwijs Commissie (RVC)</xsl:text>
                </xsl:with-param>
            </xsl:call-template>
            <xsl:for-each select="child::od:*">
                <xsl:choose>
                    <xsl:when test="local-name() = 'document'">
                        <xsl:call-template name="document"/>
                    </xsl:when>
                    <xsl:when test="local-name() = 'rvcindicatie'">
                        <xsl:call-template name="createDefaultContentTable">
                            <xsl:with-param name="codelistType">
                                <xsl:text>rvcindicatiecodelijst</xsl:text>
                            </xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="createDefaultContentTable"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
            <xsl:call-template name="createSpacer"/>
        </fo:block-container>
    </xsl:template>

    <!-- Onderwijsondersteuning: LWOO (Leerweg ondersteunend onderwijs) -->
    <xsl:template name="lwoo">
        <fo:block-container>
            <xsl:call-template name="createHeader03">
                <xsl:with-param name="headerContent">
                    <xsl:text>Leerweg ondersteunend onderwijs (LWOO)</xsl:text>
                </xsl:with-param>
            </xsl:call-template>
            <xsl:for-each select="child::od:*">
                <xsl:choose>
                    <xsl:when test="local-name() = 'document'">
                        <xsl:call-template name="document"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="createDefaultContentTable"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
            <xsl:call-template name="createSpacer"/>
        </fo:block-container>
    </xsl:template>

    <!-- Onderwijsondersteuning: Diagnose -->
    <xsl:template name="diagnose">
        <fo:block-container>
            <xsl:choose>
                <xsl:when test="local-name(preceding-sibling::od:*[1]) = 'diagnose'"/>
                <xsl:otherwise>
                    <xsl:call-template name="createHeader03">
                        <xsl:with-param name="headerContent">
                            <xsl:text>Diagnose</xsl:text>
                        </xsl:with-param>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:for-each select="child::od:*">
                <xsl:choose>
                    <xsl:when test="local-name() = 'code'">
                        <xsl:call-template name="createDefaultContentTable">
                            <xsl:with-param name="codelistType">
                                <xsl:text>diagnosecodelijst</xsl:text>
                            </xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="local-name() = 'document'">
                        <xsl:call-template name="document"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="createDefaultContentTable"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
            <xsl:call-template name="createSpacer"/>
        </fo:block-container>
    </xsl:template>

    <!-- Huisarts (voorheen Zorg: Artsenlijst) -->
    <xsl:template name="huisarts">
        <xsl:call-template name="createHeader02">
            <xsl:with-param name="headerContent">
                <xsl:text>Huisarts</xsl:text>
            </xsl:with-param>
        </xsl:call-template>
        <xsl:for-each select="child::od:*">

            <xsl:choose>
                <xsl:when test="local-name() = 'achternaam'">
                    <xsl:call-template name="createDefaultContentTable"/>
                    <!-- 'soort' verplaatst onder 'achternaam' -->
                    <xsl:for-each select="following-sibling::od:*">
                        <xsl:choose>
                            <xsl:when test="local-name() = 'soort'">
                                <xsl:call-template name="createDefaultContentTable"/>
                            </xsl:when>
                        </xsl:choose>
                    </xsl:for-each>
                </xsl:when>
                <xsl:when test="local-name() = 'adreslijst'">
                    <xsl:call-template name="createAddressList"/>
                </xsl:when>
                <xsl:when test="local-name() = 'communicatielijst'">
                    <xsl:call-template name="createContactInfoList"/>
                </xsl:when>
                <xsl:when test="local-name() = 'soort'"/>
                <xsl:otherwise>
                    <xsl:call-template name="createDefaultContentTable"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>

    <!-- Leerling: Verzuim informatie -->
    <xsl:template name="verzuim">
        <fo:block-container>
            <xsl:call-template name="createHeader01">
                <xsl:with-param name="headerContent">
                    <xsl:text>Verzuim</xsl:text>
                </xsl:with-param>
            </xsl:call-template>
            <fo:block space-after="6pt" space-before="0pt" padding="3pt" font-size="7pt" background-color="#4d4d4d" color="#ffffff">
                <xsl:text>Indicatie van omvang en frequentie van geoorloofd en ongeoorloofd verzuim</xsl:text>
            </fo:block>
            <xsl:for-each select="od:*">
                <xsl:choose>
                    <xsl:when test="local-name() = 'documentLijst'">
                        <xsl:for-each select="child::od:document">
                            <xsl:call-template name="document"/>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="createDefaultContentTable"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </fo:block-container>
    </xsl:template>

    <!-- Leerling: Doorstroomtoets -->
    <xsl:template name="doorstroomtoets">
        <fo:block-container>
            <xsl:call-template name="createHeader01">
                <xsl:with-param name="headerContent">
                    <xsl:text>Doorstroomtoets</xsl:text>
                </xsl:with-param>
            </xsl:call-template>
            <fo:block space-after="6pt" space-before="0pt" padding="3pt" font-size="7pt" background-color="#4d4d4d" color="#ffffff">
                <xsl:text>Resultaten van doorstroomtoets, zoals toetsscore, toetsadvies en referentieniveaus</xsl:text>
            </fo:block>
            <xsl:for-each select="child::od:*">
                <xsl:choose>
                    <xsl:when test="local-name() = 'document'">
                        <xsl:call-template name="document"/>
                    </xsl:when>
                    <xsl:when test="local-name() = 'toetsresultaat'">
                        <xsl:for-each select="child::od:*">
                            <xsl:choose>
                                <xsl:when test="local-name() = 'toetssoort'">
                                    <xsl:call-template name="createDefaultContentTable">
                                        <xsl:with-param name="codelistType">
                                            <xsl:text>toetssoortcodelijst</xsl:text>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                </xsl:when>
                                <xsl:when test="local-name() = 'wettelijke_ontheffing'">
                                    <xsl:call-template name="createDefaultContentTable">
                                        <xsl:with-param name="codelistType">
                                            <xsl:text>wettelijke_ontheffingcodelijst</xsl:text>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                </xsl:when>
                                <xsl:when test="local-name() = 'onderdelen'">
                                    <xsl:call-template name="createHeader03">
                                        <xsl:with-param name="headerContent">
                                            <xsl:text>Onderdelen</xsl:text>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                    <xsl:for-each select="child::od:onderdeel/od:*">
                                        <xsl:choose>
                                            <xsl:when test="local-name() = 'ond_referentieniveau'">
                                                <xsl:call-template name="createDefaultContentTable">
                                                    <xsl:with-param name="codelistType">
                                                        <xsl:text>toetsreferentieniveaucodelijst</xsl:text>
                                                    </xsl:with-param>
                                                </xsl:call-template>
                                            </xsl:when>
                                            <xsl:when test="local-name() = 'onderdeelcode'">
                                                <xsl:call-template name="createDefaultContentTable">
                                                    <xsl:with-param name="codelistType">
                                                        <xsl:text>onderdeelcodeniveaucodelijst</xsl:text>
                                                    </xsl:with-param>
                                                </xsl:call-template>
                                            </xsl:when>
                                            <xsl:when test="local-name() = 'domeinen'">
                                                <xsl:for-each select="child::od:domein">
                                                    <fo:block margin-left="10pt" font-style="italic">
                                                        <xsl:for-each select="child::od:*">
                                                            <xsl:choose>
                                                                <xsl:when test="local-name() = 'domeincode'">
                                                                    <xsl:call-template name="createDefaultContentTable">
                                                                        <xsl:with-param name="codelistType">
                                                                            <xsl:text>domeincodecodelijst</xsl:text>
                                                                        </xsl:with-param>
                                                                    </xsl:call-template>
                                                                </xsl:when>
                                                                <xsl:when test="local-name() = 'dom_referentieniveau'">
                                                                    <xsl:call-template name="createDefaultContentTable">
                                                                        <xsl:with-param name="codelistType">
                                                                            <xsl:text>toetsreferentieniveaucodelijst</xsl:text>
                                                                        </xsl:with-param>
                                                                    </xsl:call-template>
                                                                </xsl:when>
                                                                <xsl:otherwise>
                                                                    <xsl:call-template name="createDefaultContentTable"/>
                                                                </xsl:otherwise>
                                                            </xsl:choose>
                                                        </xsl:for-each>
                                                    </fo:block>
                                                    <xsl:call-template name="createSpacer"/>
                                                </xsl:for-each>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:call-template name="createDefaultContentTable"/>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:for-each>
                                </xsl:when>
                                <xsl:when test="local-name() = 'datum_afname'">
                                    <xsl:call-template name="createDefaultContentTable"/>
                                    <!-- 'deelgenomen' verplaatst onder 'datum afname' -->
                                    <xsl:for-each select="ancestor::od:doorstroomtoets/od:deelgenomen">
                                        <xsl:call-template name="createDefaultContentTable"/>
                                    </xsl:for-each>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:call-template name="createDefaultContentTable"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:when test="local-name() = 'deelgenomen'"/>
                    <xsl:otherwise>
                        <xsl:call-template name="createDefaultContentTable"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </fo:block-container>
    </xsl:template>

    <!-- Leerling: Toetslijst -->
    <xsl:template name="toetslijst">
        <fo:block-container>
            <xsl:call-template name="createHeader01">
                <xsl:with-param name="headerContent">
                    <xsl:text>Toetsresultaten</xsl:text>
                </xsl:with-param>
            </xsl:call-template>
            <fo:block space-after="6pt" space-before="0pt" padding="3pt" font-size="7pt" background-color="#4d4d4d" color="#ffffff">
                <xsl:text>Resultaten van leerling bij landelijk-genormeerde toetsen, anders dan eindtoets/doorstroomtoets</xsl:text>
            </fo:block>
            <xsl:for-each select="child::od:toets">
                <fo:block font-size="6pt">
                    <fo:table border-width="1pt" border-color="#c6c6c6" border-style="solid">
                        <fo:table-column column-number="1" column-width="12%" border-width="1pt" border-color="#c6c6c6" border-style="solid"/>
                        <fo:table-column column-number="2" column-width="10%" border-width="1pt" border-color="#c6c6c6" border-style="solid"/>
                        <fo:table-column column-number="3" border-width="1pt" border-color="#c6c6c6" border-style="solid"/>
                        <fo:table-column column-number="4" column-width="8%" border-width="1pt" border-color="#c6c6c6" border-style="solid"/>
                        <fo:table-column column-number="5" column-width="8%" border-color="#c6c6c6" border-style="solid"/>
                        <fo:table-column column-number="6" column-width="4%" border-width="1pt" border-color="#c6c6c6" border-style="solid"/>
                        <fo:table-column column-number="7" column-width="4%" border-width="1pt" border-color="#c6c6c6" border-style="solid"/>
                        <fo:table-column column-number="8" border-width="1pt" border-color="#c6c6c6" border-style="solid"/>
                        <fo:table-column column-number="9" border-width="1pt" border-color="#c6c6c6" border-style="solid"/>
                        <fo:table-column column-number="10" border-width="1pt" border-color="#c6c6c6" border-style="solid"/>
                        <fo:table-column column-number="11" border-width="1pt" border-color="#c6c6c6" border-style="solid"/>
                        <fo:table-column column-number="12" column-width="4%" border-width="1pt" border-color="#c6c6c6" border-style="solid"/>
                        <fo:table-column column-number="13" border-width="1pt" border-color="#c6c6c6" border-style="solid"/>
                        <fo:table-body>
                            <fo:table-row background-color="#c6c6c6" border-width="1pt" border-color="#c6c6c6" border-style="solid">
                                <fo:table-cell padding="3pt">
                                    <fo:block font-weight="bold" linefeed-treatment="preserve">
                                        <xsl:text>Leergebied</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding="3pt" number-columns-spanned="3">
                                    <fo:block font-weight="bold">
                                        <xsl:text>Toetscode (OSO Toetscodelijst)</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding="3pt" number-columns-spanned="4">
                                    <fo:block font-weight="bold">
                                        <xsl:text>Toetsnaam</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding="3pt" number-columns-spanned="5">
                                    <fo:block font-weight="bold">
                                        <xsl:text>Toetsversie</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row border-width="1pt" border-color="#c6c6c6" border-style="solid">
                                <fo:table-cell padding="3pt">
                                    <fo:block>
                                        <xsl:value-of select="child::od:toetsidentificatie/od:leergebied"/>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding="3pt" number-columns-spanned="3">
                                    <fo:block linefeed-treatment="preserve">
                                        <xsl:value-of select="child::od:toetsidentificatie/od:eldtoetscode"/>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding="3pt" number-columns-spanned="4">
                                    <fo:block>
                                        <xsl:value-of select="child::od:toetsidentificatie/od:toetsnaam"/>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding="3pt" number-columns-spanned="5">
                                    <fo:block>
                                        <xsl:value-of select="child::od:toetsidentificatie/od:toetsversie"/>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row border-width="1pt" border-color="#c6c6c6" border-style="solid">
                                <fo:table-cell padding="3pt">
                                    <fo:block/>
                                </fo:table-cell>
                                <fo:table-cell background-color="#D8D8D8" padding="3pt">
                                    <fo:block font-weight="bold" linefeed-treatment="preserve">
                                        <xsl:text>Afnamedatum</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell background-color="#D8D8D8" padding="3pt">
                                    <fo:block font-weight="bold" linefeed-treatment="preserve">
                                        <xsl:text>DL</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell background-color="#D8D8D8" padding="3pt">
                                    <fo:block font-weight="bold" linefeed-treatment="preserve">
                                        <xsl:text>Leerjaar</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell background-color="#D8D8D8" padding="3pt" number-columns-spanned="2">
                                    <fo:block font-weight="bold" linefeed-treatment="preserve">
                                        <xsl:text>Aantal opgaven</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell background-color="#D8D8D8" padding="3pt" number-columns-spanned="2">
                                    <fo:block font-weight="bold" linefeed-treatment="preserve">
                                        <xsl:text>Aantal goed</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell background-color="#D8D8D8" padding="3pt">
                                    <fo:block font-weight="bold" linefeed-treatment="preserve">
                                        <xsl:text>Aantal fout</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell background-color="#D8D8D8" padding="3pt">
                                    <fo:block font-weight="bold" linefeed-treatment="preserve">
                                        <xsl:text>Gelezen</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell background-color="#D8D8D8" padding="3pt">
                                    <fo:block font-weight="bold" linefeed-treatment="preserve">
                                        <xsl:text>Tijd</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell background-color="#D8D8D8" padding="3pt" number-columns-spanned="2">
                                    <fo:block font-weight="bold" linefeed-treatment="preserve">
                                        <xsl:text>Vaardigheidsscore</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row border-width="1pt" border-color="#c6c6c6" border-style="solid">
                                <fo:table-cell padding="3pt">
                                    <fo:block/>
                                </fo:table-cell>
                                <fo:table-cell padding="3pt">
                                    <fo:block>
                                        <xsl:value-of select="child::od:afname/od:afnamedatum"/>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding="3pt">
                                    <fo:block>
                                        <xsl:value-of select="child::od:afname/od:dl"/>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding="3pt">
                                    <fo:block>
                                        <xsl:value-of select="child::od:afname/od:jaargroep"/>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding="3pt" number-columns-spanned="2">
                                    <fo:block>
                                        <xsl:value-of select="child::od:resultaat/od:toetsscore/od:aantalopgaven"/>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding="3pt" number-columns-spanned="2">
                                    <fo:block>
                                        <xsl:value-of select="child::od:resultaat/od:toetsscore/od:aantalgoed"/>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding="3pt">
                                    <fo:block>
                                        <xsl:value-of select="child::od:resultaat/od:toetsscore/od:aantalfout"/>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding="3pt">
                                    <fo:block>
                                        <xsl:value-of select="child::od:resultaat/od:toetsscore/od:aantalgelezen"/>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding="3pt">
                                    <fo:block>
                                        <xsl:value-of select="child::od:resultaat/od:toetsscore/od:tijd"/>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding="3pt" number-columns-spanned="2">
                                    <fo:block>
                                        <xsl:value-of select="child::od:resultaat/od:toetsscore/od:vaardigheidsscore"/>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                            <xsl:if test="child::od:resultaat/od:referentiescore">
                                <fo:table-row border-width="1pt" border-color="#c6c6c6" border-style="solid">
                                    <fo:table-cell padding="3pt">
                                        <fo:block/>
                                    </fo:table-cell>
                                    <fo:table-cell background-color="#D8D8D8" padding="3pt" number-columns-spanned="3">
                                        <fo:block font-weight="bold">
                                            <xsl:text>Referentiescore</xsl:text>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell background-color="#D8D8D8" padding="3pt" number-columns-spanned="3">
                                        <fo:block font-weight="bold">
                                            <xsl:text>Vergelijkingsgroep</xsl:text>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell background-color="#D8D8D8" padding="3pt">
                                        <fo:block font-weight="bold">
                                            <xsl:text>Waarde</xsl:text>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell background-color="#D8D8D8" padding="3pt" number-columns-spanned="5">
                                        <fo:block font-weight="bold">
                                            <xsl:text>Kwalificatie</xsl:text>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <!-- Referentiescores van de toets -->
                                <xsl:for-each select="child::od:resultaat/od:referentiescore">
                                    <fo:table-row border-width="1pt" border-color="#c6c6c6" border-style="solid">
                                        <fo:table-cell padding="3pt">
                                            <fo:block/>
                                        </fo:table-cell>
                                        <fo:table-cell padding="3pt" number-columns-spanned="3">
                                            <fo:block>
                                                <xsl:call-template name="referentiescorecodelijst"/>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell padding="3pt" number-columns-spanned="3">
                                            <fo:block>
                                                <xsl:call-template name="vergelijkingsgroepcodelijst"/>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell padding="3pt">
                                            <fo:block>
                                                <xsl:value-of select="child::od:waarde"/>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell padding="3pt" number-columns-spanned="5">
                                            <fo:block>
                                                <xsl:value-of select="child::od:kwalificatie"/>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </xsl:for-each>
                            </xsl:if>
                            <!-- Afgenomen door -->
                            <xsl:for-each select="child::od:afname/od:afgenomendoor">
                                <xsl:if test="child::od:naammedewerker">
                                    <fo:table-row border-width="1pt" border-color="#c6c6c6" border-style="solid">
                                        <fo:table-cell background-color="#E3E3E3" padding="3pt">
                                            <fo:block font-weight="bold">Afgenomen door: </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell padding="3pt" number-columns-spanned="3">
                                            <fo:block>
                                                <xsl:value-of select="child::od:naammedewerker"/>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell padding="3pt" number-columns-spanned="4">
                                            <fo:block>
                                                <xsl:value-of select="child::od:functie"/>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell padding="3pt" number-columns-spanned="5">
                                            <fo:block linefeed-treatment="preserve">
                                                <xsl:if test="child::od:werktbijinstelling">
                                                    <xsl:value-of select="child::od:werktbijinstelling/od:instelling/od:naam"/>
                                                    <xsl:text>&#xA;</xsl:text>
                                                    <xsl:value-of select="child::od:werktbijinstelling/od:instelling/od:adreslijst/od:adres/od:straat"/>
                                                    <xsl:text> </xsl:text>
                                                    <xsl:value-of select="child::od:werktbijinstelling/od:instelling/od:adreslijst/od:adres/od:nummer"/>
                                                    <xsl:value-of select="child::od:werktbijinstelling/od:instelling/od:adreslijst/od:adres/od:toevoeging"/>
                                                    <xsl:text>&#xA;</xsl:text>
                                                    <xsl:value-of select="child::od:werktbijinstelling/od:instelling/od:adreslijst/od:adres/od:postcode"/>
                                                    <xsl:text> </xsl:text>
                                                    <xsl:value-of select="child::od:werktbijinstelling/od:instelling/od:adreslijst/od:adres/od:plaats"/>
                                                    <xsl:text>&#xA;</xsl:text>
                                                    <xsl:value-of select="child::od:werktbijinstelling/od:instelling/od:communicatielijst/od:communicatie/od:nummer"/>
                                                </xsl:if>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </xsl:if>
                            </xsl:for-each>
                            <!-- Opmerking bij de toets -->
                            <xsl:for-each select="child::od:opmerking">
                                <fo:table-row border-width="1pt" border-color="#c6c6c6" border-style="solid">
                                    <fo:table-cell background-color="#E3E3E3" padding="3pt">
                                        <fo:block font-weight="bold">Opmerking: </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding="3pt" number-columns-spanned="12">
                                        <fo:block>
                                            <xsl:value-of select="node()"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </xsl:for-each>
                            <!-- Document bijlage van de toets -->
                            <xsl:for-each select="child::od:resultaat/od:document">
                                <fo:table-row border-width="1pt" border-color="#c6c6c6" border-style="solid">
                                    <fo:table-cell background-color="#E3E3E3" padding="3pt">
                                        <fo:block font-weight="bold">Document: </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell background-color="#A9D0F5" padding="3pt" number-columns-spanned="3">
                                        <fo:block font-style="italic">
                                            <xsl:value-of select="child::od:bestandsnaam"/>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell background-color="#A9D0F5" padding="3pt" number-columns-spanned="9">
                                        <fo:block>
                                            <xsl:value-of select="child::od:omschrijving"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </xsl:for-each>
                            <!-- Toetsonderdelen -->
                            <xsl:for-each select="child::od:toetsonderdeel">
                                <xsl:call-template name="toetsonderdeel"/>
                            </xsl:for-each>
                        </fo:table-body>
                    </fo:table>
                </fo:block>
                <xsl:call-template name="createSpacer"/>
            </xsl:for-each>
        </fo:block-container>
    </xsl:template>


    <!-- Leerling: Toets - Toetsonderdeel -->
    <xsl:template name="toetsonderdeel">
        <fo:table-row background-color="#E3E3E3" border-width="1pt" border-color="#c6c6c6" border-style="solid">
            <fo:table-cell background-color="#D3D3D3" padding="3pt">
                <fo:block font-weight="bold">
                    <xsl:text>Toetsonderdeel</xsl:text>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell background-color="#D3D3D3" padding="3pt" number-columns-spanned="3" linefeed-treatment="preserve">
                <fo:block font-weight="bold">
                    <xsl:text>Onderdeelcode&#xA;(OSO Toetscodelijst)</xsl:text>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell background-color="#D3D3D3" padding="3pt" number-columns-spanned="3">
                <fo:block font-weight="bold">
                    <xsl:text>Onderdeelnaam</xsl:text>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell padding="3pt">
                <fo:block font-weight="bold" linefeed-treatment="preserve">
                    <xsl:text>Aantal&#xA;opgaven</xsl:text>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell padding="3pt">
                <fo:block font-weight="bold" linefeed-treatment="preserve">
                    <xsl:text>Aantal&#xA;goed</xsl:text>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell padding="3pt">
                <fo:block font-weight="bold" linefeed-treatment="preserve">
                    <xsl:text>Aantal&#xA;fout</xsl:text>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell padding="3pt">
                <fo:block font-weight="bold" linefeed-treatment="preserve">
                    <xsl:text>Aantal&#xA;gelezen</xsl:text>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell padding="3pt">
                <fo:block font-weight="bold" linefeed-treatment="preserve">
                    <xsl:text>Tijd</xsl:text>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell padding="3pt">
                <fo:block font-weight="bold" linefeed-treatment="preserve">
                    <xsl:text>Vaardig-&#xA;heidsscore</xsl:text>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
        <fo:table-row border-width="1pt" border-color="#c6c6c6" border-style="solid">
            <fo:table-cell padding="3pt">
                <fo:block/>
            </fo:table-cell>
            <fo:table-cell padding="3pt" number-columns-spanned="3">
                <fo:block>
                    <xsl:value-of select="child::od:eldonderdeelcode"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell padding="3pt" number-columns-spanned="3">
                <fo:block linefeed-treatment="preserve">
                    <xsl:value-of select="child::od:onderdeelnaam"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell padding="3pt">
                <fo:block>
                    <xsl:value-of select="child::od:resultaat/od:toetsscore/od:aantalopgaven"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell padding="3pt">
                <fo:block>
                    <xsl:value-of select="child::od:resultaat/od:toetsscore/od:aantalgoed"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell padding="3pt">
                <fo:block>
                    <xsl:value-of select="child::od:resultaat/od:toetsscore/od:aantalfout"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell padding="3pt">
                <fo:block>
                    <xsl:value-of select="child::od:resultaat/od:toetsscore/od:aantalgelezen"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell padding="3pt">
                <fo:block>
                    <xsl:value-of select="child::od:resultaat/od:toetsscore/od:tijd"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell padding="3pt">
                <fo:block>
                    <xsl:value-of select="child::od:resultaat/od:toetsscore/od:vaardigheidsscore"/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
        <!-- Referentiescores toetsonderdeel -->
        <xsl:if test="child::od:resultaat/od:referentiescore">
            <fo:table-row border-width="1pt" border-color="#c6c6c6" border-style="solid">
                <fo:table-cell padding="3pt">
                    <fo:block/>
                </fo:table-cell>
                <fo:table-cell background-color="#E3E3E3" padding="3pt" number-columns-spanned="3">
                    <fo:block font-weight="bold">
                        <xsl:text>Referentiescore</xsl:text>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell background-color="#E3E3E3" padding="3pt" number-columns-spanned="3">
                    <fo:block font-weight="bold">
                        <xsl:text>Vergelijkingsgroep</xsl:text>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell background-color="#E3E3E3" padding="3pt">
                    <fo:block font-weight="bold">
                        <xsl:text>Waarde</xsl:text>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell background-color="#E3E3E3" padding="3pt" number-columns-spanned="5">
                    <fo:block font-weight="bold">
                        <xsl:text>Kwalificatie</xsl:text>
                    </fo:block>
                </fo:table-cell>
            </fo:table-row>
            <!-- Referentiescores van toetsonderdeel -->
            <xsl:for-each select="child::od:resultaat/od:referentiescore">
                <fo:table-row border-width="1pt" border-color="#c6c6c6" border-style="solid">
                    <fo:table-cell padding="3pt">
                        <fo:block/>
                    </fo:table-cell>
                    <fo:table-cell padding="3pt" number-columns-spanned="3">
                        <fo:block>
                            <xsl:call-template name="referentiescorecodelijst"/>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell padding="3pt" number-columns-spanned="3">
                        <fo:block>
                            <xsl:call-template name="vergelijkingsgroepcodelijst"/>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell padding="3pt">
                        <fo:block>
                            <xsl:value-of select="child::od:waarde"/>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell padding="3pt" number-columns-spanned="5">
                        <fo:block>
                            <xsl:value-of select="child::od:kwalificatie"/>
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
            </xsl:for-each>
        </xsl:if>
        <!-- Document bijlage van het toetsonderdeel -->
        <xsl:for-each select="child::od:resultaat/od:document">
            <fo:table-row border-width="1pt" border-color="#c6c6c6" border-style="solid">
                <fo:table-cell padding="3pt">
                    <fo:block/>
                </fo:table-cell>
                <fo:table-cell background-color="#E3E3E3" padding="3pt">
                    <fo:block font-weight="bold">Document: </fo:block>
                </fo:table-cell>
                <fo:table-cell background-color="#A9D0F5" padding="3pt" number-columns-spanned="5">
                    <fo:block font-style="italic">
                        <xsl:value-of select="child::od:bestandsnaam"/>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell background-color="#A9D0F5" padding="3pt" number-columns-spanned="6">
                    <fo:block>
                        <xsl:value-of select="child::od:omschrijving"/>
                    </fo:block>
                </fo:table-cell>
            </fo:table-row>
        </xsl:for-each>

    </xsl:template>


    <!-- Leerling: Toetslijst - toetsresultaat -->
    <xsl:template name="toetslijstresultaat">
        <fo:block-container>
            <fo:block font-weight="bold">
                <xsl:text>Resultaat:</xsl:text>
            </fo:block>
            <xsl:for-each select="child::od:*">
                <xsl:choose>
                    <xsl:when test="local-name() = 'document'">
                        <xsl:call-template name="document"/>
                    </xsl:when>
                    <xsl:when test="local-name() = 'referentiescore'">
                        <fo:block font-style="italic">
                            <xsl:text>Referentiescore:</xsl:text>
                        </fo:block>
                        <fo:block margin-left="10pt" font-style="italic">
                            <xsl:for-each select="child::od:*">
                                <xsl:choose>
                                    <xsl:when test="local-name() = 'codereferentiescore'">
                                        <xsl:call-template name="createDefaultContentTable">
                                            <xsl:with-param name="codelistType">referentiescorecodelijst</xsl:with-param>
                                        </xsl:call-template>
                                    </xsl:when>
                                    <xsl:when test="local-name() = 'codevergelijkingsgroep'">
                                        <xsl:call-template name="createDefaultContentTable">
                                            <xsl:with-param name="codelistType">vergelijkingsgroepcodelijst</xsl:with-param>
                                        </xsl:call-template>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:call-template name="createDefaultContentTable"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:for-each>
                        </fo:block>
                        <xsl:call-template name="createSpacer"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="createDefaultContentTable"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </fo:block-container>
    </xsl:template>


    <!-- Leerling: Handelingsplan -->
    <xsl:template name="handelingsplan">
        <fo:block-container>
            <xsl:call-template name="createHeader02">
                <xsl:with-param name="headerContent">
                    <xsl:text>Handelingsplan</xsl:text>
                </xsl:with-param>
            </xsl:call-template>
            <xsl:for-each select="child::od:*">
                <xsl:choose>
                    <xsl:when test="local-name() = 'document'">
                        <xsl:call-template name="document"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="createDefaultContentTable"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </fo:block-container>
    </xsl:template>

    <!-- Leerling: Cijferlijst -->
    <xsl:template name="cijferLijst">
        <fo:block-container>
            <xsl:call-template name="createHeader02">
                <xsl:with-param name="headerContent">
                    <xsl:text>Cijferlijst</xsl:text>
                </xsl:with-param>
            </xsl:call-template>
            <xsl:for-each select="child::od:*">
                <xsl:choose>
                    <xsl:when test="local-name() = 'onderdeel'"/>
                    <xsl:when test="local-name() = 'cijferlijstTypelijst'"/>
                    <xsl:when test="local-name() = 'jaargroep'">
                        <xsl:call-template name="createDefaultContentTable">
                            <xsl:with-param name="codelistType">jaargroepcodelijst</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="createDefaultContentTable"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
            <xsl:for-each select="child::od:cijferlijstTypelijst">
                <fo:block font-size="8pt">
                    <fo:table border="0pt">
                        <fo:table-header>
                            <fo:table-row background-color="#D8D8D8">
                                <fo:table-cell padding="3pt">
                                    <fo:block font-weight="bold">
                                        <xsl:text>Naam</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding="3pt">
                                    <fo:block font-weight="bold">
                                        <xsl:text>Score</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding="3pt">
                                    <fo:block font-weight="bold">
                                        <xsl:text>Kwalificatie</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding="3pt">
                                    <fo:block font-weight="bold">
                                        <xsl:text>Afnamedatum</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding="3pt">
                                    <fo:block font-weight="bold" text-align="center">
                                        <xsl:text>Jaargroep</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding="3pt">
                                    <fo:block font-weight="bold" text-align="center">
                                        <xsl:text>Periode</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                        </fo:table-header>
                        <fo:table-body>
                            <xsl:for-each select="child::od:onderdeel">
                                <fo:table-row>
                                    <fo:table-cell padding="3pt">
                                        <fo:block>
                                            <xsl:value-of select="child::od:naam"/>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding="3pt">
                                        <fo:block>
                                            <xsl:value-of select="child::od:score/od:waarde"/>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding="3pt">
                                        <fo:block>
                                            <xsl:value-of select="child::od:score/od:kwalificatie"/>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding="3pt">
                                        <fo:block>
                                            <xsl:value-of select="child::od:afnamedatum"/>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding="3pt">
                                        <fo:block text-align="center">
                                            <xsl:for-each select="child::od:jaargroep">
                                                <xsl:call-template name="jaargroepcodelijst"/>
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding="3pt">
                                        <fo:block text-align="center">
                                            <xsl:value-of select="child::od:periode"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </xsl:for-each>
                            <xsl:for-each select="child::od:naam">
                                <fo:table-row>
                                    <fo:table-cell padding="3pt">
                                        <fo:block>
                                            <xsl:value-of select="node()"/>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding="3pt">
                                        <fo:block>
                                            <xsl:value-of select=" following-sibling::od:score[1]/od:waarde"/>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding="3pt">
                                        <fo:block/>
                                    </fo:table-cell>
                                    <fo:table-cell padding="3pt">
                                        <fo:block/>
                                    </fo:table-cell>
                                    <fo:table-cell padding="3pt">
                                        <fo:block/>
                                    </fo:table-cell>
                                    <fo:table-cell padding="3pt">
                                        <fo:block/>
                                    </fo:table-cell>
                                </fo:table-row>
                            </xsl:for-each>
                        </fo:table-body>
                    </fo:table>
                </fo:block>
            </xsl:for-each>
            <xsl:call-template name="createSpacer"/>
        </fo:block-container>
    </xsl:template>

    <!-- Leerling: Verzorger informatie -->
    <xsl:template name="verzorger">
        <fo:block-container>
            <xsl:call-template name="createHeader02">
                <xsl:with-param name="headerContent">
                    <xsl:text>Ouder/Verzorger</xsl:text>
                </xsl:with-param>
            </xsl:call-template>
            <xsl:for-each select="child::od:*">
                <xsl:choose>
                    <xsl:when test="local-name() = 'achternaam'">
                        <xsl:call-template name="createDefaultContentTable"/>
                        <!-- 'relatietotkind' verplaatst onder 'achternaam' -->
                        <!-- 20260114 veld banknummer verwijderd uit gegevensset voor versie 2026.1 -->
                        <xsl:for-each select="following-sibling::od:*">
                            <xsl:choose>
                                <xsl:when test="local-name() = 'relatietotkind'">
                                    <xsl:call-template name="createDefaultContentTable">
                                        <xsl:with-param name="codelistType">
                                            <xsl:text>relatietotkindcodelijst</xsl:text>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                </xsl:when>
                                <xsl:when
                                    test="local-name() = 'wettigevertegenwoordiger' or local-name() = 'banknummer' or local-name() = 'iban' or local-name() = 'overleden' or local-name() = 'overlijdensdatum'">
                                    <xsl:call-template name="createDefaultContentTable"/>
                                </xsl:when>
                            </xsl:choose>
                        </xsl:for-each>
                    </xsl:when>
                    <!-- Adressen verzorger -->
                    <xsl:when test="local-name() = 'adreslijst'">
                        <xsl:call-template name="createAddressList"/>
                    </xsl:when>
                    <!-- Contactgegevens verzorger -->
                    <!-- 20260114 veld banknummer verwijderd uit gegevensset voor versie 2026.1 -->
                    <xsl:when test="local-name() = 'communicatielijst'">
                        <xsl:call-template name="createContactInfoList"/>
                    </xsl:when>
                    <xsl:when test="local-name() = 'overleden' and preceding-sibling::od:geslacht"/>
                    <xsl:when test="local-name() = 'overlijdensdatum' and preceding-sibling::od:geslacht"/>
                    <xsl:when test="local-name() = 'relatietotkind' and preceding-sibling::od:geslacht"/>
                    <xsl:when test="local-name() = 'wettigevertegenwoordiger' and preceding-sibling::od:geslacht"/>
                    <xsl:when test="local-name() = 'banknummer' and preceding-sibling::od:geslacht"/>
                    <xsl:when test="local-name() = 'iban' and preceding-sibling::od:geslacht"/>
                    <!-- Overige elementen stage -->
                    <xsl:otherwise>
                        <xsl:call-template name="createDefaultContentTable"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
            <xsl:if test="following-sibling::od:verzorger">
                <xsl:call-template name="createSpacer"/>
            </xsl:if>
        </fo:block-container>
    </xsl:template>

    <!-- Maak een overzicht van een document -->
    <xsl:template name="document">
        <fo:block>
            <fo:table border="0pt" background-color="#D8D8D8">
                <fo:table-column column-width="10%"/>
                <fo:table-column column-width="35%"/>
                <fo:table-column column-width="55%"/>
                <fo:table-body>
                    <fo:table-row>
                        <fo:table-cell padding="2pt">
                            <fo:block>
                                <xsl:text>Document:</xsl:text>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell background-color="#A9D0F5" padding="2pt">
                            <fo:block font-style="italic">
                                <xsl:value-of select="child::od:bestandsnaam"/>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell background-color="#A9D0F5" padding="2pt">
                            <fo:block>
                                <xsl:value-of select="child::od:omschrijving"/>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>
        </fo:block>
    </xsl:template>

    <!-- Maak een generieke adressenlijst -->
    <xsl:template name="createAddressList">
        <!-- 20250523 blok buitenlandadres toegevoegd -->
        <xsl:for-each select="child::od:*">
            <xsl:choose>
                <xsl:when test="local-name() = 'adres'">
                    <xsl:call-template name="createHeader03">
                        <xsl:with-param name="headerContent">
                            <xsl:value-of select="child::od:soortadres"/>
                            <xsl:text> adres</xsl:text>
                        </xsl:with-param>
                    </xsl:call-template>
                    <xsl:for-each select="child::od:*">
                        <xsl:choose>
                            <xsl:when test="local-name() = 'soortadres'"/>
                            <xsl:when test="local-name() = 'aanduiding'">
                                <xsl:call-template name="createDefaultContentTable">
                                    <xsl:with-param name="codelistType">adresaanduidingcodelijst</xsl:with-param>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:when test="local-name() = 'land'">
                                <xsl:call-template name="createDefaultContentTable">
                                    <xsl:with-param name="codelistType">landcodelijst</xsl:with-param>
                                </xsl:call-template>
                            </xsl:when>
                            <!--<xsl:when test="local-name() = 'land'"/>-->
                            <xsl:otherwise>
                                <xsl:call-template name="createDefaultContentTable"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:for-each>
                </xsl:when>
                <xsl:when test="local-name() = 'buitenlandadres'">
                    <xsl:call-template name="createHeader03">
                        <xsl:with-param name="headerContent">
                            <xsl:value-of select="child::od:soortadres"/>
                            <xsl:text> buitenlands adres</xsl:text>
                        </xsl:with-param>
                    </xsl:call-template>
                    <xsl:for-each select="child::od:*">
                        <xsl:choose>
                            <xsl:when test="local-name() = 'soortadres'"/>
                            <xsl:when test="local-name() = 'land'">
                                <xsl:call-template name="createDefaultContentTable">
                                    <xsl:with-param name="codelistType">landcodelijst</xsl:with-param>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:call-template name="createDefaultContentTable"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="createDefaultContentTable"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>

    <!-- Maak een generieke lijst met contactinformatie -->
    <xsl:template name="createContactInfoList">
        <xsl:for-each select="child::od:communicatie">
            <xsl:call-template name="createHeader03">
                <xsl:with-param name="headerContent">
                    <xsl:value-of select="child::od:soort"/>
                </xsl:with-param>
            </xsl:call-template>
            <xsl:for-each select="child::od:*">
                <xsl:choose>
                    <xsl:when test="local-name() = 'soort'"/>
                    <xsl:otherwise>
                        <xsl:call-template name="createDefaultContentTable"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </xsl:for-each>
    </xsl:template>



    <!-- Generieke tabel voor het weergeven van de content -->
    <xsl:template name="createDefaultContentTable">
        <xsl:param name="codelistType"/>
        <fo:block>
            <fo:table border="0pt">
                <fo:table-column column-width="30%"/>
                <fo:table-column column-width="70%"/>
                <fo:table-body>
                    <xsl:choose>
                        <!-- elementen met child elementen -->
                        <xsl:when test="child::od:*">
                            <xsl:for-each select="child::od:*">
                                <xsl:if test="not(child::od:*)">
                                    <fo:table-row>
                                        <fo:table-cell padding="1pt">
                                            <fo:block>
                                                <xsl:value-of select="local-name()"/>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell padding="1pt">
                                            <fo:block>
                                                <xsl:choose>
                                                    <xsl:when test="$codelistType = 'adresaanduidingcodelijst'">
                                                        <xsl:call-template name="adresaanduidingcodelijst"/>
                                                    </xsl:when>
                                                    <xsl:when test="$codelistType = 'voorschoolscodelijst'">
                                                        <xsl:call-template name="voorschoolscodelijst">
                                                            <xsl:with-param name="codeType">
                                                                <xsl:value-of select="local-name()"/>
                                                            </xsl:with-param>
                                                            <xsl:with-param name="codeValue">
                                                                <xsl:value-of select="node()"/>
                                                            </xsl:with-param>
                                                        </xsl:call-template>
                                                    </xsl:when>
                                                    <xsl:when test="$codelistType = 'akkoordcodelijst'">
                                                        <xsl:call-template name="akkoordcodelijst"/>
                                                    </xsl:when>
                                                    <xsl:when test="$codelistType = 'toestemmingcodelijst'">
                                                        <xsl:call-template name="toestemmingcodelijst"/>
                                                    </xsl:when>
                                                    <xsl:when test="$codelistType = 'overstapadviescodelijst'">
                                                        <xsl:call-template name="overstapadviescodelijst"/>
                                                    </xsl:when>
                                                    <xsl:when test="$codelistType = 'overstapadviesprofiellijst'">
                                                        <xsl:call-template name="overstapadviesprofiellijst"/>
                                                    </xsl:when>
                                                    <xsl:when test="$codelistType = 'toetsreferentieniveaucodelijst'">
                                                        <xsl:call-template name="toetsreferentieniveaucodelijst"/>
                                                    </xsl:when>
                                                    <xsl:when test="$codelistType = 'toetssoortcodelijst'">
                                                        <xsl:call-template name="toetssoortcodelijst"/>
                                                    </xsl:when>
                                                    <xsl:when test="$codelistType = 'wettelijke_ontheffingcodelijst'">
                                                        <xsl:call-template name="wettelijke_ontheffingcodelijst"/>
                                                    </xsl:when>
                                                    <xsl:when test="$codelistType = 'onderdeelcodeniveaucodelijst'">
                                                        <xsl:call-template name="onderdeelcodeniveaucodelijst"/>
                                                    </xsl:when>
                                                    <xsl:when test="$codelistType = 'domeincodecodelijst'">
                                                        <xsl:call-template name="domeincodecodelijst"/>
                                                    </xsl:when>
                                                    <xsl:when test="$codelistType = 'opleidingskenmerkenlijst'">
                                                        <xsl:call-template name="opleidingskenmerkenlijst"/>
                                                    </xsl:when>
                                                    <xsl:when test="$codelistType = 'jaargroepcodelijst'">
                                                        <xsl:call-template name="jaargroepcodelijst"/>
                                                    </xsl:when>
                                                    <xsl:when test="$codelistType = 'vergelijkingsgroepcodelijst'">
                                                        <xsl:call-template name="vergelijkingsgroepcodelijst"/>
                                                    </xsl:when>
                                                    <xsl:when test="$codelistType = 'referentiescorecodelijst'">
                                                        <xsl:call-template name="referentiescorecodelijst"/>
                                                    </xsl:when>
                                                    <xsl:when test="$codelistType = 'tlvcategoriecodelijst'">
                                                        <xsl:call-template name="tlvcategoriecodelijst"/>
                                                    </xsl:when>
                                                    <xsl:when test="$codelistType = 'rvcindicatiecodelijst'">
                                                        <xsl:call-template name="rvcindicatiecodelijst"/>
                                                    </xsl:when>
                                                    <xsl:when test="$codelistType = 'diagnosecodelijst'">
                                                        <xsl:call-template name="diagnosecodelijst"/>
                                                    </xsl:when>
                                                    <xsl:when test="$codelistType = 'nncacodelijst'">
                                                        <xsl:call-template name="nncacodelijst"/>
                                                    </xsl:when>
                                                    <xsl:when test="$codelistType = 'landcodelijst'">
                                                        <xsl:call-template name="landcodelijst">
                                                            <xsl:with-param name="omschrijvingTekst">
                                                                <xsl:value-of select="@omschrijving"/>
                                                            </xsl:with-param>
                                                        </xsl:call-template>
                                                    </xsl:when>
                                                    <xsl:when test="$codelistType = 'nationaliteitcodelijst'">
                                                        <xsl:call-template name="nationaliteitcodelijst"/>
                                                    </xsl:when>
                                                    <xsl:when test="$codelistType = 'relatietotkindcodelijst'">
                                                        <xsl:call-template name="relatietotkindcodelijst"/>
                                                    </xsl:when>
                                                    <xsl:when test="local-name() = 'geslacht'">
                                                        <xsl:call-template name="geslachtcodelijst"/>
                                                    </xsl:when>
                                                    <xsl:when test="node() = 'false'">
                                                        <xsl:text>nee</xsl:text>
                                                    </xsl:when>
                                                    <xsl:when test="node() = 'true'">
                                                        <xsl:text>ja</xsl:text>
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <xsl:value-of select="node()"/>
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </xsl:if>
                            </xsl:for-each>
                        </xsl:when>
                        <!-- elementen zonder child elementen -->
                        <xsl:otherwise>
                            <fo:table-row>
                                <fo:table-cell padding="1pt">
                                    <fo:block>
                                        <xsl:value-of select="local-name()"/>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell padding="1pt">
                                    <fo:block>
                                        <xsl:choose>
                                            <xsl:when test="$codelistType = 'adresaanduidingcodelijst'">
                                                <xsl:call-template name="adresaanduidingcodelijst"/>
                                            </xsl:when>
                                            <xsl:when test="$codelistType = 'voorschoolscodelijst'">
                                                <xsl:call-template name="voorschoolscodelijst">
                                                    <xsl:with-param name="codeType">
                                                        <xsl:value-of select="local-name()"/>
                                                    </xsl:with-param>
                                                    <xsl:with-param name="codeValue">
                                                        <xsl:value-of select="node()"/>
                                                    </xsl:with-param>
                                                </xsl:call-template>
                                            </xsl:when>
                                            <xsl:when test="$codelistType = 'akkoordcodelijst'">
                                                <xsl:call-template name="akkoordcodelijst"/>
                                            </xsl:when>
                                            <xsl:when test="$codelistType = 'toestemmingcodelijst'">
                                                <xsl:call-template name="toestemmingcodelijst"/>
                                            </xsl:when>
                                            <xsl:when test="$codelistType = 'overstapadviescodelijst'">
                                                <xsl:call-template name="overstapadviescodelijst"/>
                                            </xsl:when>
                                            <xsl:when test="$codelistType = 'overstapadviesprofiellijst'">
                                                <xsl:call-template name="overstapadviesprofiellijst"/>
                                            </xsl:when>
                                            <xsl:when test="$codelistType = 'toetsreferentieniveaucodelijst'">
                                                <xsl:call-template name="toetsreferentieniveaucodelijst"/>
                                            </xsl:when>
                                            <xsl:when test="$codelistType = 'toetssoortcodelijst'">
                                                <xsl:call-template name="toetssoortcodelijst"/>
                                            </xsl:when>
                                            <xsl:when test="$codelistType = 'wettelijke_ontheffingcodelijst'">
                                                <xsl:call-template name="wettelijke_ontheffingcodelijst"/>
                                            </xsl:when>
                                            <xsl:when test="$codelistType = 'onderdeelcodeniveaucodelijst'">
                                                <xsl:call-template name="onderdeelcodeniveaucodelijst"/>
                                            </xsl:when>
                                            <xsl:when test="$codelistType = 'domeincodecodelijst'">
                                                <xsl:call-template name="domeincodecodelijst"/>
                                            </xsl:when>
                                            <xsl:when test="$codelistType = 'opleidingskenmerkenlijst'">
                                                <xsl:call-template name="opleidingskenmerkenlijst"/>
                                            </xsl:when>
                                            <xsl:when test="$codelistType = 'jaargroepcodelijst'">
                                                <xsl:call-template name="jaargroepcodelijst"/>
                                            </xsl:when>
                                            <xsl:when test="$codelistType = 'vergelijkingsgroepcodelijst'">
                                                <xsl:call-template name="vergelijkingsgroepcodelijst"/>
                                            </xsl:when>
                                            <xsl:when test="$codelistType = 'referentiescorecodelijst'">
                                                <xsl:call-template name="referentiescorecodelijst"/>
                                            </xsl:when>
                                            <xsl:when test="$codelistType = 'tlvcategoriecodelijst'">
                                                <xsl:call-template name="tlvcategoriecodelijst"/>
                                            </xsl:when>
                                            <xsl:when test="$codelistType = 'rvcindicatiecodelijst'">
                                                <xsl:call-template name="rvcindicatiecodelijst"/>
                                            </xsl:when>
                                            <xsl:when test="$codelistType = 'diagnosecodelijst'">
                                                <xsl:call-template name="diagnosecodelijst"/>
                                            </xsl:when>
                                            <xsl:when test="$codelistType = 'nncacodelijst'">
                                                <xsl:call-template name="nncacodelijst"/>
                                            </xsl:when>
                                            <xsl:when test="$codelistType = 'landcodelijst'">
                                                <xsl:call-template name="landcodelijst">
                                                    <xsl:with-param name="omschrijvingTekst">
                                                        <xsl:value-of select="@omschrijving"/>
                                                    </xsl:with-param>
                                                </xsl:call-template>
                                            </xsl:when>
                                            <xsl:when test="$codelistType = 'nationaliteitcodelijst'">
                                                <xsl:call-template name="nationaliteitcodelijst"/>
                                            </xsl:when>
                                            <xsl:when test="$codelistType = 'relatietotkindcodelijst'">
                                                <xsl:call-template name="relatietotkindcodelijst"/>
                                            </xsl:when>
                                            <xsl:when test="local-name() = 'geslacht'">
                                                <xsl:call-template name="geslachtcodelijst"/>
                                            </xsl:when>
                                            <xsl:when test="node() = 'false'">
                                                <xsl:text>nee</xsl:text>
                                            </xsl:when>
                                            <xsl:when test="node() = 'true'">
                                                <xsl:text>ja</xsl:text>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:value-of select="node()"/>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                        </xsl:otherwise>
                    </xsl:choose>

                </fo:table-body>
            </fo:table>
        </fo:block>
    </xsl:template>

    <!-- Maak een titel 01 aan -->
    <xsl:template name="createHeader01">
        <xsl:param name="headerContent"/>
        <fo:block space-after="0pt" space-before="15pt" padding="3pt" font-size="12pt" font-weight="bold" background-color="#4d4d4d" color="#ffffff">
            <xsl:value-of select="$headerContent"/>
        </fo:block>
    </xsl:template>

    <!-- Maak een titel 02 aan -->
    <xsl:template name="createHeader02">
        <xsl:param name="headerContent"/>
        <fo:block space-after="3pt" space-before="10pt" padding="3pt" font-size="10pt" font-weight="bold" background-color="#999999">
            <xsl:value-of select="$headerContent"/>
        </fo:block>
    </xsl:template>

    <!-- Maak een titel 03 aan -->
    <xsl:template name="createHeader03">
        <xsl:param name="headerContent"/>
        <fo:block space-after="3pt" space-before="8pt" padding="3pt" font-size="9pt" font-weight="bold" background-color="#D8D8D8">
            <xsl:value-of select="$headerContent"/>
        </fo:block>
    </xsl:template>

    <!-- Maak een leeg block -->
    <xsl:template name="createSpacer">
        <fo:block space-after="10pt"/>
    </xsl:template>

    <!-- Maak een grijze scheidslijn -->
    <xsl:template name="createSeparator">
        <fo:block space-after="6pt" space-before="6pt" font-size="2pt" background-color="#6E6E6E">
            <xsl:text>&#xa0;</xsl:text>
        </fo:block>
    </xsl:template>



    <!-- Bestandsinhoud element wordt altijd verwijderd -->
    <xsl:template match="od:bestandsinhoud"/>

    <!-- Template voor het tonen van blokken binnen categorie uitlevering -->
    <xsl:template name="categorie_uitlevering_row_template">
        <xsl:param name="categorieNaam"/>

        <fo:table-row>
            <fo:table-cell padding="2pt">
                <fo:block>
                    <xsl:call-template name="categorie_uitleveringlijst">
                        <xsl:with-param name="codeValue">
                            <xsl:value-of select="$categorieNaam"/>
                        </xsl:with-param>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <xsl:choose>
                <xsl:when test="od:*/text()=$categorieNaam">
                    <fo:table-cell padding="2pt">
                        <fo:block>
                            <xsl:for-each select="od:*[text()=$categorieNaam]">
                                <xsl:if test="node()=$categorieNaam">
                                    <xsl:call-template name="categorie_uitlevering_taglijst">
                                        <xsl:with-param name="tagName">
                                            <xsl:value-of select="local-name()"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                    <xsl:if test="position() != last()">
                                        <xsl:text>, </xsl:text>
                                    </xsl:if>
                                </xsl:if>
                            </xsl:for-each>
                        </fo:block>
                    </fo:table-cell>
                </xsl:when>
                <xsl:otherwise>
                    <fo:table-cell padding="2pt">
                        <fo:block>Geen categorieën van dit type</fo:block>
                    </fo:table-cell>
                </xsl:otherwise>
            </xsl:choose>
        </fo:table-row>
    </xsl:template>



    <!-- ===================================================== -->
    <!--                      CODELIJSTEN                      -->
    <!-- ===================================================== -->

    <!-- Deeldossier codelijst 33 -->
    <xsl:template name="deeldossierlijst">
        <xsl:param name="codeValue"/>

        <xsl:choose>
            <xsl:when test="$codeValue = 'LAS'">
                <xsl:text>Leerling administratie systeem</xsl:text>
            </xsl:when>
            <xsl:when test="$codeValue = 'LVS'">
                <xsl:text>Leerling volg systeem</xsl:text>
            </xsl:when>
            <xsl:when test="$codeValue = 'LASLVS'">
                <xsl:text>Leerling administratie systeem en Leerling volg systeem</xsl:text>
            </xsl:when>
            <xsl:when test="$codeValue = 'TIB'">
                <xsl:text>Terugkoppel Informatie Bericht</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <fo:inline color="red">
                    <xsl:value-of select="$codeValue"/>
                </fo:inline>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <!-- Categorie uitlevering XML-tag -->
    <xsl:template name="categorie_uitlevering_taglijst">
        <xsl:param name="tagName"/>
        <xsl:choose>
            <xsl:when test="$tagName = 'cat_metadata'">
                <xsl:text>Metadata</xsl:text>
            </xsl:when>
            <xsl:when test="$tagName = 'cat_ouderinzage'">
                <xsl:text>Ouderinzage</xsl:text>
            </xsl:when>
            <xsl:when test="$tagName = 'cat_school'">
                <xsl:text>School</xsl:text>
            </xsl:when>
            <xsl:when test="$tagName = 'cat_leerling'">
                <xsl:text>Leerling</xsl:text>
            </xsl:when>
            <xsl:when test="$tagName = 'cat_oudersverzorgers'">
                <xsl:text>Ouders/Verzorgers</xsl:text>
            </xsl:when>
            <xsl:when test="$tagName = 'cat_vve'">
                <xsl:text>VVE</xsl:text>
            </xsl:when>
            <xsl:when test="$tagName = 'cat_schoolloopbaan'">
                <xsl:text>Schoolloopbaan</xsl:text>
            </xsl:when>
            <xsl:when test="$tagName = 'cat_overstapadvies'">
                <xsl:text>Overstapadvies</xsl:text>
            </xsl:when>
            <xsl:when test="$tagName = 'cat_onderwijsondersteuning'">
                <xsl:text>Onderwijsondersteuning</xsl:text>
            </xsl:when>
            <xsl:when test="$tagName = 'cat_verzuim'">
                <xsl:text>Verzuim</xsl:text>
            </xsl:when>
            <xsl:when test="$tagName = 'cat_doorstroomtoets'">
                <xsl:text>Doorstroomtoets</xsl:text>
            </xsl:when>
            <xsl:when test="$tagName = 'cat_toetsresultaten'">
                <xsl:text>Toetsresultaten</xsl:text>
            </xsl:when>
            <xsl:when test="$tagName = 'cat_handelingsplannen'">
                <xsl:text>Handelingsplannen</xsl:text>
            </xsl:when>
            <xsl:when test="$tagName = 'cat_cijferlijsten'">
                <xsl:text>Cijferlijsten</xsl:text>
            </xsl:when>
            <xsl:when test="$tagName = 'cat_bijlagedocs'">
                <xsl:text>Bijlagedocumenten</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <fo:inline color="red">
                    <xsl:value-of select="$tagName"/>
                </fo:inline>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <!-- Categorie uitlevering codelijst 48 -->
    <xsl:template name="categorie_uitleveringlijst">
        <xsl:param name="codeValue"/>
        <xsl:choose>
            <xsl:when test="$codeValue = 'VERPLICHT'">
                <xsl:text>Verplicht (opgenomen)</xsl:text>
            </xsl:when>
            <xsl:when test="$codeValue = 'VERBODEN'">
                <xsl:text>Verboden (niet opgenomen)</xsl:text>
            </xsl:when>
            <xsl:when test="$codeValue = 'OPT-UIT'">
                <xsl:text>Bewust niet opgenomen</xsl:text>
            </xsl:when>
            <xsl:when test="$codeValue = 'OPTIONEEL'">
                <xsl:text>Bewust opgenomen</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <fo:inline color="red">Onbekende waarde: <xsl:value-of select="$codeValue"/></fo:inline>
            </xsl:otherwise>

        </xsl:choose>

    </xsl:template>

    <!-- Overdrachtsoort codelijst 29 -->
    <xsl:template name="overdrachtsoortcodelijst">
        <xsl:param name="codeValue"/>

        <xsl:choose>
            <xsl:when test="$codeValue = 'overstapdossier'">
                <xsl:text>Dossier wordt overgedragen aan een andere school</xsl:text>
            </xsl:when>
            <xsl:when test="$codeValue = 'overdrachtbinnenbrin'">
                <xsl:text>Dossier wordt binnen de school overgedragen</xsl:text>
            </xsl:when>
            <xsl:when test="$codeValue = 'swv-dossier'">
                <xsl:text>Dossier wordt binnen de school t.b.v. SWV overgedragen</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <fo:inline color="red">
                    <xsl:value-of select="$codeValue"/>
                </fo:inline>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <!-- Overstap codelijst 16 -->
    <xsl:template name="overstapcodelijst">
        <xsl:param name="codeValue"/>

        <xsl:choose>
            <xsl:when test="$codeValue = 'VSPO'">
                <xsl:text>van voorschool naar primair onderwijs</xsl:text>
            </xsl:when>
            <xsl:when test="$codeValue = 'VSWEC'">
                <xsl:text>van voorschool naar WEC school</xsl:text>
            </xsl:when>
            <xsl:when test="$codeValue = 'POPO'">
                <xsl:text>van primair onderwijs naar andere school PO</xsl:text>
            </xsl:when>
            <xsl:when test="$codeValue = 'POWEC'">
                <xsl:text>van primair onderwijs naar WEC school</xsl:text>
            </xsl:when>
            <xsl:when test="$codeValue = 'POVO'">
                <xsl:text>van primair onderwijs naar voortgezet onderwijs</xsl:text>
            </xsl:when>
            <xsl:when test="$codeValue = 'VOVO'">
                <xsl:text>van voortgezet onderwijs naar andere school VO</xsl:text>
            </xsl:when>
            <xsl:when test="$codeValue = 'VOMBO'">
                <xsl:text>van voortgezet onderwijs naar MBO</xsl:text>
            </xsl:when>
            <xsl:when test="$codeValue = 'VOHBO'">
                <xsl:text>van voortgezet onderwijs naar HBO</xsl:text>
            </xsl:when>
            <xsl:when test="$codeValue = 'VOWO'">
                <xsl:text>van voortgezet onderwijs naar WO</xsl:text>
            </xsl:when>
            <xsl:when test="$codeValue = 'WECWEC'">
                <xsl:text>van WEC school naar andere school WEC</xsl:text>
            </xsl:when>
            <xsl:when test="$codeValue = 'WECVO'">
                <xsl:text>van WEC school naar voortgezet onderwijs</xsl:text>
            </xsl:when>
            <xsl:when test="$codeValue = 'WECMBO'">
                <xsl:text>van WEC school naar MBO</xsl:text>
            </xsl:when>
            <xsl:when test="$codeValue = 'WECHBO'">
                <xsl:text>van WEC school naar andere HBO</xsl:text>
            </xsl:when>
            <xsl:when test="$codeValue = 'WECWO'">
                <xsl:text>van WEC school naar WO</xsl:text>
            </xsl:when>
            <xsl:when test="$codeValue = 'POSWV'">
                <xsl:text>van PO naar passend onderwijs samenwerkingsverband (SWV)</xsl:text>
            </xsl:when>
            <xsl:when test="$codeValue = 'VOSWV'">
                <xsl:text>van VO naar passend onderwijs samenwerkingsverband (SWV)</xsl:text>
            </xsl:when>
            <xsl:when test="$codeValue = 'OVERIG'">
                <xsl:text>andere overstap</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <fo:inline color="red">
                    <xsl:value-of select="$codeValue"/>
                </fo:inline>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <!-- Akkoord codelijst 37A -->
    <xsl:template name="akkoordcodelijst">

        <xsl:choose>
            <xsl:when test="node() = 'Ja'">
                <xsl:text>Ouders/verzorgers zijn akkoord met de inhoud</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'Nee'">
                <xsl:text>Ouders/verzorgers zijn niet akkoord met de inhoud</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'Onbekend'">
                <xsl:text>Het is onbekend of ouders/verzorgers het eens zijn met de inhoud</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <fo:inline color="red">
                    <xsl:value-of select="node()"/>
                </fo:inline>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <!-- Toestemming codelijst 37B -->
    <xsl:template name="toestemmingcodelijst">

        <xsl:choose>
            <xsl:when test="node() = 'Ja'">
                <xsl:text>Ouders/verzorgers geven toestemming voor overdracht</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'Nee'">
                <xsl:text>Ouders/verzorgers geven geen toestemming voor overdracht</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'Onbekend'">
                <xsl:text>Het is onbekend of ouders/verzorgers toestemming geven</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <fo:inline color="red">
                    <xsl:value-of select="node()"/>
                </fo:inline>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <!-- Overstapadvies / VO advies codelijst 2 -->
    <xsl:template name="overstapadviescodelijst">

        <xsl:choose>
            <!-- 20240326 codes 32, 33, 40, 41 60, 61 en 62 vervallen voor versie 2024.1: deze codes verwijderd -->
            <!-- 20240326 tekst bij codes 34, 35, 42, 43 en 44 aangepast conform DUO waardelijst -->
            <xsl:when test="node() = '01'">
                <xsl:text>VSO</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '10'">
                <xsl:text>Praktijkonderwijs</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '20'">
                <xsl:text>VMBO BB</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '21'">
                <xsl:text>VMBO BB, met LWOO</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '22'">
                <xsl:text>VMBO BB t/m VMBO KB</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '23'">
                <xsl:text>VMBO BB t/m VMBO KB, met LWOO</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '30'">
                <xsl:text>VMBO KB</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '31'">
                <xsl:text>VMBO KB, met LWOO</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '34'">
                <xsl:text>VMBO KB t/m VMBO GL/TL</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '35'">
                <xsl:text>VMBO KB t/m VMBO GL/TL, met LWOO</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '42'">
                <xsl:text>VMBO GL/TL</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '43'">
                <xsl:text>VMBO GL/TL, met LWOO</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '44'">
                <xsl:text>VMBO GL/TL t/m HAVO</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '60'">
                <xsl:text>HAVO</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '61'">
                <xsl:text>HAVO t/m VWO</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '70'">
                <xsl:text>VWO</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '80'">
                <xsl:text>Geen specifiek advies mogelijk</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <fo:inline color="red">
                    <xsl:value-of select="node()"/>
                </fo:inline>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <!-- Overstapadvies profiellijst 21 -->
    <xsl:template name="overstapadviesprofiellijst">

        <xsl:choose>
            <xsl:when test="node() = 'basis'">
                <xsl:text>Het Basisprofiel is het vereiste niveau voor het betreffende onderwijsniveau.</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'plus'">
                <xsl:text>Het Plusprofiel is het profiel voor leerlingen die m.b.t. het betreffende onderwijsniveau wat over lijken te hebben en misschien in de toekomst kunnen opstromen naar een hoger niveau.</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'bespreek'">
                <xsl:text>Het Bespreekprofiel is het profiel voor leerlingen die niet geheel voldoen aan de eisen voor het betreffende onderwijsniveau. Zo kan er zich een situatie hebben voorgedaan in het (school)leven van de leerling, waardoor het presteren op school tijdelijk negatief is beïnvloed geweest.</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'disharmonisch'">
                <xsl:text>Het Disharmonisch profiel is het profiel voor leerlingen die, op basis van het leerlingvolgsysteem, niet aan de eisen voor het betreffende onderwijsniveau lijken te voldoen, maar waarvoor de verklaring gevonden wordt in bijv. een gediagnosticeerde onderbouwing.</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'ondersteuning'">
                <xsl:text>Het Ondersteuning profiel is het profiel voor leerlingen met een extra ondersteuningsbehoeften, bijvoorbeeld potentiële pro/lwoo-leerlingen, maar ook leerlingen, waarvoor tot voor kort een zogenoemde rugzak beschikbaar was.</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <fo:inline color="red">
                    <xsl:value-of select="node()"/>
                </fo:inline>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <!-- Voorschoolse codelijst 7 + 9 + 6 + 8 -->
    <xsl:template name="voorschoolscodelijst">
        <xsl:param name="codeType"/>
        <xsl:param name="codeValue"/>

        <xsl:choose>
            <xsl:when test="$codeType = 'codevoorschoolsehistorie'">
                <xsl:choose>
                    <xsl:when test="$codeValue = '1'">
                        <xsl:text>Voorschool peuterspeelzaal</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '2'">
                        <xsl:text>Kinderdagverblijf</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '3'">
                        <xsl:text>Andere peuterspeelzaal</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '4'">
                        <xsl:text>Geen voorschoolse voorziening</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '5'">
                        <xsl:text>Anders</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <fo:inline color="red">
                            <xsl:value-of select="$codeValue"/>
                        </fo:inline>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="$codeType = 'codevoorschoolsprogramma' or $codeType = 'codevroegschoolsprogramma'">
                <xsl:choose>
                    <xsl:when test="$codeValue = '1'">
                        <xsl:text>Kaleidoscoop</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '2'">
                        <xsl:text>Piramide</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '3'">
                        <xsl:text>Startblokken</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '4'">
                        <xsl:text>KO totaal</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '5'">
                        <xsl:text>Ander VVE programma</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '6'">
                        <xsl:text>Een combinatie van programma's</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '7'">
                        <xsl:text>Ben ik in Beeld</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '8'">
                        <xsl:text>Doe meer met Bas</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '9'">
                        <xsl:text>Peuterplein en Kleuterplein</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '10'">
                        <xsl:text>Uk en Puk</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '11'">
                        <xsl:text>Instapje</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '12'">
                        <xsl:text>Opstap</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '13'">
                        <xsl:text>Opstapje</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '14'">
                        <xsl:text>VoorleesExpress</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '15'">
                        <xsl:text>VVE Thuis</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <fo:inline color="red">
                            <xsl:value-of select="$codeValue"/>
                        </fo:inline>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="$codeType = 'codevoorschoolsetoeleider'">
                <xsl:choose>
                    <xsl:when test="$codeValue = '1'">
                        <xsl:text>Onderwijs</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '2'">
                        <xsl:text>Ouder-kind centrum</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '3'">
                        <xsl:text>GG&amp;GD</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '4'">
                        <xsl:text>Familie</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '5'">
                        <xsl:text>Felicitatiedienst</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '6'">
                        <xsl:text>Consultatiebureau</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '7'">
                        <xsl:text>(Deel)gemeente/stadsdeel</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '8'">
                        <xsl:text>Inburgeringsloket</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '9'">
                        <xsl:text>Onbekend</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <fo:inline color="red">
                            <xsl:value-of select="$codeValue"/>
                        </fo:inline>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="$codeType = 'codevoorschoolsedeelname'">
                <xsl:choose>
                    <xsl:when test="$codeValue = '1'">
                        <xsl:text>Weinig</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '2'">
                        <xsl:text>Vaak</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '3'">
                        <xsl:text>Meestal</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '4'">
                        <xsl:text>Meer dan 4 dagdelen p/w</xsl:text>
                    </xsl:when>
                    <xsl:when test="$codeValue = '5'">
                        <xsl:text>Onbekend</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <fo:inline color="red">
                            <xsl:value-of select="$codeValue"/>
                        </fo:inline>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$codeValue"/>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <!-- Doorstroomtoets/eindtoets referentieniveau codelijst 45 -->
    <xsl:template name="toetsreferentieniveaucodelijst">

        <xsl:choose>
            <!-- 20240326 codes 01 t/m 04 vervallen voor versie 2024.1: deze codes verwijderd -->
            <!-- 20230704 codes L1F t/m 2F toegevoegd voor versie 2022.1 -->
            <xsl:when test="node() = 'L1F'">
                <xsl:text>Lager dan 1F</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '1F'">
                <xsl:text>1F</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '1S'">
                <xsl:text>1S</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '2F'">
                <xsl:text>2F</xsl:text>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <!-- Opleidingskenmerken codelijst 49 -->
    <xsl:template name="opleidingskenmerkenlijst">
        
        <xsl:choose>
            <xsl:when test="node() = 'IGBO'">
                <xsl:text>Internationaal georiënteerd basisonderwijs</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'PILOT_TPO'">
                <xsl:text>Pilot tweetalig primair onderwijs</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'EUROPESE_SCHOOL'">
                <xsl:text>Experiment Europese school</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'DAMU'">
                <xsl:text>Dans en Muziek</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'ONDERWIJSZORGARRANGEMENTEN'">
                <xsl:text>Onderwijszorgarrangementen</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'ONDERWIJSVOORZIENING_ONTHEEMDEN'">
                <xsl:text>Tijdelijke onderwijsvoorziening voor ontheemden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'TIJDELIJKE_NIEUWKOMERSVOORZIENING'">
                <xsl:text>Tijdelijke nieuwkomersvoorziening</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'AGORA'">
                <xsl:text>Agora</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'DALTON'">
                <xsl:text>Dalton</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'FREINET'">
                <xsl:text>Freinet</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'JENAPLAN'">
                <xsl:text>Jenaplan</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'MONTESSORI'">
                <xsl:text>Montessori</xsl:text>
            </xsl:when>
            
            <xsl:when test="node() = 'DOOF'">
                <xsl:text>Onderwijs aan dove leerlingen</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'DOOF_EN_VISUEEL_GEHANDICAPT'">
                <xsl:text>Onderwijs aan leerlingen met doof/blindheid</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'DOOF_EN_ZEER_MOEILIJK_LEREND'">
                <xsl:text>Onderwijs aan dove leerlingen die tevens zeer moeilijk lerend zijn</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'ERNSTIGE_SPRAAK_MOEILIJKHEDEN'">
                <xsl:text>Onderwijs aan leerlingen met een taalontwikkelingsstoornis</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'SLECHT_HOREND'">
                <xsl:text>Onderwijs aan slechthorende leerlingen</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'SLECHT_HOREND_EN_ZEER_MOEILIJK_LEREND'">
                <xsl:text>Onderwijs aan slechthorende leerlingen die tevens zeer moeilijk lerend zijn</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'VISUEEL_GEHANDICAPT'">
                <xsl:text>Onderwijs aan leerlingen met visuele beperkingen</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'VISUEEL_GEHANDICAPT_EN_ZEER_MOEILIJK_LEREND'">
                <xsl:text>Onderwijs aan leerlingen met visuele beperkingen die tevens zeer moeilijk lerend zijn</xsl:text>
            </xsl:when>
            
            <xsl:when test="node() = 'DLR'">
                <xsl:text>Doorlopende leerroute vmbo-mbo</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'GLR'">
                <xsl:text>Geïntegreerde leerroute vmbo-mbo</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'GLR_VMBO_MBO'">
                <xsl:text>Geïntegreerde leerroute vmbo-mbo</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'DLR_VMBO_MBO'">
                <xsl:text>Doorlopende leerroute vmbo-mbo</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'TECHNASIUM'">
                <xsl:text>Technasium</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'TOPSPORT_TALENT'">
                <xsl:text>Topsport Talent</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'TTO'">
                <xsl:text>Tweetalig onderwijs</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'ISK'">
                <xsl:text>Internationale schakelklas</xsl:text>
            </xsl:when>
            
            <xsl:when test="node() = 'VERRIJKT_PROGRAMMA_VWO'">
                <xsl:text>Verrijkt programma VWO</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'VERSNELD_PROGRAMMA_VWO'">
                <xsl:text>Versneld programma VWO</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'PRO_VMBO_ONDERBOUW'">
                <xsl:text>Pro/vmbo onderbouw</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'PRAKTIJKGERICHT_PROGRAMMA_VOOR_GL_EN_TL'">
                <xsl:text>Praktijkgericht programma GL/TL</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'PRAKTIJKGERICHT_PROGRAMMA_VOOR_HAVO'">
                <xsl:text>Praktijkgericht programma HAVO</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'PRAKTIJKGERICHT_PROGRAMMA'">
                <xsl:text>Praktijkgericht programma</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <!--codelijst niet verplicht, dus geen rode vermelding!-->
                <fo:inline />
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
    
    <!-- Jaargroep codelijst 13 -->
    <xsl:template name="jaargroepcodelijst">

        <xsl:choose>
            <xsl:when test="node() = '1'">
                <xsl:text>PO groep 1</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '2'">
                <xsl:text>PO groep 2</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '3'">
                <xsl:text>PO groep 3</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '4'">
                <xsl:text>PO groep 4</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5'">
                <xsl:text>PO groep 5</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6'">
                <xsl:text>PO groep 6</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7'">
                <xsl:text>PO groep 7</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8'">
                <xsl:text>PO groep 8</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '11'">
                <xsl:text>VO leerjaar 1</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '12'">
                <xsl:text>VO leerjaar 2</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '13'">
                <xsl:text>VO leerjaar 3</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '14'">
                <xsl:text>VO leerjaar 4</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '15'">
                <xsl:text>VO leerjaar 5</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '16'">
                <xsl:text>VO leerjaar 6</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'S'">
                <xsl:text>SBO / SO / VSO</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'P'">
                <xsl:text>peutergroep</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <fo:inline color="red">
                    <xsl:value-of select="node()"/>
                </fo:inline>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <!-- Vergelijkingsgroep codelijst 22 -->
    <xsl:template name="vergelijkingsgroepcodelijst">

        <xsl:choose>
            <xsl:when test="node() = 'BB'">
                <xsl:text>Basisberoepsgerichte leerweg zonder leerwegondersteunend onderwijs</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'KB'">
                <xsl:text>Kaderberoepsgerichte leerweg</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'GT'">
                <xsl:text>Gemengde en theoretische leerweg</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'HAVO'">
                <xsl:text>HAVO</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'VWO'">
                <xsl:text>VWO</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'Landelijk'">
                <xsl:text>vergelijkingsgroep Landelijk</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <fo:inline color="red">
                    <xsl:value-of select="node()"/>
                </fo:inline>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <!-- Referentiescore codelijst 11 -->
    <xsl:template name="referentiescorecodelijst">

        <xsl:choose>
            <xsl:when test="node() = 'AE'">
                <xsl:text>niveau aanduiding A-B-C-D-E van Cito</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'CAE'">
                <xsl:text>Gecorrigeerd niveau aanduiding A-B-C-D-E van Cito als de toets is afgenomen op een afwijkende datum</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'IV'">
                <xsl:text>niveau aanduiding I-II-III-IV-V van Cito</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'CIV'">
                <xsl:text>Gecorrigeerd niveau aanduiding I-II-III-IV-V van Cito als de toets is afgenomen op een afwijkende datum</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'FN'">
                <xsl:text>functioneringsniveau van Cito</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'ON'">
                <xsl:text>onderwijsniveau (bijvoorbeeld HAVO)</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'DLE'">
                <xsl:text>Didactische Leeftijd Equivalent</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'Percentiel'">
                <xsl:text>score volgens de indeling in gelijke percentielen</xsl:text>
            </xsl:when>
            <!-- 20260114 code CPercentiel toegevoegd voor versie 2026.1 -->
            <xsl:when test="node() = 'CPercentiel'">
                <xsl:text>Gecorrigeerde percentielscore</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'Percentage'">
                <xsl:text>percentage van het aantal goed op totaal aantal opgaven</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'T-score'">
                <xsl:text>score volgens de scoreverdeling T (gemiddelde =50 STD = 10</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'Stanine'">
                <xsl:text>score volgens de Standard Nine verdeling</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'DQ'">
                <xsl:text>Didactisch Quotient</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'IQ'">
                <xsl:text>Intelligentie quotient</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'ERK'">
                <xsl:text>ERK is het Europees ReferentieKader voor MVT (moderne vreemde talen). Het ERK onderscheidt 6 taalcompententieniveaus: van beginner tot near-native (A1 t/m C2). Mogelijke waarden: &lt;A1, A1, A2, B1, B2, C1, C2.</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'C-score'">
                <xsl:text>score verdeling conform de C schaal</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'Norm'">
                <xsl:text>elke andere normaanduiding</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'RNTRM'">
                <xsl:text>Referentieniveau's Taal Rekenen volgens Meijerink.</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'ZML'">
                <xsl:text>niveau Zeer Moelijk Lerend : ZML-1, ZML-2</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'LGH'">
                <xsl:text>niveau L Laag, G Gemiddeld , H Hoog</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'AVI'">
                <xsl:text>niveau AVI Start, M3, E3 etc</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'NAZ'">
                <xsl:text>Signaal N=Niet afwijkend, A=Afwijkend, Z=Zeer afwijkend van Cito</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'LM'">
                <xsl:text>Leeftijd in aantal  maanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'Standaardscore'">
                <xsl:text>Score volgens standaard indeling (o.a. eindtoets basisonderwijs)</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'LA'">
                <xsl:text>Leerachterstand, is het gegeven dat met behulp van de waarde van DL en van DLE volgens de formule (1- (DLE/DL)) kan worden uitgerekend.</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <fo:inline color="red">
                    <xsl:value-of select="node()"/>
                </fo:inline>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <!-- TLV bekostigingscategorie codelijst 31 -->
    <xsl:template name="tlvcategoriecodelijst">

        <xsl:choose>
            <xsl:when test="node() = 'H'">
                <xsl:text>Hoog</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'M'">
                <xsl:text>Midden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'L'">
                <xsl:text>Laag</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'Nvt'">
                <xsl:text>Niet van toepassing, bijvoorbeeld bij SBO ingeschreven leerling</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <fo:inline color="red">
                    <xsl:value-of select="node()"/>
                </fo:inline>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <!-- RVC indicatie codelijst 17 -->
    <xsl:template name="rvcindicatiecodelijst">

        <xsl:choose>
            <xsl:when test="node() = 'LWOO'">
                <xsl:text>Leerweg Ondersteunend Onderwijs</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'PRO'">
                <xsl:text>Praktijk Onderwijs</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <fo:inline color="red">
                    <xsl:value-of select="node()"/>
                </fo:inline>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <!-- Diagnose codelijst 23 -->
    <xsl:template name="diagnosecodelijst">

        <xsl:choose>
            <xsl:when test="node() = 'F81.0'">
                <xsl:text>Leerstoornissen: Dyslexie</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'F81.1'">
                <xsl:text>Leerstoornissen: Dysorthografie</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'F81.2'">
                <xsl:text>Leerstoornissen: Dyscalculie</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'F82'">
                <xsl:text>Motorisch: Dyspraxie</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'F84'">
                <xsl:text>Pervasieve ontwikkelingsstoornissen: PDD-NOS/ASS (pervasieve ontwikkelingsstoornis)</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'F84.0'">
                <xsl:text>Pervasieve ontwikkelingsstoornissen: Autisme</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'F84.2'">
                <xsl:text>Pervasieve ontwikkelingsstoornissen: Syndroom van Rett</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'F84.5'">
                <xsl:text>Pervasieve ontwikkelingsstoornissen: Asperger</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'F84.nld'">
                <xsl:text>Pervasieve ontwikkelingsstoornissen: NLD (nonverbale leerstoornis)</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'F84.mcdd'">
                <xsl:text>Pervasieve ontwikkelingsstoornissen: MCDD (meervoudig complexe ontwikkelingsstoornis)</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'F90'">
                <xsl:text>Aandachtstekort- en gedragsstoornissen: Aandachtstekortstoornis</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'F90.0'">
                <xsl:text>Aandachtstekort- en gedragsstoornissen: ADHD/ADD (aandachtstekortstoornis met of zonder hyperactiviteit)</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'F90.0+'">
                <xsl:text>Aandachtstekort- en gedragsstoornissen: ADHD/ADD met medicijnen</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'F90.0-'">
                <xsl:text>Aandachtstekort- en gedragsstoornissen: ADHD/ADD zonder medicijnen</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'F91'">
                <xsl:text>Aandachtstekort- en gedragsstoornissen: CD (gedragsstoornis)</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'F91.3'">
                <xsl:text>Aandachtstekort- en gedragsstoornissen: ODD (oppositioneel opstandige gedragsstoornis)</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'F95'">
                <xsl:text>Tics: Tic stoornis</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'F95.2'">
                <xsl:text>Tics: Gilles de la Tourette</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'F41.0'">
                <xsl:text>Overig: Paniekstoornis</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'F43.1'">
                <xsl:text>Overig: Posttraumatische stress</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'F50'">
                <xsl:text>Overig: Eetstoornis</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'F92.0'">
                <xsl:text>Overig: Depressieve gedragsstoornis</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'F93.1'">
                <xsl:text>Overig: Angststoornis</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'F94'">
                <xsl:text>Overig: Hechtingsstoornis</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'Fspd'">
                <xsl:text>Overig: Integratiestoornis (sensory processing disorder)</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'G40'">
                <xsl:text>Overig: Epilepsie</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'H54.0'">
                <xsl:text>Visuele stoornissen en blindheid: Blind (blindheid van beide ogen)</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'H54.2'">
                <xsl:text>Visuele stoornissen en blindheid: Slechtziend (slechtziendheid van beide ogen)</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'H91.9.d'">
                <xsl:text>Gehoorverlies: Doof (doofheid - niet nader omschreven)</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'H91.9.s'">
                <xsl:text>Gehoorverlies: Slechthorend (slechthorendheid - niet nader omschreven)</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'Z62'">
                <xsl:text>Overig: Ouder/kind-problemen</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'F79.VB'">
                <xsl:text>Verstandelijke beperking</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'F79.ZB'">
                <xsl:text>Zwakbegaafdheid</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'HB'">
                <xsl:text>Hoogbegaafdheid</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'F80'">
                <xsl:text>TOS (Taal Ontwikkeling Stoornis)</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'F81.9'">
                <xsl:text>Leerstoornis (Niet anders gespecificeerd)</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'F43.2'">
                <xsl:text>Aanpassingsstoornissen</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <fo:inline color="red">
                    <xsl:value-of select="node()"/>
                </fo:inline>
            </xsl:otherwise>
        </xsl:choose>
         
    </xsl:template>

    <!-- NNCA codelijst 10 -->
    <xsl:template name="nncacodelijst">

        <xsl:choose>
            <xsl:when test="node() = '0'">
                <xsl:text>Niet van toepassing</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '1'">
                <xsl:text>Leerling met een Nederlandse culturele achtergrond</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '2'">
                <xsl:text>Leerling met een niet-Nederlandse culturele achtergrond</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <fo:inline color="red">
                    <xsl:value-of select="node()"/>
                </fo:inline>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <!-- Relatie tot kind codelijst 41 -->
    <xsl:template name="relatietotkindcodelijst">

        <xsl:choose>
            <xsl:when test="node() = '1'">
                <xsl:text>Vader</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '2'">
                <xsl:text>Moeder</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '3'">
                <xsl:text>Voogd</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '4'">
                <xsl:text>Toeziend voogd</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5'">
                <xsl:text>Anders</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6'">
                <xsl:text>Adoptief moeder</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7'">
                <xsl:text>Biologische moeder</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8'">
                <xsl:text>Adoptief vader</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9'">
                <xsl:text>Biologische vader</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <fo:inline color="red">
                    <xsl:value-of select="node()"/>
                </fo:inline>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <!-- Geslacht codelijst 14 -->
    <xsl:template name="geslachtcodelijst">

        <xsl:choose>
            <xsl:when test="node() = '0'">
                <xsl:text>onbekend</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '1'">
                <xsl:text>vrouw</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '2'">
                <xsl:text>man</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <fo:inline color="red">
                    <xsl:value-of select="node()"/>
                </fo:inline>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <!-- Adres aanduiding codelijst 18 -->
    <xsl:template name="adresaanduidingcodelijst">

        <xsl:choose>
            <xsl:when test="node() = 'TO'">
                <xsl:text>Tegenover</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'BY'">
                <xsl:text>Bij</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <fo:inline color="red">
                    <xsl:value-of select="node()"/>
                </fo:inline>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <!-- Soort Doorstroomtoets/eindtoets codelijst 42 -->
    <xsl:template name="toetssoortcodelijst">

        <xsl:choose>
            <!-- 20240326 code 0011 t/m 0016 en CALAMITEITENTOETS vervallen en verboden voor versie 2024.1: deze codes verwijderd -->
            <!-- 20230704 codes ROUTE_8 t/m OCW_DOORSTROMTOETS toegevoegd voor versie 2022.1 -->
            <xsl:when test="node() = 'ROUTE_8'">
                <xsl:text>Route 8</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'ICE'">
                <xsl:text>IEP Doorstroomtoets</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'DIA'">
                <xsl:text>Dia-doorstroomtoets</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'AMN'">
                <xsl:text>AMN Doorstroomtoets</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'LEERLING_IN_BEELD'">
                <xsl:text>Leerling in beeld-doorstroomtoets</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'DOE'">
                <xsl:text>Doe overheidsdoorstroomtoets</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'OCW_DOORSTROOMTOETS'">
                <xsl:text>OCW Doorstroomtoets</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <fo:inline color="red">
                    <xsl:value-of select="node()"/>
                </fo:inline>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <!-- Wettelijke ontheffing eindtoets codelijst 44 -->
    <xsl:template name="wettelijke_ontheffingcodelijst">

        <xsl:choose>
            <xsl:when test="node() = 'J'">
                <xsl:text>Ja, er is een wettelijke ontheffing (ingevuld)</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'N'">
                <xsl:text>Nee, er is geen wettelijke ontheffing (of niet ingevuld)</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <fo:inline color="red">
                    <xsl:value-of select="node()"/>
                </fo:inline>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <!-- Doorstroomtoets/eindtoets onderdeelcode codelijst 46 -->
    <xsl:template name="onderdeelcodeniveaucodelijst">

        <xsl:choose>
            <!-- 20240326 codes 8000 en 8001 vervallen en verboden voor versie 2024.1: deze codes verwijderd -->
            <!-- 20230704 codes NEDERLANDSE_TAAL en REKENEN toegevoegd voor versie 2022.1 -->
            <xsl:when test="node() = 'NEDERLANDSE_TAAL'">
                <xsl:text>Nederlandse taal</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'REKENEN'">
                <xsl:text>Rekenen</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <fo:inline color="red">
                    <xsl:value-of select="node()"/>
                </fo:inline>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <!-- Doorstroomtoets/eindtoets domeincode codelijst 47 -->
    <xsl:template name="domeincodecodelijst">

        <xsl:choose>
            <!-- 20240326 codes 8050 en 8051 vervallen en verboden voor versie 2024.1: deze codes verwijderd  -->
            <!-- 20230704 codes LEZEN en TAALVERZORGING toegevoegd voor versie 2022.1 -->
            <xsl:when test="node() = 'LEZEN'">
                <xsl:text>Nederlandse taal - Lezen</xsl:text>
            </xsl:when>
            <xsl:when test="node() = 'TAALVERZORGING'">
                <xsl:text>Nederlandse taal - Taalverzorging</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <fo:inline color="red">
                    <xsl:value-of select="node()"/>
                </fo:inline>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <!-- Land codelijst 26 -->
    <xsl:template name="landcodelijst">
        <xsl:param name="omschrijvingTekst"/>
        
        <xsl:choose>
            <xsl:when test="node() = '0'">
                <xsl:text>Onbekend</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5001'">
                <xsl:text>Canada</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5002'">
                <xsl:text>Frankrijk</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5003'">
                <xsl:text>Zwitserland</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5004'">
                <xsl:text>Rhodesië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5005'">
                <xsl:text>Malawi</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5006'">
                <xsl:text>Cuba</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5007'">
                <xsl:text>Suriname</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5008'">
                <xsl:text>Tunesië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5009'">
                <xsl:text>Oostenrijk</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5010'">
                <xsl:text>België</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5011'">
                <xsl:text>Botswana</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5012'">
                <xsl:text>Iran</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5013'">
                <xsl:text>Nieuwzeeland</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5014'">
                <xsl:text>Zuidafrika</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5015'">
                <xsl:text>Denemarken</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5016'">
                <xsl:text>Noordjemen</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5017'">
                <xsl:text>Hongarije</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5018'">
                <xsl:text>Saoediarabië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5019'">
                <xsl:text>Liberia</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5020'">
                <xsl:text>Etiopië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5021'">
                <xsl:text>Chili</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5022'">
                <xsl:text>Marokko</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5023'">
                <xsl:text>Togo</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5024'">
                <xsl:text>Ghana</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5025'">
                <xsl:text>Laos</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5026'">
                <xsl:text>Angola</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5027'">
                <xsl:text>Filipijnen</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5028'">
                <xsl:text>Zambia</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5029'">
                <xsl:text>Mali</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5030'">
                <xsl:text>Ivoorkust</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5031'">
                <xsl:text>Burma</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5032'">
                <xsl:text>Monaco</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5033'">
                <xsl:text>Colombia</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5034'">
                <xsl:text>Albanië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5035'">
                <xsl:text>Kameroen</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5036'">
                <xsl:text>Zuidviëtnam</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5037'">
                <xsl:text>Singapore</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5038'">
                <xsl:text>Paraguay</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5039'">
                <xsl:text>Zweden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5040'">
                <xsl:text>Cyprus</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5041'">
                <xsl:text>Australisch Nieuwguinea</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5042'">
                <xsl:text>Brunei</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5043'">
                <xsl:text>Irak</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5044'">
                <xsl:text>Mauritius</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5045'">
                <xsl:text>Vaticaanstad</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5046'">
                <xsl:text>Kashmir</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5047'">
                <xsl:text>Myanmar</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5048'">
                <xsl:text>Jemen</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5049'">
                <xsl:text>Slovenië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5050'">
                <xsl:text>Zaïre</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5051'">
                <xsl:text>Kroatië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5052'">
                <xsl:text>Taiwan</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5053'">
                <xsl:text>Rusland</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5054'">
                <xsl:text>Armenië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5055'">
                <xsl:text>Ascension</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5056'">
                <xsl:text>Azoren</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5057'">
                <xsl:text>Bahrein</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5058'">
                <xsl:text>Bhutan</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5059'">
                <xsl:text>Britse Antillen</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5060'">
                <xsl:text>Comoren</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5061'">
                <xsl:text>Falklandeilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5062'">
                <xsl:text>Frans Guyana</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5063'">
                <xsl:text>Frans Somaliland</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5064'">
                <xsl:text>Gilbert- en Ellice-eilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5065'">
                <xsl:text>Groenland</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5066'">
                <xsl:text>Guadeloupe</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5067'">
                <xsl:text>Kaapverdische Eilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5068'">
                <xsl:text>Macau</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5069'">
                <xsl:text>Martinique</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5070'">
                <xsl:text>Mozambique</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5071'">
                <xsl:text>Pitcairneilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5072'">
                <xsl:text>Guinee Bissau</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5073'">
                <xsl:text>Réunion</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5074'">
                <xsl:text>Saint Pierre en Miquelon</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5075'">
                <xsl:text>Seychellen en Amiranten</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5076'">
                <xsl:text>Tonga</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5077'">
                <xsl:text>Wallis en Futuna</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5078'">
                <xsl:text>Zuidwest Afrika</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5079'">
                <xsl:text>Frans Indië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5080'">
                <xsl:text>Johnston</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5081'">
                <xsl:text>Kedah</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5082'">
                <xsl:text>Kelantan</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5083'">
                <xsl:text>Malakka</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5084'">
                <xsl:text>Mayotte</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5085'">
                <xsl:text>Negri Sembilan</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5086'">
                <xsl:text>Pahang</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5087'">
                <xsl:text>Perak</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5088'">
                <xsl:text>Perlis</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5089'">
                <xsl:text>Portugees Indië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5090'">
                <xsl:text>Selangor</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5091'">
                <xsl:text>Sikkim</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5092'">
                <xsl:text>Sint Vincent en de Grenadinen</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5093'">
                <xsl:text>Spitsbergen</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5094'">
                <xsl:text>Trengganu</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5095'">
                <xsl:text>Aruba</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5096'">
                <xsl:text>Burkina Faso</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5097'">
                <xsl:text>Azerbajdsjan</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5098'">
                <xsl:text>Belarus (Wit-Rusland)</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5099'">
                <xsl:text>Kazachstan</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5100'">
                <xsl:text>Macedonië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5101'">
                <xsl:text>Timor Leste</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5102'">
                <xsl:text>Servië en Montenegro</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5103'">
                <xsl:text>Servië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5104'">
                <xsl:text>Montenegro</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5105'">
                <xsl:text>Kosovo</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5106'">
                <xsl:text>Bonaire</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5107'">
                <xsl:text>Curaçao</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5108'">
                <xsl:text>Saba</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5109'">
                <xsl:text>Sint Eustatius</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5110'">
                <xsl:text>Sint Maarten</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '5111'">
                <xsl:text>Zuid-Soedan</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6000'">
                <xsl:text>Moldavië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6001'">
                <xsl:text>Burundi</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6002'">
                <xsl:text>Finland</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6003'">
                <xsl:text>Griekenland</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6004'">
                <xsl:text>Guatemala</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6005'">
                <xsl:text>Nigeria</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6006'">
                <xsl:text>Libië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6007'">
                <xsl:text>Ierland</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6008'">
                <xsl:text>Brazilië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6009'">
                <xsl:text>Rwanda</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6010'">
                <xsl:text>Venezuela</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6011'">
                <xsl:text>IJsland</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6012'">
                <xsl:text>Liechtenstein</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6013'">
                <xsl:text>Somalia</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6014'">
                <xsl:text>Verenigde Staten van Amerika</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6015'">
                <xsl:text>Bolivia</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6016'">
                <xsl:text>Australië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6017'">
                <xsl:text>Jamaica</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6018'">
                <xsl:text>Luxemburg</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6019'">
                <xsl:text>Tsjaad</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6020'">
                <xsl:text>Mauritanië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6021'">
                <xsl:text>Kyrgyzstan</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6022'">
                <xsl:text>China</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6023'">
                <xsl:text>Afganistan</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6024'">
                <xsl:text>Indonesië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6025'">
                <xsl:text>Guyana</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6026'">
                <xsl:text>Noordviëtnam</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6027'">
                <xsl:text>Noorwegen</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6028'">
                <xsl:text>San Marino</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6029'">
                <xsl:text>Duitsland</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6030'">
                <xsl:text>Nederland</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6031'">
                <xsl:text>Kambodja</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6032'">
                <xsl:text>Fiji</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6033'">
                <xsl:text>Bahama-eilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6034'">
                <xsl:text>Israël</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6035'">
                <xsl:text>Nepal</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6036'">
                <xsl:text>Zuidkorea</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6037'">
                <xsl:text>Spanje</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6038'">
                <xsl:text>Oekraine</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6039'">
                <xsl:text>Grootbrittannië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6040'">
                <xsl:text>Niger</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6041'">
                <xsl:text>Haïti</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6042'">
                <xsl:text>Jordanië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6043'">
                <xsl:text>Turkije</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6044'">
                <xsl:text>Trinidad en Tobago</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6045'">
                <xsl:text>Joegoslavië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6046'">
                <xsl:text>Bovenvolta</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6047'">
                <xsl:text>Algerije</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6048'">
                <xsl:text>Gabon</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6049'">
                <xsl:text>Noordkorea</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6050'">
                <xsl:text>Oezbekistan</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6051'">
                <xsl:text>Sierra Leone</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6052'">
                <xsl:text>Brits Honduras</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6053'">
                <xsl:text>Canarische eilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6054'">
                <xsl:text>Frans Polynesië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6055'">
                <xsl:text>Gibraltar</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6056'">
                <xsl:text>Portugees Timor</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6057'">
                <xsl:text>Tadzjikistan</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6058'">
                <xsl:text>Britse Salomons-eilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6059'">
                <xsl:text>São Tomé en Principe</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6060'">
                <xsl:text>Sint Helena</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6061'">
                <xsl:text>Tristan Da Cunha</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6062'">
                <xsl:text>Westsamoa</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6063'">
                <xsl:text>Toerkmenistan</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6064'">
                <xsl:text>Georgië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6065'">
                <xsl:text>Bosnië-Herzegovina</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6066'">
                <xsl:text>Tsjechië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6067'">
                <xsl:text>Slowakije</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6068'">
                <xsl:text>Federale Republiek Joegoslavië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '6069'">
                <xsl:text>Democratische Republiek Congo</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7001'">
                <xsl:text>Uganda</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7002'">
                <xsl:text>Kenya</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7003'">
                <xsl:text>Malta</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7004'">
                <xsl:text>Barbados</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7005'">
                <xsl:text>Andorra</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7006'">
                <xsl:text>Mexico</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7007'">
                <xsl:text>Costa Rica</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7008'">
                <xsl:text>Gambia</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7009'">
                <xsl:text>Syrië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7011'">
                <xsl:text>Nederlandse Antillen</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7012'">
                <xsl:text>Zuidjemen</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7014'">
                <xsl:text>Egypte</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7015'">
                <xsl:text>Argentinië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7016'">
                <xsl:text>Lesotho</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7017'">
                <xsl:text>Honduras</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7018'">
                <xsl:text>Nicaragua</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7020'">
                <xsl:text>Pakistan</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7021'">
                <xsl:text>Senegal</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7023'">
                <xsl:text>Dahomey</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7024'">
                <xsl:text>Bulgarije</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7026'">
                <xsl:text>Maleisië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7027'">
                <xsl:text>Dominicaanse Republiek</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7028'">
                <xsl:text>Polen</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7029'">
                <xsl:text>Rusland (oud)</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7030'">
                <xsl:text>Britse Maagdeneilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7031'">
                <xsl:text>Tanzania</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7032'">
                <xsl:text>El Salvador</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7033'">
                <xsl:text>Sri Lanka</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7034'">
                <xsl:text>Soedan</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7035'">
                <xsl:text>Japan</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7036'">
                <xsl:text>Hongkong</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7037'">
                <xsl:text>Panama</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7038'">
                <xsl:text>Uruguay</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7039'">
                <xsl:text>Ecuador</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7040'">
                <xsl:text>Guinee</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7041'">
                <xsl:text>Maldiven</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7042'">
                <xsl:text>Thailand</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7043'">
                <xsl:text>Libanon</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7044'">
                <xsl:text>Italië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7045'">
                <xsl:text>Koeweit</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7046'">
                <xsl:text>India</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7047'">
                <xsl:text>Roemenië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7048'">
                <xsl:text>Tsjechoslowakije</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7049'">
                <xsl:text>Peru</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7050'">
                <xsl:text>Portugal</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7051'">
                <xsl:text>Oman</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7052'">
                <xsl:text>Mongolië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7054'">
                <xsl:text>Verenigde Arabische Emiraten</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7055'">
                <xsl:text>Tibet</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7057'">
                <xsl:text>Nauru</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7058'">
                <xsl:text>Nederlands Nieuwguinea</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7059'">
                <xsl:text>Tanganyika</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7060'">
                <xsl:text>Palestina</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7062'">
                <xsl:text>Brits Westindië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7063'">
                <xsl:text>Portugees Afrika</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7064'">
                <xsl:text>Letland</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7065'">
                <xsl:text>Estland</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7066'">
                <xsl:text>Litouwen</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7067'">
                <xsl:text>Brits Afrika</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7068'">
                <xsl:text>Belgisch Congo</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7070'">
                <xsl:text>Brits Indië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7071'">
                <xsl:text>Noordrhodesië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7072'">
                <xsl:text>Zuidrhodesië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7073'">
                <xsl:text>Saarland</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7074'">
                <xsl:text>Frans Indo China</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7075'">
                <xsl:text>Brits Westborneo</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7076'">
                <xsl:text>Goudkust</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7077'">
                <xsl:text>Ras-El-Cheima</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7079'">
                <xsl:text>Frans Congo</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7080'">
                <xsl:text>Siam</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7082'">
                <xsl:text>Brits Oostafrika</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7083'">
                <xsl:text>Brits Noordborneo</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7084'">
                <xsl:text>Bangladesh</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7085'">
                <xsl:text>Duitse Democratische Republiek</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7087'">
                <xsl:text>Madeira-eilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7088'">
                <xsl:text>Amerikaanse Maagdeneilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7089'">
                <xsl:text>Australische Salomonseilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7091'">
                <xsl:text>Spaanse Sahara</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7092'">
                <xsl:text>Caymaneilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7093'">
                <xsl:text>Caicoseilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7094'">
                <xsl:text>Turkseilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7095'">
                <xsl:text>Brits Territorium in Antarctica</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7096'">
                <xsl:text>Brits Territorium in de Indische Oceaan</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7097'">
                <xsl:text>Cookeilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7098'">
                <xsl:text>Tokelau-eilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '7099'">
                <xsl:text>Nieuwcaledonië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8000'">
                <xsl:text>Hawaii-eilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8001'">
                <xsl:text>Guam</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8002'">
                <xsl:text>Amerikaans Samoa</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8003'">
                <xsl:text>Midway</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8004'">
                <xsl:text>Ryukyueilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8005'">
                <xsl:text>Wake</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8006'">
                <xsl:text>Pacific eilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8008'">
                <xsl:text>Grenada</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8009'">
                <xsl:text>Marianen</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8010'">
                <xsl:text>Cabinda</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8011'">
                <xsl:text>Canton en Enderbury</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8012'">
                <xsl:text>Christmaseiland</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8013'">
                <xsl:text>Cocoseilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8014'">
                <xsl:text>Faeröer</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8015'">
                <xsl:text>Montserrat</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8016'">
                <xsl:text>Norfolk</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8017'">
                <xsl:text>Belize</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8018'">
                <xsl:text>Tasmanië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8019'">
                <xsl:text>Turks- en Caicoseilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8020'">
                <xsl:text>Puerto Rico</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8021'">
                <xsl:text>Papua-Nieuwguinea</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8022'">
                <xsl:text>Solomoneilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8023'">
                <xsl:text>Benin</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8024'">
                <xsl:text>Viëtnam</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8025'">
                <xsl:text>Kaapverdië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8026'">
                <xsl:text>Seychellen</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8027'">
                <xsl:text>Kiribati</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8028'">
                <xsl:text>Tuvalu</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8029'">
                <xsl:text>Sint Lucia</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8030'">
                <xsl:text>Dominica</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8031'">
                <xsl:text>Zimbabwe</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8032'">
                <xsl:text>Doebai</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8033'">
                <xsl:text>Nieuwehebriden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8034'">
                <xsl:text>Kanaaleilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8035'">
                <xsl:text>Man</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8036'">
                <xsl:text>Anguilla</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8037'">
                <xsl:text>Saint Kitts-Nevis</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8038'">
                <xsl:text>Antigua</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8039'">
                <xsl:text>Sint Vincent</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8040'">
                <xsl:text>Gilberteilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8041'">
                <xsl:text>Panamakanaalzone</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8042'">
                <xsl:text>Saint Kitts-Nevis-Anguilla</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8043'">
                <xsl:text>Belau</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8044'">
                <xsl:text>Republiek van Palau</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '8045'">
                <xsl:text>Antigua en Barbuda</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9000'">
                <xsl:text>Newfoundland</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9001'">
                <xsl:text>Nyasaland</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9003'">
                <xsl:text>Eritrea</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9005'">
                <xsl:text>Ifni</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9006'">
                <xsl:text>Brits Kameroen</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9007'">
                <xsl:text>Kaiser Wilhelmsland</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9008'">
                <xsl:text>Kongo</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9009'">
                <xsl:text>Kongo Kinshasa</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9010'">
                <xsl:text>Madagaskar</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9013'">
                <xsl:text>Kongo Brazzaville</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9014'">
                <xsl:text>Leewardeilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9015'">
                <xsl:text>Windwardeilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9016'">
                <xsl:text>Frans gebied van Afars en Issa's</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9017'">
                <xsl:text>Phoenixeilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9020'">
                <xsl:text>Portugees Guinee</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9022'">
                <xsl:text>Duits Zuidwestafrika</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9023'">
                <xsl:text>Namibië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9027'">
                <xsl:text>Brits Somaliland</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9028'">
                <xsl:text>Italiaans Somaliland</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9030'">
                <xsl:text>Nederlands Indië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9031'">
                <xsl:text>Brits Guyana</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9036'">
                <xsl:text>Swaziland</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9037'">
                <xsl:text>Katar</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9041'">
                <xsl:text>Aden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9042'">
                <xsl:text>Zuidarabische Federatie</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9043'">
                <xsl:text>Equatoriaalguinee</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9044'">
                <xsl:text>Spaans Guinee</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9047'">
                <xsl:text>Verenigde Arabische Republiek</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9048'">
                <xsl:text>Bermuda</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9049'">
                <xsl:text>Sovjetunie</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9050'">
                <xsl:text>Duits Oostafrika</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9051'">
                <xsl:text>Zanzibar</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9052'">
                <xsl:text>Ceylon</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9053'">
                <xsl:text>Muscat en Oman</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9054'">
                <xsl:text>Trucial Oman</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9055'">
                <xsl:text>Indo China</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9056'">
                <xsl:text>Marshalleilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9057'">
                <xsl:text>Sarawak</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9058'">
                <xsl:text>Brits Borneo</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9060'">
                <xsl:text>Sabah</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9061'">
                <xsl:text>Aboe Dhabi</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9062'">
                <xsl:text>Adjman</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9063'">
                <xsl:text>Basoetoland</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9064'">
                <xsl:text>Bechuanaland</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9065'">
                <xsl:text>Foedjaira</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9066'">
                <xsl:text>Frans Kameroen</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9067'">
                <xsl:text>Johore</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9068'">
                <xsl:text>Korea</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9069'">
                <xsl:text>Labuan</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9070'">
                <xsl:text>Oem el Koewein</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9071'">
                <xsl:text>Oostenrijk-Hongarije</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9072'">
                <xsl:text>Portugees Oost Afrika</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9073'">
                <xsl:text>Portugees West Afrika</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9074'">
                <xsl:text>Sjardja</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9075'">
                <xsl:text>Straits Settlements</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9076'">
                <xsl:text>Abessinië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9077'">
                <xsl:text>Frans West Afrika</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9078'">
                <xsl:text>Frans Equatoriaal Afrika</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9081'">
                <xsl:text>Oeroendi</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9082'">
                <xsl:text>Roeanda-Oeroendi</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9084'">
                <xsl:text>Goa</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9085'">
                <xsl:text>Dantzig</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9086'">
                <xsl:text>Centrafrika</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9087'">
                <xsl:text>Djibouti</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9088'">
                <xsl:text>Transjordanië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9089'">
                <xsl:text>Bondsrepubliek Duitsland</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9090'">
                <xsl:text>Vanuatu</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9091'">
                <xsl:text>Niue</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9092'">
                <xsl:text>Spaans Noordafrika</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9093'">
                <xsl:text>Westelijke Sahara</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9094'">
                <xsl:text>Micronesia</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9095'">
                <xsl:text>Svalbardeilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '9999'">
                <xsl:text>Internationaal gebied</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <fo:inline color="red">
                    <xsl:value-of select="node()"/>
                </fo:inline>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
            <xsl:when test="node() = '6030'"/>
            <xsl:otherwise>
                <!--<xsl:text> (landcode </xsl:text><xsl:value-of select="node()"/><xsl:text>)</xsl:text>-->
                <xsl:if test="$omschrijvingTekst != ''">
                    <xsl:text> (met omschrijving: </xsl:text><xsl:value-of select="$omschrijvingTekst"/><xsl:text>)</xsl:text>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>

    <!-- Nationaliteit codelijst 30 -->
    <xsl:template name="nationaliteitcodelijst">

        <xsl:choose>
            <xsl:when test="node() = '0000'">
                <xsl:text>Onbekend</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0001'">
                <xsl:text>Nederlandse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0002'">
                <xsl:text>Behandeld als Nederlander</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0027'">
                <xsl:text>Slowaakse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0028'">
                <xsl:text>Tsjechische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0029'">
                <xsl:text>Burger van Bosnië-Herzegovina</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0030'">
                <xsl:text>Burger van Georgië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0031'">
                <xsl:text>Burger van Toerkmenistan</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0032'">
                <xsl:text>Burger van Tadzjikistan</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0033'">
                <xsl:text>Burger van Oezbekistan</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0034'">
                <xsl:text>Burger van Oekraine</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0035'">
                <xsl:text>Burger van Kyrgyzstan</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0036'">
                <xsl:text>Burger van Moldavië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0037'">
                <xsl:text>Burger van Kazachstan</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0038'">
                <xsl:text>Burger van Belarus (Wit-Rusland)</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0039'">
                <xsl:text>Burger van Azerbajdsjan</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0040'">
                <xsl:text>Burger van Armenië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0041'">
                <xsl:text>Burger van Rusland</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0042'">
                <xsl:text>Burger van Slovenië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0043'">
                <xsl:text>Burger van Kroatië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0044'">
                <xsl:text>Letse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0045'">
                <xsl:text>Estnische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0046'">
                <xsl:text>Litouwse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0047'">
                <xsl:text>Burger van de Marshalleilanden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0048'">
                <xsl:text>Myanmarese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0049'">
                <xsl:text>Namibische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0050'">
                <xsl:text>Albanese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0051'">
                <xsl:text>Andorrese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0052'">
                <xsl:text>Belgische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0053'">
                <xsl:text>Bulgaarse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0054'">
                <xsl:text>Deense</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0055'">
                <xsl:text>Burger van de Bondsrepubliek Duitsland</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0056'">
                <xsl:text>Finse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0057'">
                <xsl:text>Franse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0058'">
                <xsl:text>Jemenitische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0059'">
                <xsl:text>Griekse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0060'">
                <xsl:text>Brits burger</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0061'">
                <xsl:text>Hongaarse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0062'">
                <xsl:text>Ierse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0063'">
                <xsl:text>IJslandse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0064'">
                <xsl:text>Italiaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0065'">
                <xsl:text>Joegoslavische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0066'">
                <xsl:text>Liechtensteinse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0067'">
                <xsl:text>Luxemburgse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0068'">
                <xsl:text>Maltese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0069'">
                <xsl:text>Monegaskische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0070'">
                <xsl:text>Noorse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0071'">
                <xsl:text>Oostenrijkse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0072'">
                <xsl:text>Poolse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0073'">
                <xsl:text>Portugese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0074'">
                <xsl:text>Roemeense</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0075'">
                <xsl:text>Burger Sovjetunie</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0076'">
                <xsl:text>Sanmarinese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0077'">
                <xsl:text>Spaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0078'">
                <xsl:text>Tsjechoslowaakse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0079'">
                <xsl:text>Vaticaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0080'">
                <xsl:text>Zweedse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0081'">
                <xsl:text>Zwitserse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0082'">
                <xsl:text>Oostduitse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0083'">
                <xsl:text>Brits onderdaan</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0084'">
                <xsl:text>Eritrese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0085'">
                <xsl:text>Brits overzees burger</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0086'">
                <xsl:text>Macedonische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0087'">
                <xsl:text>Burger van Kosovo</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0100'">
                <xsl:text>Algerijnse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0101'">
                <xsl:text>Angolese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0104'">
                <xsl:text>Burundische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0105'">
                <xsl:text>Botswaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0106'">
                <xsl:text>Burger van Burkina Faso</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0108'">
                <xsl:text>Centrafrikaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0109'">
                <xsl:text>Comorese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0110'">
                <xsl:text>Kongolese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0111'">
                <xsl:text>Beninse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0112'">
                <xsl:text>Egyptische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0113'">
                <xsl:text>Equatoriaalguinese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0114'">
                <xsl:text>Etiopische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0115'">
                <xsl:text>Djiboutiaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0116'">
                <xsl:text>Gabonese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0117'">
                <xsl:text>Gambiaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0118'">
                <xsl:text>Ghanese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0119'">
                <xsl:text>Guinese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0120'">
                <xsl:text>Ivoriaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0121'">
                <xsl:text>Kaapverdische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0122'">
                <xsl:text>Kameroense</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0123'">
                <xsl:text>Kenyaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0124'">
                <xsl:text>Zaïrese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0125'">
                <xsl:text>Lesothaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0126'">
                <xsl:text>Liberiaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0127'">
                <xsl:text>Libische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0128'">
                <xsl:text>Malagassische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0129'">
                <xsl:text>Malawische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0130'">
                <xsl:text>Malinese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0131'">
                <xsl:text>Marokkaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0132'">
                <xsl:text>Burger van Mauritanië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0133'">
                <xsl:text>Burger van Mauritius</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0134'">
                <xsl:text>Mozambiquaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0135'">
                <xsl:text>Swazische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0136'">
                <xsl:text>Burger van Niger</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0137'">
                <xsl:text>Burger van Nigeria</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0138'">
                <xsl:text>Ugandese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0139'">
                <xsl:text>Guineebissause</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0140'">
                <xsl:text>Zuidafrikaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0142'">
                <xsl:text>Zimbabwaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0143'">
                <xsl:text>Rwandese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0144'">
                <xsl:text>Burger van São Tomé en Principe</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0145'">
                <xsl:text>Senegalese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0147'">
                <xsl:text>Sierraleoonse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0148'">
                <xsl:text>Soedanese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0149'">
                <xsl:text>Somalische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0151'">
                <xsl:text>Tanzaniaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0152'">
                <xsl:text>Togolese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0154'">
                <xsl:text>Tsjadische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0155'">
                <xsl:text>Tunesische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0156'">
                <xsl:text>Zambiaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0157'">
                <xsl:text>Zuidsoedanese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0200'">
                <xsl:text>Bahamaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0202'">
                <xsl:text>Belizaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0204'">
                <xsl:text>Canadese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0205'">
                <xsl:text>Costaricaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0206'">
                <xsl:text>Cubaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0207'">
                <xsl:text>Burger van Dominicaanse Republiek</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0208'">
                <xsl:text>Salvadoraanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0211'">
                <xsl:text>Guatemalteekse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0212'">
                <xsl:text>Haïtiaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0213'">
                <xsl:text>Hondurese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0214'">
                <xsl:text>Jamaicaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0216'">
                <xsl:text>Mexicaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0218'">
                <xsl:text>Nicaraguaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0219'">
                <xsl:text>Panamese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0222'">
                <xsl:text>Burger van Trinidad en Tobago</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0223'">
                <xsl:text>Amerikaans burger</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0250'">
                <xsl:text>Argentijnse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0251'">
                <xsl:text>Barbadaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0252'">
                <xsl:text>Boliviaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0253'">
                <xsl:text>Braziliaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0254'">
                <xsl:text>Chileense</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0255'">
                <xsl:text>Colombiaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0256'">
                <xsl:text>Ecuadoraanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0259'">
                <xsl:text>Guyaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0261'">
                <xsl:text>Paraguayaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0262'">
                <xsl:text>Peruaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0263'">
                <xsl:text>Surinaamse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0264'">
                <xsl:text>Uruguayaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0265'">
                <xsl:text>Venezolaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0267'">
                <xsl:text>Grenadaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0268'">
                <xsl:text>Burger van Saint Kitts-Nevis</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0300'">
                <xsl:text>Afgaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0301'">
                <xsl:text>Bahreinse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0302'">
                <xsl:text>Bhutaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0303'">
                <xsl:text>Burmaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0304'">
                <xsl:text>Bruneise</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0305'">
                <xsl:text>Kambodjaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0306'">
                <xsl:text>Srilankaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0307'">
                <xsl:text>Chinese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0308'">
                <xsl:text>Cyprische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0309'">
                <xsl:text>Filipijnse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0310'">
                <xsl:text>Taiwanese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0312'">
                <xsl:text>Burger van India</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0313'">
                <xsl:text>Indonesische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0314'">
                <xsl:text>Iraakse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0315'">
                <xsl:text>Iraanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0316'">
                <xsl:text>Israëlische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0317'">
                <xsl:text>Japanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0318'">
                <xsl:text>Noordjemenitische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0319'">
                <xsl:text>Jordaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0320'">
                <xsl:text>Koeweitse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0321'">
                <xsl:text>Laotiaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0322'">
                <xsl:text>Libanese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0324'">
                <xsl:text>Maldivische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0325'">
                <xsl:text>Maleisische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0326'">
                <xsl:text>Mongolische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0327'">
                <xsl:text>Omanitische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0328'">
                <xsl:text>Nepalese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0329'">
                <xsl:text>Noordkoreaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0331'">
                <xsl:text>Pakistaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0333'">
                <xsl:text>Katarese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0334'">
                <xsl:text>Saoediarabische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0335'">
                <xsl:text>Singaporaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0336'">
                <xsl:text>Syrische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0337'">
                <xsl:text>Thaise</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0338'">
                <xsl:text>Burger van de Ver.  Arabische Emiraten</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0339'">
                <xsl:text>Turkse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0340'">
                <xsl:text>Zuidjemenitische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0341'">
                <xsl:text>Zuidkoreaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0342'">
                <xsl:text>Viëtnamese</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0345'">
                <xsl:text>Burger van Bangladesh</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0400'">
                <xsl:text>Australische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0401'">
                <xsl:text>Burger van Papua-Nieuwguinea</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0402'">
                <xsl:text>Nieuwzeelandse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0404'">
                <xsl:text>Westsamoaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0421'">
                <xsl:text>Burger van Antigua en Barbuda</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0424'">
                <xsl:text>Vanuatuse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0425'">
                <xsl:text>Fijische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0429'">
                <xsl:text>Burger van Britse afhankelijke gebieden</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0430'">
                <xsl:text>Tongaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0431'">
                <xsl:text>Nauruaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0437'">
                <xsl:text>Amerikaans onderdaan</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0442'">
                <xsl:text>Solomoneilandse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0444'">
                <xsl:text>Seychelse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0445'">
                <xsl:text>Kiribatische</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0446'">
                <xsl:text>Tuvaluaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0447'">
                <xsl:text>Sintluciaanse</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0448'">
                <xsl:text>Burger van Dominica</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0449'">
                <xsl:text>Burger van Sint Vincent en de Grenadinen</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0450'">
                <xsl:text>British National (overseas)</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0451'">
                <xsl:text>Zaïrese (Congolese)</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0452'">
                <xsl:text>Burger van Timor Leste</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0453'">
                <xsl:text>Burger van Servië en Montenegro</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0454'">
                <xsl:text>Burger van Servië</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0455'">
                <xsl:text>Burger van Montenegro</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0499'">
                <xsl:text>Staatloos</xsl:text>
            </xsl:when>
            <xsl:when test="node() = '0500'">
                <xsl:text>Vastgesteld niet-Nederlander</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <fo:inline color="red">
                    <xsl:value-of select="node()"/>
                </fo:inline>
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>


</xsl:stylesheet>
