<?xml version="1.0" encoding="UTF-8"?>
<!--Overzicht van wijzigingen (hierbij komen de wijzigingen in included XSLT 'ValideerOSOgegevensset_20xx.1.xsl') -->
<!-- 20251217: Release van Validatie van Overstapprofielen versie "2026.1.1" voor afspraak versie "2026.1":
	 			Versienummer van de namespace, Naam van included XSLT-bestand en Validatie veld validatieversie aangepast naar 2026,
				Business rules OVa.LL03 & OVb.LL01 (bij Geboortemaand), OVa.LL07 & OVb.LL03 (bij Postcode4adres), OVa.LL10 & OVb.LL10 (bij Geboorteplaats) en OVa.LL11 & OVb.LL11 (bij Nationaliteit) zijn verwijderd, 
                Business rules OVa.OV06 & OVb.OV04 (bij Banknummer) zijn verwijderd. -->
<!-- 20250120: Release van Validatie van Overstapprofielen versie "2025.1.1" voor afspraak versie "2025.1":
	 			Versienummer van de namespace, Naam van included XSLT-bestand en Validatie veld validatieversie aangepast naar 2025,
	            Validatie van business rules OVa.SC01, OVa.LL05, OVa.OV03, OVb.LL02 en OVb.OV01 aangepast m.b.t. buitenlandadres 
	            Validatie van business rules OVa.SC02, OVa.LL05A, OVa.HA01, OVa.OV04, OVb.LL02A en OVb.OV02  toegevoegd m.b.t. maximaal aantal adressen 
	            ***
	            Let op, bij het testen van deze validatie XSLT is opgemerkt dat een deel van de validatie over toetsresultaten en verzorgers niet werd uitgevoerd; 
	             de oorzaak was 1 ontbrekend statement <xsl:apply-templates/> aan einde van validatie van leerling. Deze validatie is gecorrigeerd en werkt nu weer!  
                *** -->
<!-- 20231220: Release van Validatie van Overstapprofielen versie "2024.1.1" voor afspraak versie "2024.1", inclusief wijzigingen:
	 			Versienummer van de namespace aangepast naar "2024" (i.p.v. "2022"),
				Validatie van regel bij veld standaardversie aangepast,
			    Validatie van regel bij eindtoets_basisonderwijs vervangen door regel bij doorstroomtoets,
			    Validatie van regel bij eindtoetsresultaat vervangen door regel bij toetsresultaat,
			    Validatie van verplichtingsregel bij advies gewijzigd in voorlopig_schooladvies.     -->
<!-- 20211203:	Release van Validatie van Overstapprofielen versie "2022.1.1" voor afspraak versie "2022.1", inclusief wijzigingen: 
                Validatie van codelijsten 15, 35 en 36 verwijderd
                Validatie van BR OV.MD02 (veld <validatieversie>) gewijzigd: toegestane waarde is nu "2022.1.1" -->
<!-- 20230221:	Correctie van typefouten -->
<!-- 20211203:	Release van Validatie van Overstapprofielen versie "2022.1.1" voor afspraak versie "2022.1", inclusief wijzigingen: 
                Validatie van codelijsten 15, 35 en 36 verwijderd
                Validatie van BR OV.MD02 (veld <validatieversie>) gewijzigd: toegestane waarde is nu "2022.1.1" -->
<!-- 20210916:	UPDATE: Validatie van BR OV.MD02 (veld <validatieversie>) gewijzigd: toegestane waarden zijn nu "2019.1.2" en "2019.1.1" -->
<!-- 20210901:	Release van Validatie van Overstapprofielen versie 2019.1.2, inclusief wijzigingen: 
                Validatie van codelijst 9 aangepast (2 codes toegevoegd) en van codelijst 11 aangepast (3 codes toegevoegd)
                Validatie van BR OV.MD02 (veld <validatieversie>) gewijzigd: toegestane waarde is nu "2019.1.2"  -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs" xmlns:od="http://www.edustandaard.nl/oso_gegevensset/2026/dossier" 
	xmlns="http://www.edustandaard.nl/oso_gegevensset/2026/schemas/Meldingen" version="2.0" extension-element-prefixes="od">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>

	<!-- We lezen een paar gegevens uit het dossier die we later goed kunnen gebruiken -->
	<!--<xsl:variable name="typeDocument" select="local-name(/node())"/>-->
	<xsl:variable name="typeDocument" select="//od:overdrachtsoort/text()"/>
	<xsl:variable name="typeOverstap" select="/descendant-or-self::*/od:metadata/od:overstap/text()"/>
	<xsl:variable name="soortSchool" select="//od:huidigeschool/od:soort/text()"/>

	<xsl:variable name="dossierdeel" select="//od:metadata/od:deeldossier/text()"/>
	<xsl:variable name="heeftLAS">
		<xsl:choose>
			<xsl:when test="$dossierdeel='LAS' or $dossierdeel='LASLVS'">
				<xsl:text>Y</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>N</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="heeftLVS">
		<xsl:choose>
			<xsl:when test="$dossierdeel='LVS' or $dossierdeel='LASLVS'">
				<xsl:text>Y</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>N</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<!--<xsl:template match="/">
        <meldingen>
            <xsl:if test="not(($typeDocument='overstapdossier') or ($typeDocument='verrijkingsinput') or ($typeDocument='verrijkingsoutput'))">
                <xsl:call-template name="melding">
                    <xsl:with-param name="tekst">Het document moet een Overstapdossier, Verrijkingsinput of Verrijkingsoutput zijn.</xsl:with-param>
                </xsl:call-template>
            </xsl:if>

            <xsl:apply-templates/>
        </meldingen>
    </xsl:template>-->

	<!-- 20251217: Verwijzing naar deze validatie-XSLT gewijzigd -->
	<!-- 20250120: Verwijzing naar deze validatie-XSLT gewijzigd -->
	<!-- 20231220: Verwijzing naar deze validatie-XSLT gewijzigd -->
	<!-- 20211203: Verwijzing naar deze validatie-XSLT gewijzigd -->
	<!-- 20210901: Verwijzing naar deze validatie-XSLT gewijzigd -->
	<!-- 20190101: Verwijzing naar deze validatie-XSLT gewijzigd -->
	<!-- 20180102: Verwijzing naar deze validatie-XSLT gewijzigd -->
	<!-- 20170308: Validatie van codelijsten verplaatst naar apart bestand dat wordt hieronder include -->
	<xsl:include href="include/ValideerOSOgegevensset_2026.1.xsl"/>


	<xsl:template match="*|text()|@*">
		<xsl:apply-templates/>
	</xsl:template>

	<!-- _______________________________________________________ -->
	<!-- Metadata en algemene business rules                     -->
	<!-- _______________________________________________________ -->
	<xsl:template name="metadata" match="//od:dossier/od:metadata">
		<!-- _______________________________________________________ -->
		<!-- Algemene business rules t.b.v. profiel “Overstapdossier” -->
		<!-- _______________________________________________________ -->
		
		<!-- Afspraak OSO gegevensset + overstapprofielen + binnen-brin, business rule OVa.MD01 -->
		<!-- Afspraak OSO gegevensset + overstapprofielen + binnen-brin, business rule OVb.MD01  -->
		<xsl:if test="$heeftLAS='N'">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Het dossier voor overstap en overdracht-binnen-brin moet een LAS deel bevatten, en mag niet alleen een LVS of TIB deel bevatten.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.MD02 -->
		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVb.MD02 -->
		<!-- 20251217 aanpassing van de regel aan actuele versie "2026.1.1" -->
		<!-- 20250120 aanpassing van de regel aan actuele versie "2025.1.1" -->
		<!-- 20231220 aanpassing van de regel aan actuele versie "2024.1.1" -->
		<!-- 20211203 aanpassing van de regel aan actuele versie "2022.1.1" -->
		<!-- 20210916 Veld validatieversie heeft waarde "2019.1.1" of waarde "2019.1.2" -->
		<!-- 20210916 aanpassing van de regel aan actuele versie 2019.1.2, inclusief het backwards compatibele versie 2019.1.1 -->
		<!-- 20210901 aanpassing volgende regel aan actuele versie 2019.1.2 -->
		<!-- 20190101 aanpassing volgende regel aan actuele versie -->
		<!-- 20180102 aanpassing volgende regel aan actuele versie -->
		<!-- 20170308 aanpassing volgende regel -->
		<!-- 20161128 deze regel aangepast aan nieuwe XSD -->
		<!-- 20160223 volgende regel toegevoegd -->
		<xsl:if test="not(od:validatieversie='2026.1.1')">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">De validatieversie is niet correct voor deze versie "2026.1.1" van de validatie XSLT.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.OS03 -->
		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVb.OS01 -->
		<!-- Bij overstapdossier heeft veld soort overdracht de waarde overstapdossier of overdrachtbinnenbrin -->
		<!-- 20131128 volgende regel toegevoegd -->
		<xsl:if test="not($typeDocument='overstapdossier') and not($typeDocument='overdrachtbinnenbrin')">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Het veld Soort overdracht heeft waarde "overstapdossier" of "overdrachtbinnenbrin".</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<!-- _______________________________________________________ -->
		<!-- Metadata business rules t.b.v. profiel “Overstapdossier” -->
		<!-- _______________________________________________________ -->
		
		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.MD03 -->
		<!-- Veld categorie_uitlevering is verplicht voor overstapdossiers -->
		<!-- 20170308 volgende regel toegevoegd -->
		<xsl:if test="($typeDocument='overstapdossier') and not(od:categorie_uitlevering)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Een overstapdossier moet het blok "Categorie uitlevering" bevatten.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.OS01 -->
		<!-- Veld Soort overstap verplicht bij alle overstapdossiers -->
		<!-- 20131128 volgende regel toegevoegd -->
		<xsl:if test="($typeDocument='overstapdossier') and  not(od:overstap)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Een overstapdossier moet de aanduiding voor soort overstap bevatten.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.OS02 -->
		<!-- Veld Soort overstap heeft waarde POPO, POVO of VOVO -->
		<!-- 20131128 volgende regel toegevoegd -->
		<xsl:if test="($typeDocument='overstapdossier') and not($typeOverstap='POPO') and not($typeOverstap='POVO') and not($typeOverstap='VOVO')">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Het veld 'Soort overstap' heeft waarde "POPO", "POVO" of "VOVO" binnen een overstapdossier.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- ______________________________________________________________ -->
		<!-- Metadata business rules t.b.v. profiel “Overstap-binnen-brin” -->
		<!-- ______________________________________________________________ -->
		
		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVb.MD03 -->
		<!-- Veld categorie_uitlevering is verplicht voor overstapdossiers -->
		<!-- 20170308 volgende regel toegevoegd -->
		<xsl:if test="($typeDocument='overdrachtbinnenbrin') and not(od:categorie_uitlevering)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Een binnen-brin dossier moet het blok "Categorie uitlevering" bevatten.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		
	</xsl:template>

	<!-- ______________________________________________________ -->
	<!-- Dossier business rules                                 -->
	<!-- ______________________________________________________ -->
	<xsl:template name="dossier" match="//od:dossier">
		
		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.IZ01 -->
		<!--In een overstapdossier moet de inzage node aanwezig zijn.-->
		<xsl:if test="($typeDocument='overstapdossier') and not(//od:dossier/od:inzage)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Een overstapdossier moet het gegevensblok 'Inzage' bevatten.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<xsl:apply-templates/>
	</xsl:template>
	
	<!-- _____________________________________________________ -->
	<!-- Inzage business rules                                 -->
	<!-- _____________________________________________________ -->
	<xsl:template name="inzage" match="//od:dossier/od:inzage">
		<!-- _____________________________________________________ -->
		<!-- Inzage business rules t.b.v. profiel “Overstapdossier” -->
		<!-- _____________________________________________________ -->
		
		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.IZ02 -->
		<!--In een overstapdossier moet de inzage node aanwezig zijn.-->
		<!-- 20131128 volgende regel toegevoegd -->
		<xsl:if test="($typeDocument='overstapdossier') and not(xs:boolean(//od:inzage/od:inzage))">

			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Elk overstapdossier moet zijn ingezien door ouders/verzorgers, ofwel het veld 'Inzage ouders' moet waarde "Ja" (true) bevatten.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.IZ03 -->
		<!--Als er ook inzage geweest is, is datum van inzage verplicht. -->
		<xsl:if test="($typeDocument='overstapdossier') and xs:boolean(od:inzage) and not(od:inzagedatum)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">In overstapdossier is 'Inzagedatum' verplicht als er inzage is geweest.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.IZ04 -->
		<!--Als er ook inzage geweest is, is een waarde van akkoord verplicht. -->
		<xsl:if test="($typeDocument='overstapdossier') and xs:boolean(od:inzage) and not(od:akkoord)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">In overstapdossier is de indicatie of ouders het wel of niet eens zijn met de inhoud verplicht als er inzage is geweest.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + overstapprofielen verie "2026.1", business rule OVa.IZ05 -->
		<!-- 20211203 Regel verwijderd voor versie "2022.1.1" -->
		<!-- 20150216: Veld "toestemming" verplicht bij VOVO-overstap -->
		<!--<xsl:if test="($typeDocument='overstapdossier') and ($typeOverstap='VOVO') and not(od:toestemming)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Het veld 'Toestemming' is verplicht bij een VOVO-overstap.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>-->
		
		<xsl:apply-templates/>
	</xsl:template>
	
	<!-- _____________________________________________________________ -->
	<!-- Huidige school business rules                                 -->
	<!-- _____________________________________________________________ -->
	<xsl:template name="huidigeschool" match="od:huidigeschool">
		<!-- _____________________________________________________________ -->
		<!-- Huidige school business rules t.b.v. profiel “Overstapdossier” -->
		<!-- _____________________________________________________________ -->

		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.SC01 -->
		<!-- In een overstapdossier is bij school minimaal 1 adres verplicht en zijn niet meer dan vijf adressen toegestaan-->
		<!-- 20250120: validatie van deze business rule voor buitenlands adres toegevoegd -->
		<xsl:if test="($typeDocument='overstapdossier') and not(od:adreslijst/od:adres) and not(od:adreslijst/od:buitenlandadres)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">In een overstapdossier is minimaal één adres verplicht bij een school.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.SC02 -->
		<!-- Maximaal vijf adressen zijn bij een school toegestaan -->
		<!-- 20250120: validatie van deze business rule toegevoegd -->
		<xsl:if test="($typeDocument='overstapdossier') and (count(od:adreslijst/od:adres)+count(od:adreslijst/od:buitenlandadres) &gt; 5)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">In een overstapdossier zijn niet meer dan vijf adressen (binnenlands of buitenlands) bij een school toegestaan!</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.SC03 -->
		<!-- In een overstapdossier is bij school communicatie verplicht -->
		<xsl:if test="($typeDocument='overstapdossier') and not(od:communicatielijst/od:communicatie)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">In een overstapdossier is minimaal één set communicatiegegevens verplicht bij een school.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<xsl:apply-templates/>
	</xsl:template>

	<!-- ________________________________________________________ -->
	<!-- Leerling business rules                                 -->
	<!-- ________________________________________________________ -->
	<xsl:template name="leerling" match="od:leerling">
		<!-- ________________________________________________________ -->
		<!-- Leerling business rules t.b.v. profiel “Overstapdossier” -->
		<!-- ________________________________________________________ -->
		
		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.LL01 -->
		<!-- In een overstapdossier is bij leerling voornaam verplicht -->
		<xsl:if test="($typeDocument='overstapdossier') and not(od:voornaam)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">In een overstapdossier is minimaal één voornaam verplicht bij een leerling.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.LL02 -->
		<!-- In een overstapdossier is bij leerling geboortedatum verplicht -->
		<xsl:if test="($typeDocument='overstapdossier') and not(od:geboortedatum)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">In een overstapdossier is de geboortedatum verplicht bij een leerling.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + overstapprofielen voor versies 2025.1 en eerder, business rule OVa.LL03 -->
		<!-- In een overstapdossier is bij leerling geboortemaand verboden -->
		<!-- 20251217 verwijderd omdat het veld <geboortemaand> is verwijderd uit de gegevensset bij versie 2026.1 -->
		<!-- 20160120: validatie van business rule toegevoegd -->
		<!-- <xsl:if test="($typeDocument='overstapdossier') and (od:geboortemaand)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">In een overstapdossier is de geboortemaand verboden bij een leerling.</xsl:with-param>
			</xsl:call-template>
		</xsl:if> -->
		
		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.LL04 -->
		<!-- In een overstapdossier is bij leerling indicatie adresgeheim verplicht -->
		<xsl:if test="($typeDocument='overstapdossier') and not(od:adresgeheim)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">In een overstapdossier is de indicatie 'adres geheim' verplicht bij een leerling.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.LL05 -->
		<!-- Bij leerling adres of adresbuitenland verplicht (todo: toevoegen of NL-adres of buitenlands adres, niet beiden?) -->
		<!-- 20250120: validatie van deze business rule voor buitenlands adres buitenlandadres toegevoegd -->
		<!-- 20150529 gewijzigd naar adres of adresbuitenland verplicht indien adres niet geheim is -->
		<!-- 20131128 gewijzigd van adres verplicht naar adres of adresbuitenland verplicht -->
		<xsl:if test="($typeDocument='overstapdossier') and not(xs:boolean(od:adresgeheim)) and not(od:adreslijst/od:adres) and not(od:adreslijst/od:buitenlandadres) and not(od:adresbuitenland)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Minimaal één Nederlands of buitenlands adres is verplicht bij een leerling waarvan het adres niet geheim is.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.LL05A -->
		<!-- Maximaal vijf adressen zijn toegestaan bij een leerling -->
		<!-- 20250120: validatie van deze business rule toegevoegd -->
		<xsl:if test="($typeDocument='overstapdossier') and (count(od:adreslijst/od:adres)+count(od:adreslijst/od:buitenlandadres) &gt; 5)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">In een overstapdossier zijn niet meer dan vijf adressen (binnenlands of buitenlands) bij een leerling toegestaan!</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.LL06 -->
		<!-- Bij leerling is indien adres geheim adres verboden -->
		<!-- 20250120: validatie van deze business rule aangepast (adreslijst ipv adres) -->
		<!-- 20160120: validatie van business rule toegevoegd -->
		<xsl:if test="($typeDocument='overstapdossier') and (xs:boolean(od:adresgeheim)) and (od:adreslijst)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Indien een adres van leerling geheim, is ieder leerlingadres in overstapdossier verboden.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<!-- Afspraak OSO gegevensset + overstapprofielen voorversies 2025.1 en eerder, business rule OVa.LL07 -->
		<!-- In een overstapdossier is postcode4adres verboden -->
		<!-- 20251217 verwijderd omdat het veld <postcode4adres> is verwijderd uit de gegevensset bij versie 2026.1 -->
		<!-- 20160120: validatie van deze business rule toegevoegd -->
		<!-- <xsl:if test="($typeDocument='overstapdossier') and (od:postcode4adres)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">In een overstapdossier is de postcode4-adres verboden bij een leerling.</xsl:with-param>
			</xsl:call-template>
		</xsl:if> -->
		
		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.LL08 -->
		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.OV05 -->
		<!-- In een overstapdossier bij persoon (leerling, verzorger, etc.) geheimwaarde van communicatie doorgeven wanneer deze communicatie geheim is -->
		<!-- 20160120: validatie van deze business rule toegevoegd -->
		<xsl:for-each select="/descendant::*/od:communicatie">
			<xsl:if test="($typeDocument='overstapdossier') and (xs:boolean(od:geheim)) and (xs:string(od:soort)='telefoon') and not(xs:string(od:nummer)='9999999999')">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">In een overstapdossier is geheime communicatieinfo over telefoon verplicht middels de geheimwaarde "9999999999".</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="($typeDocument='overstapdossier') and (xs:boolean(od:geheim)) and (xs:string(od:soort)='e-mail') and not(xs:string(od:nummer)='geheim@geheim.geheim')">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">In een overstapdossier is geheime communicatieinfo over e-mail verplicht middels de geheimwaarde "geheim@geheim.geheim".</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
		</xsl:for-each>
		
		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.LL09 -->
		<!-- Bij leerling is indien adres geheim adresbuitenland verboden -->
		<!-- 20160120: validatie van business rule toegevoegd -->
		<xsl:if test="($typeDocument='overstapdossier') and (xs:boolean(od:adresgeheim)) and (od:adresbuitenland)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Indien een adres van leerling geheim, is een buitenlands leerlingadres in 'Adres buitenland'verboden.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<!-- Afspraak OSO gegevensset + overstapprofielen voor versies 2025.1 en eerder, business rule OVa.LL10 -->
		<!-- geboorteplaats verboden bij alle overstapdossiers -->
		<!-- 20251217 verwijderd omdat het veld <geboorteplaats> is verwijderd uit de gegevensset bij versie 2026.1 -->
		<!-- 20131128 toegevoegd -->
		<!-- <xsl:if test="($typeDocument='overstapdossier') and (od:geboorteplaats)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">De geboorteplaats van de leerling is verboden in alle overstapdossiers.</xsl:with-param>
			</xsl:call-template>
		</xsl:if> -->

		<!-- Afspraak OSO gegevensset + overstapprofielen voor versies 2025.1 en eerder, business rule OVa.LL11 -->
		<!-- nationaliteit verboden bij alle overstapdossiers -->
		<!-- 20251217 verwijderd omdat het veld <nationaliteit> is verwijderd uit de gegevensset bij versie 2026.1 -->
		<!-- 20131128 toegevoegd -->
		<!-- <xsl:if test="($typeDocument='overstapdossier') and (od:nationaliteit)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">De nationaliteit van de leerling is verboden in een overstapdossier.</xsl:with-param>
			</xsl:call-template>
		</xsl:if> -->

		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.LL12 -->
		<!-- BSN of onderwijsnummer is verplicht in alle overstapdossiers -->
		<xsl:if test="($typeDocument='overstapdossier') and (not(od:bsn) and not(od:onderwijsnummer))">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">BSN of onderwijsnummer is verplicht bij een leerling in een overstapdossier.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.LL13 -->
		<!-- leerlingid alleen bij POVO overstapdossier -->
		<!--<xsl:if test="$typeDocument='overstapdossier' and $typeOverstap='POVO' and not(od:leerlingid) ">-->
		<!--<xsl:if test="($typeDocument='overstapdossier' or $typeDocument='verrijkingsinput') and $typeOverstap='POVO' and not(od:leerlingid) ">-->
		<xsl:if test="($typeDocument='overstapdossier') and ($typeOverstap='POVO') and not(od:leerlingid) ">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">De code van de leerling in de schooladministratie is verplicht in een POVO-overstapdossier.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.LL14 -->
		<!-- datum van inschrijving verplicht bij overstapdossier -->
		<xsl:if test="($typeDocument='overstapdossier') and not(od:datuminschrijving)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Inschrijfdatum is verplicht bij een leerling in een overstapdossier.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.HA01 -->
		<!-- Maximaal vijf adressen zijn toegestaan bij een huisarts. -->
		<!-- 20250120: validatie van deze business rule toegevoegd -->
		<xsl:if test="($typeDocument='overstapdossier') and (count(od:huisarts/od:adreslijst/od:adres)+count(od:huisarts/od:adreslijst/od:buitenlandadres) &gt; 5)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">In een overstapdossier zijn niet meer dan vijf adressen (binnenlands of buitenlands) bij een huisarts toegestaan!</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.AI01 -->
		<!-- Een overstapdossier moet het veld “Verzorgers zijn aansprakelijk?” bevatten -->
		<!-- 20131128 toegevoegd -->
		<xsl:if test="($typeDocument='overstapdossier')  and  not(od:verzorgersaansprakelijk)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">De aanduiding of verzorgers wel of niet aansprakelijk zijn is verplicht in een overstapdossier.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.AI02 -->
		<!-- In een overstapdossier is Aansprakelijke instelling verplicht als de verzorgers niet aansprakelijk zijn -->
		<!-- 20180704: correctie van foutmelding voor POVO: ...verplicht in een POVO-overstapdossier... (was VOVO-overstapdossier) -->
		<!-- 20170308 regel gewijzigd: alleen voor POPO en POVO; 20131128 volgende regel gewijzigd //od:huidigeschool/od:leerling/ ervoor -->
		<xsl:if test="($typeDocument='overstapdossier') and ($typeOverstap='POPO') and not(xs:boolean(od:verzorgersaansprakelijk)) and not(od:aansprakelijkeinstelling)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Aansprakelijke instelling is verplicht in een POPO-overstapdossier als de verzorgers niet aansprakelijk zijn.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="($typeDocument='overstapdossier') and ($typeOverstap='POVO') and not(xs:boolean(od:verzorgersaansprakelijk)) and not(od:aansprakelijkeinstelling)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Aansprakelijke instelling is verplicht in een POVO-overstapdossier als de verzorgers niet aansprakelijk zijn.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.VV01 -->
		<!-- Voorschools alleen toegestaan bij POPO-overstap -->
		<xsl:if test="($typeDocument='overstapdossier') and not($typeOverstap='POPO') and od:voorschools">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Voorschools is alleen toegestaan bij een POPO-overstap.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.VV02 -->
		<!-- Vroegschools alleen toegestaan bij POPO-overstap -->
		<xsl:if test="($typeDocument='overstapdossier') and not($typeOverstap='POPO') and od:vroegschools">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Vroegschools is alleen toegestaan bij een POPO-overstap.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.SL01 -->
		<!-- In een overstapdossier is schoolloopbaan verplicht -->
		<xsl:if test="($typeDocument='overstapdossier') and not(od:schoolloopbaanlijst/od:schoolloopbaan)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Minimaal één schoolloopbaan is verplicht bij een leerling in een overstapdossier.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.OA01 -->
		<!--In een overstapdossier moet de overstapadvies node aanwezig zijn.-->
		<xsl:if test="($typeDocument='overstapdossier') and not(od:overstapadvies)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Een overstapdossier moet het gegevensblok 'Overstapadvies' bevatten.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + overstapprofielen voor versie 2015 en eerder, business rule OVa.TR01 -->
		<!-- Minimaal 1 toets verplicht bij POVO-overstap in dossier met begeleidingsgegevens -->
		<!-- 20150529 Deze business rule is als verplichting vervallen, wel aanbevolen dus commentaar -->
		<!--<xsl:if test="($typeDocument='overstapdossier') and ($heeftLVS='Y') and $typeOverstap='POVO' and not(od:toetslijst/od:toets)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Minimaal één toets is verplicht bij een leerling in een POVO-overstapdossier met begeleidingsgegevens.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>-->
		
		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.OV01 -->
		<!-- Test of het blok verzorger afwezig is wanneer 'verzorgersaansprakelijk' waar is-->
		<xsl:if test="($typeDocument='overstapdossier') and (xs:boolean(od:verzorgersaansprakelijk)) and not(od:verzorger)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Minimaal één verzorger is verplicht in een overstapdossier als de verzorgers aansprakelijk zijn.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>


		<!-- ______________________________________________________________ -->
		<!-- Leerling business rules t.b.v. profiel “Overstap-binnen-brin” -->
		<!-- ______________________________________________________________ -->
		
		<!-- Afspraak OSO gegevensset + overstapprofielen voor versies 2025.1 en eerder, business rule OVb.LL01 -->
		<!-- In een Overstap-binnen-brin is bij leerling geboortemaand verboden -->
		<!-- 20251217 verwijderd omdat het veld <geboortemaand> is verwijderd uit de gegevensset bij versie 2026.1 -->
		<!-- 20160120: validatie van deze business rule toegevoegd -->
		<!-- <xsl:if test="($typeDocument='overdrachtbinnenbrin') and (od:geboortemaand)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">In een overdracht-binnen-brin is de geboortemaand verboden bij een leerling.</xsl:with-param>
			</xsl:call-template>
		</xsl:if> -->

		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVb.LL02 -->
		<!-- Bij leerling is indien adres geheim adres in Overstap-binnen-brin verboden -->
		<!-- 20250120: validatie van deze business rule aangepast (adreslijst ipv adres) -->
		<!-- 20160120: validatie van deze business rule toegevoegd -->
		<xsl:if test="($typeDocument='overdrachtbinnenbrin') and (xs:boolean(od:adresgeheim)) and (od:adreslijst)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Indien een adres van leerling geheim, is ieder leerlingadres in overdracht-binnen-brin verboden.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVb.LL02A -->
		<!-- Maximaal vijf adressen zijn toegestaan bij een leerling. -->
		<!-- 20250120: validatie van deze business rule toegevoegd -->
		<xsl:if test="($typeDocument='overdrachtbinnenbrin') and (count(od:adreslijst/od:adres)+count(od:adreslijst/od:buitenlandadres) &gt; 5)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">In een overdracht-binnen-brin zijn niet meer dan vijf adressen (binnenlands of buitenlands) bij een leerling toegestaan!</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + overstapprofielen voor versies 2025.1 en eerder, business rule OVb.LL03 -->
		<!-- In een Overstap-binnen-brin is postcode4adres verboden -->
		<!-- 20251217 verwijderd omdat het veld <postcode4adres> is verwijderd uit de gegevensset bij versie 2026.1 -->
		<!-- 20160120: validatie van deze business rule toegevoegd -->
		<!-- <xsl:if test="($typeDocument='overdrachtbinnenbrin') and (od:postcode4adres)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">In een overdracht-binnen-brin is de postcode4-adres verboden bij een leerling.</xsl:with-param>
			</xsl:call-template>
		</xsl:if> -->
		
		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVb.LL04 -->
		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVb.OV03 -->
		<!-- In een Overstap-binnen-brin bij persoon (leerling,verzorger,etc.) geheimwaarde van communicatie doorgeven wanneer deze communicatie geheim is -->
		<!-- 20160120: validatie van deze business rule toegevoegd -->
		<xsl:for-each select="/descendant::*/od:communicatie">
			<xsl:if test="($typeDocument='overdrachtbinnenbrin') and (xs:boolean(od:geheim)) and (xs:string(od:soort)='telefoon') and not(xs:string(od:nummer)='9999999999')">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">In een overdracht-binnen-brin is geheime communicatieinfo over telefoon verplicht middels de geheimwaarde "9999999999".</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="($typeDocument='overdrachtbinnenbrin') and (xs:boolean(od:geheim)) and (xs:string(od:soort)='e-mail') and not(xs:string(od:nummer)='geheim@geheim.geheim')">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">In een overdracht-binnen-brin is geheime communicatieinfo over e-mail verplicht middels de geheimwaarde "geheim@geheim.geheim".</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
		</xsl:for-each>
		
		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVb.LL05 -->
		<!-- Bij leerling is indien adres geheim adresbuitenland in een Overstap-binnen-brin verboden -->
		<!-- 20160120: validatie van deze business rule toegevoegd -->
		<xsl:if test="($typeDocument='overdrachtbinnenbrin') and (xs:boolean(od:adresgeheim)) and (od:adresbuitenland)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Indien een adres van leerling geheim, is een buitenlands leerlingadres in overdracht-binnen-brin verboden.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<!-- Afspraak OSO gegevensset + overstapprofielen voor versies 2025.1 en eerder, business rule OVb.LL10 -->
		<!-- geboorteplaats verboden bij alle overstapdossiers, dus ook in BB -->
		<!-- 20251217 verwijderd omdat het veld <geboorteplaats> is verwijderd uit de gegevensset bij versie 2026.1 -->
		<!-- 20190101 toegevoegd -->
		<!-- <xsl:if test="($typeDocument='overdrachtbinnenbrin') and (od:geboorteplaats)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">De geboorteplaats van de leerling is verboden in een overstapdossier, dus ook voor overdracht-binnen-brin.</xsl:with-param>
			</xsl:call-template>
		</xsl:if> -->
		
		<!-- Afspraak OSO gegevensset + overstapprofielen voor versies 2025.1 en eerder, business rule OVb.LL11 -->
		<!-- nationaliteit verboden bij alle overstapdossiers -->
		<!-- 20251217 verwijderd omdat het veld <nationaliteit> is verwijderd uit de gegevensset bij versie 2026.1 -->
		<!-- 20190101 toegevoegd -->
		<!-- <xsl:if test="($typeDocument='overdrachtbinnenbrin') and (od:nationaliteit)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">De nationaliteit van de leerling is verboden in een overstapdossier, dus ook voor overdracht-binnen-brin.</xsl:with-param>
			</xsl:call-template>
		</xsl:if> -->
		
		<!-- data dictionary regel 348: Bevorderd of Examenresultaat -->
		<!--<xsl:if test="($typeDocument='overstapdossier') and ($typeOverstap='VOMBO') and (not(od:bevorderd) and not(od:examenresultaat))">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Bij een VO-MBO overstap is of een waarde voor Bevorderd, of een waarde voor Examenresultaat verplicht.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>-->

		<xsl:apply-templates/>
	</xsl:template>

	<!-- _____________________________________________________________ -->
	<!-- Overstapadvies business rules                                 -->
	<!-- _____________________________________________________________ -->
	<xsl:template name="overstap" match="od:overstapadvies">
		<!-- _____________________________________________________________ -->
		<!-- Overstapadvies business rules t.b.v. profiel “Overstapdossier” -->
		<!-- _____________________________________________________________ -->

		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.OA02 -->
		<!-- Voorlopig schooladvies is verplicht bij een POVO-overstap, WECVO-scholen zijn uitgezonderd -->
		<!-- 20331220 verplichting advies gewijzigd in voorlopig_schooladvies, inclusief gewijzigde foutmelding -->
		<!-- 20131128 gewijzigd in uitzondering van advies voor SO-scholen -->
		<xsl:if test="($typeDocument='overstapdossier') and ($typeOverstap='POVO') and not($soortSchool='SO') and not(od:voorlopig_schooladvies)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Voorlopig schooladvies is verplicht bij een POVO-overstap, SO-scholen uitgezonderd.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.OA03 -->
		<!-- contactnodig verplicht bij alle overstapdossiers -->
		<!-- 20131128 toegevoegd -->
		<xsl:if test="($typeDocument='overstapdossier')  and  not(od:contactnodig)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">De aanduiding of contact wel of niet nodig is, is verplicht in een overstapdossier.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.OA04 -->
		<!-- contactpersoon verplicht bij contactnodig -->
		<xsl:if test="($typeDocument='overstapdossier') and xs:boolean(od:contactnodig)">
			<xsl:if test="not(od:contactpersoon)">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">In overstapdossier is Contactpersoon verplicht als contact nodig is.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.OA05 -->
		<!-- contacttelefoon verplicht bij contactnodig -->
		<xsl:if test="($typeDocument='overstapdossier') and xs:boolean(od:contactnodig)">
			<xsl:if test="not(od:contacttelefoon)">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">In overstapdossier is Telefoonnummer verplicht als contact nodig is.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
		</xsl:if>

		<xsl:apply-templates/>
	</xsl:template>

	<!-- _______________________________________________________________ -->
	<!-- Doorstroomtoets business rules                                  -->
	<!-- _______________________________________________________________ -->
	<xsl:template name="doorstroomtoets" match="od:doorstroomtoets">
		<!-- _______________________________________________________________ -->
		<!-- Doorstroomtoets business rules t.b.v. profiel “Overstapdossier” -->
		<!-- _______________________________________________________________ -->

		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.EB01 -->
		<!-- Aanbeveling: niet verplicht -->

		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.EB02 -->
		<!-- Bij deelname van doorstroomtoets is toetsresultaat verplicht -->
		<!-- 20231220 eindtoets_basisonderwijs vervangen door doorstroomtoets en eindtoetsresultaat vervangen door toetsresultaat, inclusief gewijzigde foutmelding -->
		<!-- 20150216 BR toegevoegd -->
		<xsl:if test="($typeDocument='overstapdossier') and xs:boolean(od:deelgenomen) and not(od:toetsresultaat)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Indien leerling heeft deelgenomen aan de doorstroomtoets moet het blok 'Toetsresultaat' aanwezig zijn.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.EB03 -->
		<!-- Bij geen deelname of ontheffing van eindtoets is identificatie van toets (toetssoort) verplicht -->
		<!-- 20231220 eindtoetsresultaat vervangen door toetsresultaat, inclusief gewijzigde foutmeldingen -->
		<!-- 20160120 BR gewijzigd (ontheffing en toetsidentificatie vervangen door eindtoetsresultaat/wettelijke_ontheffing resp. toetssoort) -->
		<!-- 20150216 BR toegevoegd -->
		<xsl:if test="($typeDocument='overstapdossier') and not(xs:boolean(od:deelgenomen)) and not(od:toetsresultaat/od:toetssoort)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Indien leerling niet heeft deelgenomen aan de doorstroomtoets moet binnen eindtoets het 'Soort doorstroomtoets' aanwezig zijn.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="($typeDocument='overstapdossier') and xs:boolean(od:wettelijke_ontheffing) and not(od:toetsresultaat/od:toetssoort)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Indien leerling ontheffing heeft voor deelname aan de doorstroomtoets moet binnen doorstroomtoets het 'Soort doorstroomtoets' aanwezig zijn.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.EB04 -->
		<!-- 20231220 eindtoetsresultaat vervangen door toetsresultaat, inclusief gewijzigde foutmelding -->
		<!-- 20150216: Bij deelname van eindtoets is toets verplicht -->
		<!-- 20160120 BR gewijzigd (toetsadvies vervangen door eindtoetsresultaat/toets_advies) -->
		<!-- 20150216 BR toegevoegd -->
		<xsl:if test="($typeDocument='overstapdossier') and xs:boolean(od:deelgenomen) and not(od:toetsresultaat/od:toets_advies)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Indien leerling heeft deelgenomen aan de doorstroomtoets moet het veld 'Toetsadvies' aanwezig zijn.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<xsl:apply-templates/>
	</xsl:template>
	
	<!-- ______________________________________________________________ -->
	<!-- Toetsresultaten Business rules                                 -->
	<!-- ______________________________________________________________ -->

	<xsl:template name="toets" match="od:toets">
		<!-- ______________________________________________________________ -->
		<!-- Toetsresultaten Business rules t.b.v. profiel “Overstapdossier” -->
		<!-- ______________________________________________________________ -->
		
		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.TR04 -->
		<!-- alleen de toetsen van huidig, vorig en eervorig schooljaar zijn toestaan bij een POVO-overstap. Een schooljaar loopt van 1 augustus t/m 31 juli -->
		<xsl:variable name="documentdatum" select="xs:date(//od:metadata/od:datum)"/>
		<xsl:variable name="beginSchooljaar" select="xs:date(concat(year-from-date($documentdatum),'-08-01'))"/>
		<xsl:variable name="toetsdatumVanaf">
			<xsl:choose>
				<xsl:when test="$documentdatum lt $beginSchooljaar">
					<xsl:value-of select="xs:date(concat(year-from-date($documentdatum) - 3, '-08-01'))"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="xs:date(concat(year-from-date($documentdatum) - 2, '-08-01'))"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$typeOverstap='POVO' and od:afname[xs:date(od:afnamedatum) lt xs:date($toetsdatumVanaf)]">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Alleen toetsen uit het huidige en twee voorgaande schooljaren mogen aanwezig zijn in de POVO-overstap.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<xsl:apply-templates/>
	</xsl:template>
	
	
	<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.TR05 -->
	<!-- Een toetsresultaat moet minimaal een score, een referentiescore of een bijlage bevatten	-->
	<xsl:template name="toetsresultaat" match="od:resultaat">
		<xsl:if test="($typeDocument='overstapdossier') and not(od:toetsscore) and not(od:referentiescore) and not(od:document)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Een toetsresultaat moet minimaal een score, een referentiescore of een bijlage bevatten.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<xsl:apply-templates/>
	</xsl:template>

	<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.TR06 -->
	<!-- Een toetsscore moet minimaal het aantal goed, het aantal fout, het aantal gelezen, de tijd of de vaardigheidsscore bevatten -->
	<!-- 20230221: correctie van typefout in vaardigheidsscore (was vaardigeheidsscore) in meldingstekst -->
	<xsl:template name="toetsscore" match="od:toetsscore">
		<xsl:if test="($typeDocument='overstapdossier') and not(od:aantalopgaven)and not(od:aantalgoed) and not(od:aantalfout) and not(od:aantalgelezen) and not(od:tijd) and not(od:vaardigheidsscore)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Een toetsscore moet minimaal het aantal opgaven, het aantal goed, het aantal fout, het aantal gelezen, de tijd of de vaardigheidsscore bevatten.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<xsl:apply-templates/>
	</xsl:template>

	<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.CL01 -->
	<!-- Een score moet minimaal een waarde of een kwalificatie bevatten -->
	<!-- 20250120: Opmerking: validatie overbodig door schemavalidatie (waarde is verplicht veld binnen referentiescore en dus altijd aanwezig) -->
	<xsl:template name="toetsreferentiescore" match="od:score">
		<xsl:if test="($typeDocument='overstapdossier') and not(od:waarde) and not(od:kwalificatie)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Een referentiescore moet minimaal een waarde of een kwalificatie bevatten.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<xsl:apply-templates/>
	</xsl:template>

	<!-- ________________________________________________________ -->
	<!-- Verzorger business rules                                 -->
	<!-- ________________________________________________________ -->
	<xsl:template name="verzorger" match="od:verzorger">
		<!-- ________________________________________________________ -->
		<!-- Verzorger business rules t.b.v. profiel “Overstapdossier” -->
		<!-- ________________________________________________________ -->
		
		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.OV03 -->
		<!-- Bij verzorger is indien adres geheim adres verboden -->
		<!-- 20250120: validatie van deze business rule aangepast (adreslijst ipv adres) -->
		<!-- 20160120: validatie van deze business rule toegevoegd -->
		<xsl:if test="($typeDocument='overstapdossier') and (xs:boolean(od:adresgeheim)) and (od:adreslijst)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Indien het adres van de verzorger geheim, is ieder verzorgeradres in overstapdossier verboden.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.OV04 -->
		<!-- Maximaal vijf adressen zijn toegestaan bij een verzorger. -->
		<!-- 20250120: validatie van deze business rule toegevoegd -->
		<xsl:if test="($typeDocument='overstapdossier') and (count(od:adreslijst/od:adres)+count(od:adreslijst/od:buitenlandadres) &gt; 5)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">In een overstapdossier is meer dan vijf adressen (binnenlands of buitenlands) bij een verzorger verboden!</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVa.OV06-->
		<!-- Bij verzorger is banknummer verboden -->
		<!-- 20251217 verwijderd omdat het veld <banknummer> is verwijderd uit de gegevensset bij versie 2026.1 -->
		<!--<xsl:if test="($typeDocument='overstapdossier') and (od:banknummer)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Voor een verzorger is een banknummer in overstapdossier verboden.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>-->
		

		<!-- _______________________________________________________________ -->
		<!-- Verzorger business rules t.b.v. profiel “Overstap-binnen-brin” -->
		<!-- _______________________________________________________________ -->
		
		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVb.OV01 -->
		<!-- Bij verzorger is indien adres geheim adres in Overstap-binnen-brin verboden -->
		<!-- 20250120: validatie van deze business rule aangepast (adreslijst ipv adres) -->
		<!-- 20160120: validatie van deze business rule toegevoegd -->
		<xsl:if test="($typeDocument='overdrachtbinnenbrin') and (xs:boolean(od:adresgeheim)) and (od:adreslijst)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Indien een adres van verzorger geheim, is ieder verzorgeradres in overdracht-binnen-brin verboden.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVb.OV02 -->
		<!-- Bij verzorger zijn maximaal vijf adressen in Overstap-binnen-brin toegestaan -->
		<!-- 20250120: validatie van deze business rule toegevoegd -->
		<xsl:if test="($typeDocument='overdrachtbinnenbrin') and (count(od:adreslijst/od:adres)+count(od:adreslijst/od:buitenlandadres) &gt; 5)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">In een overdracht-binnen-brin is meer dan vijf adressen (binnenlands of buitenlands) bij een verzorger verboden!</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule OVb.OV04-->
		<!-- Bij verzorger is banknummer verboden -->
		<!-- 20251217 verwijderd omdat het veld <banknummer> is verwijderd uit de gegevensset bij versie 2026.1 -->
		<!-- 20250120: validatie van deze business rule toegevoegd  -->
		<!--<xsl:if test="($typeDocument='overdrachtbinnenbrin') and (od:banknummer)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Voor een verzorger is een banknummer in overdracht-binnen-brin verboden.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>-->
		
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template name="melding">
		<xsl:param name="tekst"/>

		<melding>
			<type>Fout</type>
			<locatie>
				<xsl:call-template name="xpath">
					<xsl:with-param name="postfix"/>
				</xsl:call-template>
			</locatie>
			<tekst>
				<xsl:value-of select="$tekst"/>
			</tekst>
		</melding>
	</xsl:template>

	<xsl:template name="xpath">
		<xsl:param name="postfix"/>

		<xsl:variable name="local" select="local-name()"/>
		<xsl:variable name="name" select="concat('/', $local, '[', count(preceding-sibling::*[local-name()=$local])+1, ']', $postfix)"/>
		<xsl:choose>
			<xsl:when test="not(parent::*)">
				<xsl:value-of select="$name"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:for-each select="parent::*">
					<xsl:call-template name="xpath">
						<xsl:with-param name="postfix" select="$name"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
