<?xml version="1.0" encoding="UTF-8"?>
<!--Overzicht van wijzigingen in afgelopen jaren -->
<!-- 20251217:  Release van Validatie van Gegevensset versie "2026.1.1" voor afspraak versie "2026.1", inclusief wijzigingen: 
	            Versienummer van de namespace aangepast naar "2026" (i.p.v. "2025") en Validatie van veld standaardversie aangepast naar "2026.1",
	            Validatie van codelijst 2 m.b.t. Advies vo aangepast: alle codes met LWOO (21, 23, 31, 35 en 43) verwijderd,
				Validatie van codelijst 11 m.b.t. Code referentiescore aangepast: code CPercentiel toegevoegd.-->
<!-- 20250623:  Validatie van vullingsregel bij telefoonnummer gecorrigeerd: nu niet minder dan 10 tekens toegestaan conform documentatie -->
<!-- 20250526:  Validatie van vullingsregel bij e-mail en telefoonnummer van contactpersoon aangepast: nu geen foutmelding als velden <contactemail> en/of <contacttelefoon> ontbreken -->
<!-- 20250214:  Validatie van vullingsregel bij telefoonnummer aangepast: nu ook haakjes en plusteken toegestaan -->
<!-- 20250106:  Release van Validatie van Gegevensset versie "2025.1.1" voor afspraak versie "2025.1", inclusief wijzigingen: 
	            Versienummer van de namespace aangepast naar "2025" (i.p.v. "2024") en Validatie van veld standaardversie aangepast naar "2025.1",
	            Validatie van vullingsregel bij e-mailadressen gewijzigd in reguliere expressie zodat ook diakritische tekens in deel voor @ worden toegestaan,
			    Validatie van e-mailadres van school en van contactpersoon bij het overstapadvies toegevoegd,
			    Validatie van vullingsregel bij telefoonnummer toegevoegd (20 tekens, alleen cijfers, spaties en mintekens; geen plusteken),
			    Validatie van telefoonnummer voor school en contactpersoon bij het overstapadvies toegevoegd.     -->
<!-- 20240117:  Validatie van codes in codelijst 2 niet corresponderend met DUO waardelijst AdviesVO (32, 33, 40, 41, 50, 51 en 52) verwijderd. -->
<!-- 20231220:	Release van Validatie van OSO Gegevensset versie "2024.1.1" voor afspraak versie "2024.1", inclusief wijzigingen: 
				Validatie van regel bij veld standaardversie aangepast,
			    Validaties van regel bij veld cat_eindtoetsbo vervangen door regel bij veld cat_doorstroomtoets,
			    Validaties van regel bij eindtoets_basisonderwijs vervangen door regel bij doorstroomtoets,
			    Validatie van regel bij eindtoetsresultaat vervangen door regel bij toetsresultaat,
			    Validatie van waarde van velden voorlopig_schooladvies en definitief_schooladvies toegevoegd en van velden advies en herzienadvies verwijderd, 
			    Validatie van cijferige codes uit codelijsten 42, 45, 46 en 47 (t.b.v. eindtoets) verwijderd, 
			    Regels die langer dan 5 jaren geleden zijn uitgesloten door er commentaar van te maken, zijn uit dit bestand verwijderd. -->
<!-- 20230704:	Update van validatie van OSO Gegevensset versie "2022.1.1" voor afspraak versie "2022.1", met wijzigingen:
	            Validatie van codelijsten 42 (Soort eindtoets/doorstroomtoets), 45 (referentieniveaus), 46 (onderdeelcode) en 47 (domeincode) uitgebreid met waarden t.b.v. Doorstroomtoets 
                Validatie van codelijst 49 (Opleidingskenmerken) uitgebreid met nieuwe waarden conform DUO PvE -->
<!-- 20210901:	Release van Validatie van Gegevensset versie "2022.1.1" voor afspraak versie "2022.1", inclusief wijzigingen: 
                20211201: Validatie van codelijst `15, 35 en 36 verwijderd omdat bijbehorende velden zijn vewijderd -->
<!-- 20210901:	Release van Validatie van OSO Gegevensset versie 2019.1.2, inclusief wijzigingen: 
                Validatie van codelijst 9 aangepast (codes 16 en 17 toegevoegd) en van codelijst 11 aangepast (3 codes tbv EMT/Klepel toegevoegd) -->
<!-- 20190311: regels van categorie onderwijsondersteuning gecorrigeerd naar validatie van aanwezigheid van de deelelementen van het blok onderwijsondersteuning 
	           (en correctie business rules nummering t.b.v. documentatie) -->
<!-- 20190101: Eerste comcept release voor Validatie van OSO Gegevensset versie 2019.1, inclusief de wijzigingen:
				Validatie van veld <standaardversie> gewijzigd
			    Validatie van veld cat_zorgenbegeleiding vervangen door veld cat_onderwijsondersteuning
				Validatie van codelijsten 3, 12, 32, 34 en 38 verwijderd m.b.t. verwijderde gegevensvelden  
				Validatie van codelijst 23 m.b.t. diagnose aangepast: nieuwe code voor F79.VB, F79.ZB, HB, F80, F81.9 en F43.2 toegevoegd 
				Validatie van codelijsten 42 (Toetssoort) en 43 (Toetsniveau) m.b.t. eindtoets aangepast 
                Validaties van aanwezigheid van categorie en velden/blokken van categorie uitgebreid: melding nu ook bij verboden categorieen -->
<!-- 20180704: Validatie van codelijst 9 (VVE programma) uitgebreid met waarden "7" t/m "15". -->
<!-- 20180322: Validatie van codelijst 43 (niveau eindtoets) uitgebreid met waarde "G". -->
<!-- 20180226: Correctie van validatie van BR OG.04 bij veld <overlijdensdatum> -->
<!-- 20180115: Validatie van BR OG.04 bij veld <overlijdensdatum> toegevoegd -->
<!-- 20180102: Eerste comcept release voor Validatie van OSO Gegevensset versie 2018.1, inclusief wijzigingen:
				Validatie van veld <standaardversie> gewijzigd
				Validatie van codelijsten aangepast: codelijsten 43 (Niveau eindtoets) -->
<!-- 20170308: Eerste officiele release voor Validatie van OSO Gegevensset versie 2017.1, inclusief wijzigingen:
				Validatie toegevoegd dat bij selectief uitleveren in het geval van OPT-UIT ook werkelijk alle gegevens uit deze categorie ontbreken 
				Validatie van codelijsten aangepast: codelijsten 16 (soort overstap/dossier), 29 (soort overdracht)
				Validatie van codelijst 48 toegevoegd (voor alle velden binnen blok categorie_uitlevering) -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs" xmlns:od="http://www.edustandaard.nl/oso_gegevensset/2026/dossier" 
	xmlns="http://www.edustandaard.nl/oso_gegevensset/2026/schemas/Meldingen" version="2.0" extension-element-prefixes="od">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>

	<xsl:template name="gegevensset" match="/">
		<meldingen>
			<!-- ______________________________________________________________ -->
			<!--             Validatie van codelijsten in Gegevensset           -->
			<!-- ______________________________________________________________ -->
			
			<!-- 20140509: CONTROLE VAN CODELIJSTEN 
				2. Advies vo, 
				3. LGF onderwijssoort, 
				4. Communicatie soort, 5. Communicatie aanduiding, 
				6. Voorschoolse toeleider, 7. Voorschoolse historie, 8. Voorschoolse deelname, 9. VVE programma
				10. NNCA, 11. Referentiescore, 12. Domeinen, 13. Jaargroepen, 14. Geslacht, 15. Gewicht,
				16. Soort overstap, 
				17. RVC indicattie,
				18. Huisnummer aanduiding, 19. Soort adres, 
				21. Profiel, 22. Vergelijkingsgroep, 23. Diagnose, 
				29. Overdrachtsoort, 
				31. TLV, 32. UPW en 33. Deeldossiertype 
				34. UPW leerjaar, 35. Examenuitslag, 36. Beoordelingexamenvak, 37. Akkoord, 38. LGF indicatie voor REC
				[39. Soort arrangement,] [40. Niveau eindtoets,] 41. Relatie tot kind
				42 t/m 47 m.b.t. doorstroomtoets (voorheen eindtoets basisonderwijs)
				48 Categorie uitlevering
			-->

			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van velden m.b.t. VO advies (school, ouders, leerling & herzien) conform codelijst 2. Advies VO -->
			<!-- 20251217: validatie van codes met LWOO (21, 23, 31, 35 en 43) verwijderd (4x) -->
			<!-- 20240117: validatie van codes niet corresponderend met DUO waardelijst AdviesVO (32, 33, 40, 41,50, 51 en 52) verwijderd (4x) -->
			<!-- 20231220: validatie van velden voorlopig_schooladvies en definitief_schooladvies toegevoegd en van velden advies en herzienadvies verwijderd -->
			<xsl:for-each select="/descendant::*/od:overstapadvies/od:voorlopig_schooladvies">
				<xsl:if test="not(text()='01') and not(text()='10') and
					not(text()='20') and not(text()='22') and
					not(text()='30') and not(text()='34') and
					not(text()='42') and not(text()='44') and 
					not(text()='60') and not(text()='61') and not(text()='70') and not(text()='80')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Voorlopig schooladvies' bevat een waarde die niet voorkomt in in codelijst 2.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="/descendant::*/od:overstapadvies/od:definitief_schooladvies">
				<xsl:if test="not(text()='01') and not(text()='10') and
					not(text()='20') and not(text()='22') and
					not(text()='30') and not(text()='34') and
					not(text()='42') and not(text()='44') and 
					not(text()='60') and not(text()='61') and not(text()='70') and not(text()='80')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Definitief schooladvies' bevat een waarde die niet voorkomt in in codelijst 2.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="/descendant::*/od:overstapadvies/od:wensouders">
				<xsl:if test="not(text()='01') and not(text()='10') and
					not(text()='20') and not(text()='22') and
					not(text()='30') and not(text()='34') and
					not(text()='42') and not(text()='44') and 
					not(text()='60') and not(text()='61') and not(text()='70') and not(text()='80')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'VO advies volgens ouders' bevat een waarde die niet voorkomt in in codelijst 2.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="/descendant::*/od:overstapadvies/od:wensleerling">
				<xsl:if test="not(text()='01') and not(text()='10') and
					not(text()='20') and not(text()='22') and
					not(text()='30') and not(text()='34') and
					not(text()='42') and not(text()='44') and 
					not(text()='60') and not(text()='61') and not(text()='70') and not(text()='80')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'VO advies volgens leerling' bevat een waarde die niet voorkomt in in codelijst 2.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld codelgfonderwijssoort conform codelijst 3. LGF onderwijssoort -->
			<!-- 20190101: validatie van deze codelijst verwijderd omdat veld is vewijderd -->
			<!--<xsl:for-each select="/descendant::*/od:lgf/od:codelgfonderwijssoort">
				<xsl:if test="not(text()='11') and not(text()='12') and not(text()='13') and not(text()='14') and
					not(text()='21') and not(text()='22') and not(text()='23') and not(text()='24') and not(text()='25') and not(text()='26') and
					not(text()='31') and not(text()='32') and not(text()='33') and not(text()='34') and not(text()='35') and
					not(text()='40') and not(text()='44')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'LGF onderwijssoort' bevat een waarde die niet voorkomt in in codelijst 3.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>-->

			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld communicatie.soort conform codelijst 4. Communicatie soort -->
			<!-- 20160120: validatie van de waarden "mobiel" en "fax" verwijderd -->
			<xsl:for-each select="/descendant::*/od:communicatie/od:soort">
				<xsl:if test="not(text()='e-mail') and not(text()='telefoon')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Communicatie soort' bevat een waarde die niet voorkomt in codelijst 4.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld communicatie.aanduiding conform codelijst 5. Communicatie aanduiding -->
			<xsl:for-each select="/descendant::*/od:communicatie/od:aanduiding">
				<xsl:if test="not(text()='werk') and not(text()='prive') and not(text()='overig')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Communicatie aanduiding' bevat een waarde die niet voorkomt in codelijst 5.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld codevoorschoolsetoeleider conform codelijst 6. Voorschoolse toeleider -->
			<xsl:for-each select="/descendant::*/od:voorschools/od:codevoorschoolsetoeleider">
				<xsl:if test="not(text()='1') and not(text()='2') and not(text()='3') and not(text()='4') and not(text()='5') and not(text()='6') and not(text()='7') and not(text()='8') and not(text()='9')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Voorschoolse toeleider' bevat een waarde die niet voorkomt in codelijst 6.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld codevoorschoolsehistorie conform codelijst 7. Voorschoolse historie -->
			<xsl:for-each select="/descendant::*/od:voorschools/od:codevoorschoolsehistorie">
				<xsl:if test="not(text()='1') and not(text()='2') and not(text()='3') and not(text()='4') and not(text()='5')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Voorschoolse historie' bevat een waarde die niet voorkomt in codelijst 7.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld codevoorschoolsedeelname conform codelijst 8. Voorschoolse deelname -->
			<xsl:for-each select="/descendant::*/od:voorschools/od:codevoorschoolsedeelname">
				<xsl:if test="not(text()='1') and not(text()='2') and not(text()='3') and not(text()='4') and not(text()='5')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Voorschoolse deelname' bevat een waarde die niet voorkomt in codelijst 8.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>

			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld codevoorschoolsprogramma conform codelijst 9. VVE programma -->
			<!-- 20210901 Validatie van codes "16" en "17" toegevoegd -->
			<!-- 20180704 Validatie van codes "7" t/m "15" toegevoegd -->
			<xsl:for-each select="/descendant::*/od:voorschools/od:codevoorschoolsprogramma">
				<xsl:if test="not(text()='1') and not(text()='2') and not(text()='3') and not(text()='4') and not(text()='5') and not(text()='6')
					and not(text()='7') and not(text()='8') and not(text()='9') and not(text()='10') 
					and not(text()='11') and not(text()='12') and not(text()='13') and not(text()='14') and not(text()='15') and not(text()='16') and not(text()='17')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Voorschoolse programma' bevat een waarde die niet voorkomt in codelijst 9.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="/descendant::*/od:vroegschools/od:codevroegschoolsprogramma">
				<xsl:if test="not(text()='1') and not(text()='2') and not(text()='3') and not(text()='4') and not(text()='5') and not(text()='6')
					and not(text()='7') and not(text()='8') and not(text()='9') and not(text()='10') 
					and not(text()='11') and not(text()='12') and not(text()='13') and not(text()='14') and not(text()='15') and not(text()='16') and not(text()='17')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Vroegschoolse programma' bevat een waarde die niet voorkomt in codelijst 9.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld nnca conform codelijst 10. NNCA -->
			<xsl:for-each select="/descendant::*/od:nnca">
				<xsl:if test="not(text()='0') and not(text()='1') and not(text()='2')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'NNCA' bevat een waarde die niet voorkomt in codelijst 10.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>

			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld codereferentiescore conform codelijst 11. Referentiescore-->
			<!-- 20251217 Validatie van code CPercentiel toegevoegd -->
			<!-- 20210901 Validatie van codes Indexscore, Discrepantiescore en Kwalificatie-GGZ toegevoegd -->
			<!-- 20150716 Validatie van code NAZ toegevoegd -->
			<!-- 20150529 Validatie van code LA toegevoegd -->
			<xsl:for-each select="/descendant::*/od:referentiescore/od:codereferentiescore">
				<xsl:if test="not(text()='AE') and not(text()='CAE') and not(text()='IV') and not(text()='CIV') and not(text()='FN') and not(text()='ON') and
					not(text()='DLE') and not(text()='Percentiel') and not(text()='CPercentiel') and not(text()='Percentage') and not(text()='T-score') and not(text()='Stanine') and
					not(text()='DQ') and not(text()='IQ') and not(text()='ERK') and not(text()='C-score') and not(text()='Norm') and not(text()='RNTRM') and 
					not(text()='ZML')and not(text()='LGH') and not(text()='AVI') and not(text()='NAZ') and not(text()='LM') and not(text()='Standaardscore') and not(text()='LA') and 
					not(text()='Indexscore')and not(text()='Discrepantiescore') and not(text()='Kwalificatie-GGZ') ">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Code van referentiescore' bevat een waarde die niet voorkomt in codelijst 11.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld domein conform codelijst 12. Domeinen -->
			<!-- 20190101: validatie van deze codelijst verwijderd omdat veld is vewijderd -->
			<!--<xsl:for-each select="/descendant::*/od:extrahulpingroep78/od:domein">
				<xsl:if test="not(text()='TL') and not(text()='BL') and not(text()='SP') and not(text()='RW') and 
					not(text()='ST') and not(text()='MT') and 
					not(text()='BO') and not(text()='SV') and 
					not(text()='WO') and not(text()='EN') and not(text()='CV') and 
					not(text()='LCC') and not(text()='LNK') and not(text()='LZS') and not(text()='LTP')and not(text()='LZV') and not(text()='LDV') and not(text()='LWV') and not(text()='LHW')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Hulpdomeinen' bevat een waarde die niet voorkomt in codelijst 12.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>-->
			
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld jaargroep (4x binnen schoolloopbaan, toetsresultaat en cijferlijst) conform codelijst 13. Jaargroepen-->
			<xsl:for-each select="/descendant::*/od:jaargroep">
				<xsl:if test="not(text()='0') and 
					not(text()='1') and not(text()='2') and not(text()='3') and not(text()='4') and not(text()='5') and not(text()='6') and not(text()='7') and not(text()='8') and 
					not(text()='11') and not(text()='12') and not(text()='13') and not(text()='14') and not(text()='15') and not(text()='16') and 
					not(text()='S') and not(text()='P')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Leerjaar' bevat een waarde die niet voorkomt in codelijst 13.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld geslacht conform codelijst 14. Geslacht -->
			<xsl:for-each select="/descendant::*/od:geslacht">
				<xsl:if test="not(text()='0') and not(text()='1') and not(text()='2')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Geslacht' bevat een waarde die niet voorkomt in codelijst 14.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld leerlinggewicht conform codelijst 15. Gewicht -->
			<!-- 20211201: Validatie van codelijst 15 verwijderd omdat het bijbehorende veld is vewijderd -->
			<!--<xsl:for-each select="/descendant::*/od:leerlinggewicht">
				<xsl:if test="not(text()='0.00') and not(text()='0.30') and not(text()='1.20')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Leerlinggewicht' bevat een waarde die niet voorkomt in codelijst 15.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>-->
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld dossier.metadata.overstap conform codelijst 16. Soort overstap/dossier -->
			<!-- 20170308: Validatie uitgebreid met codes "POSWV" en "VOSWV" -->
			<xsl:for-each select="/descendant::*/od:metadata/od:overstap">
				<xsl:if test="not(text()='VSPO') and not(text()='VSWEC') and not(text()='POPO') and not(text()='POWEC') and
					not(text()='POVO') and not(text()='VOVO') and not(text()='VOMBO') and not(text()='VOHBO') and
					not(text()='VOWO') and not(text()='WECWEC') and not(text()='WECVO') and not(text()='WECMBO') and
					not(text()='POSWV') and not(text()='VOSWV') and
					not(text()='WECHBO') and not(text()='WECWO') and not(text()='OVERIG')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Soort overstap' bevat een waarde die niet voorkomt in codelijst 16.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>

			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld RVC indicatie conform codelijst 17. RVC indicatie -->
			<xsl:for-each select="/descendant::*/od:rvc/od:rvcindicatie">
				<xsl:if test="not(text()='LWOO') and not(text()='PRO')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'RVC indicatie' bevat een waarde die niet voorkomt in codelijst 17.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld soortadres conform codelijst 18. Huisnummer aanduiding -->
			<xsl:for-each select="/descendant::*/od:adres/od:aanduiding">
				<xsl:if test="not(text()='TO') and not(text()='BY')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Huisnummer aanduiding' bevat een waarde die niet voorkomt in codelijst 18.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarden conform codelijst -->
			<!-- Is de waarde van veld soortadres conform codelijst 19. Soort adres -->
			<!-- 20250106: validatie van waarde van "Soort adres" binnen "Buitenlandadres" toegevoegd -->
			<xsl:for-each select="/descendant::*/od:adres/od:soortadres">
				<xsl:if test="not(text()='bezoek') and not(text()='post') and not(text()='gba')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Soort adres' bevat een waarde die niet voorkomt in codelijst 19.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="/descendant::*/od:buitenlandadres/od:soortadres">
				<xsl:if test="not(text()='bezoek') and not(text()='post') and not(text()='gba')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Soort adres' binnen 'Buitenlands adres' bevat een waarde die niet voorkomt in codelijst 19.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld profiel conform codelijst 21. Profiel -->
			<!-- 20150218: validatie van waarde van gegevensveld "profiel" met codelijst 21 code "ondersteuning" toegevoegd -->
			<xsl:for-each select="/descendant::*/od:overstapadvies/od:profiel">
				<xsl:if test="not(text()='basis') and not(text()='plus') and not(text()='bespreek') and not(text()='disharmonisch') and not(text()='ondersteuning')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Profiel' binnen overstapadvies bevat een waarde die niet voorkomt in codelijst 21.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld codevergelijkingsgroep conform codelijst 22. Vergelijkingsgroep -->
			<xsl:for-each select="/descendant::*/od:referentiescore/od:codevergelijkingsgroep">
				<xsl:if test="not(text()='BB+') and not(text()='BB') and not(text()='KB') and not(text()='GT') and 
					not(text()='HAVO') and not(text()='VWO') and not(text()='Landelijk')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Code van vergelijkingsgroep' bevat een waarde die niet voorkomt in codelijst 22.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld diagnose.code conform codelijst 23. Diagnose codes -->
			<!-- 20190101: validatie van de nieuwe waarden F79.VB, F79.ZB, HB, F80, F81.9 en F43.2 t.b.v. 2019.1 toegevoegd -->
			<!-- 20160120: validatie van de waarden "H54.0" tot en met "H91.9.s" toegevoegd -->
			<xsl:for-each select="/descendant::*/od:diagnose/od:code">
				<xsl:if test="
					not(text()='F79.VB') and not(text()='F79.ZB') and not(text()='HB') and not(text()='F80') and 
					not(text()='F81.0') and not(text()='F81.1') and not(text()='F81.2') and not(text()='F81.9') and not(text()='F82') and 
					not(text()='F84') and not(text()='F84.0') and not(text()='F84.2') and not(text()='F84.5') and not(text()='F84.nld') and not(text()='F84.mcdd') and 
					not(text()='F90') and not(text()='F90.0') and not(text()='F90.0+') and not(text()='F90.0-') and not(text()='F91') and not(text()='F91.3') and 
					not(text()='F95') and not(text()='F95.2') and
					not(text()='F41.0') and not(text()='F43.1') and not(text()='F43.2') and not(text()='F50') and 
					not(text()='F92.0') and not(text()='F93.1') and not(text()='F94') and 
					not(text()='Fspd') and not(text()='G40') and 
					not(text()='H54.0') and not(text()='H54.2') and not(text()='H91.9.d') and not(text()='H91.9.s') and 
					not(text()='Z62')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Code van diagnose' bevat een waarde die niet voorkomt in codelijst 23.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld overdrachtsoort conform codelijst 29. Overdrachtsoort -->
			<!-- 20170308: Validatie uitgebreid met code "swv-dossier" -->
			<xsl:for-each select="/descendant::*/od:overdrachtsoort">
				<xsl:if test="not(text()='overstapdossier') and not(text()='overdrachtbinnenbrin') and not(text()='swv-dossier')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Soort overdracht' bevat een waarde die niet voorkomt in codelijst 29.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld tlvcategorie conform codelijst 31. TLV bekostigingscategorie -->
			<!-- 20150716 Validatie van code Nvt toegevoegd -->
			<xsl:for-each select="/descendant::*/od:tlv/od:tlvcategorie">
				<xsl:if test="not(text()='H') and not(text()='M') and not(text()='L') and not(text()='Nvt')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'TLV bekostigingscategorie' bevat een waarde die niet voorkomt in codelijst 31.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld upwuitstroomprofiel conform codelijst 32. UPW uitstroomprofiel -->
			<!-- 20190101: validatie van deze codelijst verwijderd omdat veld is vewijderd -->
			<!--<xsl:for-each select="/descendant::*/od:upw/od:upwuitstroomprofiel">
				<xsl:if test="not(text()='1') and not(text()='2') and not(text()='3')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'UPW uitstroomprofiel' bevat een waarde die niet voorkomt in codelijst 32.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>-->
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld metadata.deeldossier conform 33. Deeldossier type -->
			<!--<xsl:for-each select="/descendant::*/od:metadata/od:deeldossier">
				<xsl:if test="not(text()='LAS') and not(text()='LVS') and not(text()='LASLVS') and not(text()='TIB')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Deeldossier type' binnen metadata bevat een waarde die niet voorkomt in codelijst 33.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>-->
			<xsl:if test="not(//od:metadata/od:deeldossier/text()='LAS') and not(//od:metadata/od:deeldossier/text()='LVS') and not(//od:metadata/od:deeldossier/text()='LASLVS') and not(//od:metadata/od:deeldossier/text()='TIB')">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Het veld 'Deeldossier type' binnen metadata bevat een waarde die niet voorkomt in codelijst 33.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld upwleerjaar conform codelijst 34. UPW leerjaar -->
			<!-- 20190101: validatie van deze codelijst verwijderd omdat veld is vewijderd -->
			<!--<xsl:for-each select="/descendant::*/od:upw/od:upwleerjaar">
				<xsl:if test="not(text()='1') and not(text()='2') and not(text()='3') and not(text()='4') and not(text()='5') and not(text()='6')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'UPW leerjaar' bevat een waarde die niet voorkomt in codelijst 34.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>-->
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld examenuitslag conform codelijst 35. Examenuitslag -->
			<!-- 20211201: Validatie van codelijst 35 verwijderd omdat het bijbehorende veld is vewijderd -->
			<!--<xsl:for-each select="/descendant::*/od:examenresultaat/od:examenuitslag">
				<xsl:if test="not(text()='geslaagd') and not(text()='afgewezen') and not(text()='herexamen')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Examenuitslag' bevat een waarde die niet voorkomt in codelijst 35.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>-->
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld beoordelingexamenvak conform codelijst 36. Beoordelingexamenvak -->
			<!-- 20211201: Validatie van codelijst 36 verwijderd omdat het bijbehorende veld is vewijderd -->
			<!--<xsl:for-each select="/descendant::*/od:resultaatvakkenvo/od:beoordelingexamenvak">
				<xsl:if test="not(text()='voldoende') and not(text()='onvoldoende')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Beoordeling van examenvak' bevat een waarde die niet voorkomt in codelijst 36.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>-->
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld akkoord conform codelijst 37. Akkoord -->
			<xsl:for-each select="/descendant::*/od:inzage/od:akkoord">
				<xsl:if test="not(text()='Ja') and not(text()='Nee') and not(text()='Onbekend')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Akkoord' bevat een waarde die niet voorkomt in codelijst 37.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="/descendant::*/od:inzage/od:toestemming">
				<xsl:if test="not(text()='Ja') and not(text()='Nee') and not(text()='Onbekend')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Toestemming' bevat een waarde die niet voorkomt in codelijst 37.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld lgfindicatierec conform codelijst 38. LGF indicatie voor REC -->
			<!-- 20190101: validatie van deze codelijst verwijderd omdat veld is vewijderd -->
			<!--<xsl:for-each select="/descendant::*/od:lgf/od:lgfindicatierec">
				<xsl:if test="not(text()='1') and not(text()='2') and not(text()='3') and not(text()='4')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'LGF indicatie voor REC' bevat een waarde die niet voorkomt in codelijst 38.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>-->
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld relatietotkind conform codelijst 41. Relatie tot kind -->
			<!-- 20160120: Validatie van deze codelijst toegevoegd -->
			<xsl:for-each select="/descendant::*/od:verzorger/od:relatietotkind">
				<xsl:if test="not(text()='1') and not(text()='2') and not(text()='3') and not(text()='4') and not(text()='5') and 
					not(text()='6') and not(text()='7') and not(text()='8') and not(text()='9')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Relatie tot kind' binnen het blok 'Verzorger' bevat een waarde die niet voorkomt in codelijst 41.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>

			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld <toetssoort> binnen <doorstroomtoets> conform codelijst 42. Soort doorstroomtoets -->
			<!-- 20231220: Waarde "CALAMITEITENTOETS" gewijzigd in "OCW_DOORSTROOMTOETS" (bugfix)
				          validatie van codes "0011" t/m "0016" verwijderd
				          <eindtoetsresultaat> gewijzigd in <toetsresultaat> en <eindtoets_basisonderwijs> gewijzigd in <doorstroomtoets>, inclusief gewijzigde foutmelding -->
			<!-- 20230704: Validatie van 7 tekstuele waarden t.b.v. Doorstroomtoets toegevoegd -->
			<!-- 20190101: Validatie van code 0015 (CESAN) verwijderd -->
			<!-- 20161128: Validatie van deze codelijst toegevoegd -->
			<xsl:for-each select="/descendant::*/od:doorstroomtoets/od:toetsresultaat/od:toetssoort">
				<xsl:if test="not(text()='ROUTE_8') and not(text()='ICE') and not(text()='DIA') and not(text()='AMN') and not(text()='LEERLING_IN_BEELD') and not(text()='DOE') and not(text()='OCW_DOORSTROOMTOETS') ">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Toetssoort' binnen het blok 'Doorstroomtoets' bevat een waarde die niet voorkomt in codelijst 42.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld <wettelijke_ontheffing> binnen <doorstroomtoets> conform codelijst 44. Wettelijke ontheffing doorstroomtoets -->
			<!-- 20231220: <eindtoetsresultaat> gewijzigd in <toetsresultaat> en <eindtoets_basisonderwijs> gewijzigd in <doorstroomtoets>, inclusief gewijzigde foutmelding -->
			<!-- 20161128: Validatie van deze codelijst toegevoegd -->
			<xsl:for-each select="/descendant::*/od:doorstroomtoets/od:toetsresultaat/od:wettelijke_ontheffing">
				<xsl:if test="not(text()='J') and not(text()='N') ">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Wettelijke ontheffing' binnen het blok 'Doorstroomtoets' bevat een waarde die niet voorkomt in codelijst 44.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld <ond_referentieniveau> en <dom_referentieniveau> binnen <doorstroomtoets> conform codelijst 45. Doorstroomtoets referentieniveau -->
			<!-- 20231220: validatie van codes "01" t/m "04" verwijderd (2x)
				           <eindtoetsresultaat> gewijzigd in <toetsresultaat> en <eindtoets_basisonderwijs> gewijzigd in <doorstroomtoets>, inclusief gewijzigde foutmeldingen -->
			<!-- 20230704: Validatie van 4 tekstuele waarden t.b.v. Doorstroomtoets toegevoegd -->
			<!-- 20161128: Validatie van deze codelijst toegevoegd -->
			<xsl:for-each select="/descendant::*/od:doorstroomtoets/od:toetsresultaat/od:onderdelen/od:onderdeel/od:ond_referentieniveau">
				<xsl:if test="not(text()='L1F') and not(text()='1F') and not(text()='1S') and not(text()='2F') ">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Onderdeel referentiescore' binnen het blok 'Doorstroomtoets' bevat een waarde die niet voorkomt in codelijst 45.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="/descendant::*/od:doorstroomtoets/od:toetsresultaat/od:onderdelen/od:onderdeel/od:domeinen/od:domein/od:dom_referentieniveau">
				<xsl:if test="not(text()='L1F') and not(text()='1F') and not(text()='1S') and not(text()='2F') ">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Domein referentiescore' binnen het blok 'Doorstroomtoets' bevat een waarde die niet voorkomt in codelijst 45.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld <onderdeelcode> binnen <doorstroomtoets> conform codelijst 46. Doorstroomtoets cnderdeelcode -->
			<!-- 20231220 validatie van codes "8000" en "8001" verwijderd
				          <eindtoetsresultaat> gewijzigd in <toetsresultaat> en <eindtoets_basisonderwijs> gewijzigd in <doorstroomtoets>, inclusief gewijzigde foutmelding -->
			<!-- 20230704: Validatie van 2 tekstuele waarden t.b.v. Doorstroomtoets toegevoegd -->
			<!-- 20161128: Validatie van deze codelijst toegevoegd -->
			<xsl:for-each select="/descendant::*/od:doorstroomtoets/od:toetsresultaat/od:onderdelen/od:onderdeel/od:onderdeelcode">
				<xsl:if test="not(text()='NEDERLANDSE_TAAL') and not(text()='REKENEN') ">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Onderdeelcode' binnen het blok 'Doorstroomtoets' bevat een waarde die niet voorkomt in codelijst 46.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld <domeincode> binnen <doorstroomtoets> conform codelijst 47. Doorstroomtoets domeincode -->
			<!-- 20231220 validatie van codes "8050" en "8051" verwijderd
				          <eindtoetsresultaat> gewijzigd in <toetsresultaat> en <eindtoets_basisonderwijs> gewijzigd in <doorstroomtoets>, inclusief gewijzigde foutmelding -->
			<!-- 20230704: Validatie van 2 tekstuele waarden t.b.v. Doorstroomtoets toegevoegd -->
			<!-- 20161128: Validatie van deze codelijst toegevoegd -->
			<xsl:for-each select="/descendant::*/od:doorstroomtoets/od:toetsresultaat/od:onderdelen/od:onderdeel/od:domeinen/od:domein/od:domeincode">
				<xsl:if test="not(text()='LEZEN') and not(text()='TAALVERZORGING') ">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Domeincode' binnen het blok 'Doorstroomtoets' bevat een waarde die niet voorkomt in codelijst 47.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van velden binnen <categorie_uitlevering> conform codelijst 48. Categorie uitlevering -->
			<!-- 20211201 validatie van codelijst 48 voor veld cat_vombo verwijderd -->
			<!-- 20190101 naam betrokken veld gewijzigd in cat_onderwijsondersteuning (voorheen cat_zorgenbegeleiding) -->
			<!-- 20170308: Validatie van deze codelijst toegevoegd voor alle betreffende velden in blok "categorie uitlevering" -->
			<xsl:for-each select="//od:metadata/od:categorie_uitlevering/od:cat_metadata">
				<xsl:if test="not(text()='VERPLICHT') and not(text()='OPTIONEEL')  and not(text()='VERBODEN') and not(text()='OPT-UIT')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Categorie Metadata' (cat_metadata) binnen metadata bevat een waarde die niet voorkomt in codelijst 48.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="//od:metadata/od:categorie_uitlevering/od:cat_ouderinzage">
				<xsl:if test="not(text()='VERPLICHT') and not(text()='OPTIONEEL')  and not(text()='VERBODEN') and not(text()='OPT-UIT')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Categorie Ouderinzage' (cat_ouderinzage) binnen metadata bevat een waarde die niet voorkomt in codelijst 48.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="//od:metadata/od:categorie_uitlevering/od:cat_school">
				<xsl:if test="not(text()='VERPLICHT') and not(text()='OPTIONEEL')  and not(text()='VERBODEN') and not(text()='OPT-UIT')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Categorie School' (cat_school) binnen metadata bevat een waarde die niet voorkomt in codelijst 48.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="//od:metadata/od:categorie_uitlevering/od:cat_leerling">
				<xsl:if test="not(text()='VERPLICHT') and not(text()='OPTIONEEL')  and not(text()='VERBODEN') and not(text()='OPT-UIT')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Categorie Leerling' (cat_leerling) binnen metadata bevat een waarde die niet voorkomt in codelijst 48.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="//od:metadata/od:categorie_uitlevering/od:cat_oudersverzorgers">
				<xsl:if test="not(text()='VERPLICHT') and not(text()='OPTIONEEL')  and not(text()='VERBODEN') and not(text()='OPT-UIT')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Categorie Ouders/Verzorgers' (cat_oudersverzorgers) binnen metadata bevat een waarde die niet voorkomt in codelijst 48.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="//od:metadata/od:categorie_uitlevering/od:cat_vve">
				<xsl:if test="not(text()='VERPLICHT') and not(text()='OPTIONEEL')  and not(text()='VERBODEN') and not(text()='OPT-UIT')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Categorie VVE' (cat_vve) binnen metadata bevat een waarde die niet voorkomt in codelijst 48.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="//od:metadata/od:categorie_uitlevering/od:cat_schoolloopbaan">
				<xsl:if test="not(text()='VERPLICHT') and not(text()='OPTIONEEL')  and not(text()='VERBODEN') and not(text()='OPT-UIT')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Categorie Schoolloopbaan' (cat_schoolloopbaan) binnen metadata bevat een waarde die niet voorkomt in codelijst 48.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="//od:metadata/od:categorie_uitlevering/od:cat_overstapadvies">
				<xsl:if test="not(text()='VERPLICHT') and not(text()='OPTIONEEL')  and not(text()='VERBODEN') and not(text()='OPT-UIT')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Categorie Overstapadvies' (cat_overstapadvies) binnen metadata bevat een waarde die niet voorkomt in codelijst 48.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="//od:metadata/od:categorie_uitlevering/od:cat_onderwijsondersteuning">
				<xsl:if test="not(text()='VERPLICHT') and not(text()='OPTIONEEL')  and not(text()='VERBODEN') and not(text()='OPT-UIT')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Categorie Onderwijsondersteuning' (cat_onderwijsondersteuning) binnen metadata bevat een waarde die niet voorkomt in codelijst 48.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="//od:metadata/od:categorie_uitlevering/od:cat_verzuim">
				<xsl:if test="not(text()='VERPLICHT') and not(text()='OPTIONEEL')  and not(text()='VERBODEN') and not(text()='OPT-UIT')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Categorie Verzuim' (cat_verzuim) binnen metadata bevat een waarde die niet voorkomt in codelijst 48.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			<!-- 20231220 cat_eindtoetsbo gewijzigd in cat_doorstroomtoets, inclusief gewijzigde foutmelding  -->
			<xsl:for-each select="//od:metadata/od:categorie_uitlevering/od:cat_doorstroomtoets">
				<xsl:if test="not(text()='VERPLICHT') and not(text()='OPTIONEEL')  and not(text()='VERBODEN') and not(text()='OPT-UIT')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Categorie Doorstroomtoets' (cat_doorstroomtoets) binnen metadata bevat een waarde die niet voorkomt in codelijst 48.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="//od:metadata/od:categorie_uitlevering/od:cat_toetsresultaten">
				<xsl:if test="not(text()='VERPLICHT') and not(text()='OPTIONEEL')  and not(text()='VERBODEN') and not(text()='OPT-UIT')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Categorie Toetsresultaten' (cat_toetsresultaten) binnen metadata bevat een waarde die niet voorkomt in codelijst 48.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="//od:metadata/od:categorie_uitlevering/od:cat_handelingsplannen">
				<xsl:if test="not(text()='VERPLICHT') and not(text()='OPTIONEEL')  and not(text()='VERBODEN') and not(text()='OPT-UIT')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Categorie Handelingsplannen' (cat_handelingsplannen) binnen metadata bevat een waarde die niet voorkomt in codelijst 48.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="//od:metadata/od:categorie_uitlevering/od:cat_cijferlijsten">
				<xsl:if test="not(text()='VERPLICHT') and not(text()='OPTIONEEL')  and not(text()='VERBODEN') and not(text()='OPT-UIT')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Categorie Cijferlijsten' (cat_cijferlijsten) binnen metadata bevat een waarde die niet voorkomt in codelijst 48.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			<!-- 20211201 Regel bij veld cat_vombo verwijderd -->
			<!--<xsl:for-each select="//od:metadata/od:categorie_uitlevering/od:cat_vombo">
				<xsl:if test="not(text()='VERPLICHT') and not(text()='OPTIONEEL')  and not(text()='VERBODEN') and not(text()='OPT-UIT')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Categorie VO-MBO' (cat_vombo) binnen metadata bevat een waarde die niet voorkomt in codelijst 48.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>-->
			<xsl:for-each select="//od:metadata/od:categorie_uitlevering/od:cat_bijlagedocs">
				<xsl:if test="not(text()='VERPLICHT') and not(text()='OPTIONEEL')  and not(text()='VERBODEN') and not(text()='OPT-UIT')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Categorie Bijlagedocumenten' (cat_bijlagedocs) binnen metadata bevat een waarde die niet voorkomt in codelijst 48.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>

			<!-- Afspraak OSO gegevensset: validatie van veldwaarde conform codelijst -->
			<!-- Is de waarde van veld <opleidingskenmerk> binnen <leerling> en <schoolloopbaan> conform codelijst 49. Opleidingskenmerken -->
			<!-- 20211201: Validatie van deze codelijst niet uitgewerkt conform afspraak 2022.1 -->



			<!-- ________________________________________________________________________________________ -->
			<!--             Validatie van veldwaarden en algemene condities in Gegevensset               -->
			<!-- ________________________________________________________________________________________ -->

			<!-- Afspraak OSO gegevensset, business rule OG.00A -->
			<!-- Controle van velden adres of buitenlandadres binnen adreslijst (geen lege lijst) -->
			<!-- 20250106: Validatie toegevoegd -->
			<xsl:for-each select="/descendant::*/od:adreslijst">
				<xsl:if test="(not(od:adres) and not(od:buitenlandadres))">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">In een lijst van adressen is minimaal 1 adres (binnenlands of buitenlands) verplicht.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>

			<!-- Afspraak OSO gegevensset, business rule OG.00B -->
			<!-- Controle van velden communicatie binnen communicatielijst (geen lege lijst) -->
			<!-- 20250106: Validatie toegevoegd -->
			<xsl:for-each select="/descendant::*/od:communicatielijst">
				<xsl:if test="(not(od:communicatie))">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">In een lijst van communicaties is minimaal 1 communicatie verplicht.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			<!-- Afspraak OSO gegevensset, business rule OG.01 -->
			<!-- Controle van veld "Nummer" binnen "Communicatie" (zie Tabel 1) -->
			
			<!-- E-mail format controle van veld "Nummer" binnen "Communicatie" : 
				Formaat AN  4…256 (karakterset afkomstig van basistype)met reguliere expressie
				Beschrijving controles: 
				- Het emailadres is minimaal 4 tekens en maximaal 256 tekens. 
				- Het emailadres moet 1 teken @ bevatten. 
				- Het deel voor de @ mag tot 64 tekens lang zijn. 
				- Er mogen cijfers,  letters en de volgende tekens in voorkomen: !#$%  *+=?^_`{|}~.-. 
				- De domeinnaam mag cijfers, letters, punten en minnen bevatten, maar mag niet met punt of min beginnen of eindigen. 
				- De extensie moet letters bevatten (let op, nu in reguliere expressie controle van DUO ook cijfers toegelaten).  
				Actuele reguliere expressie: "[\p{L}\p{N}!#$%*+=?^_`{|}~.-]+@[a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?(\.[a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?)*$'))"
			-->
			<!-- 20250106: Validatie van deze veldwaarde toegevoegd voor school en contactpersoon bij overstapadvies -->
			<!-- 20250106: Validatie van deze veldwaarde aangepast voor toestaan van diakritische tekens -->
			<!-- 20160120: Validatie van deze veldwaarde toegevoegd volgens reguliere expressie conform DUO: 
				            "[a-zA-Z0-9!#$%*+=?^_`{|}~.-]+@[a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?(\.[a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?)*$" -->
			<xsl:for-each select="/descendant::*/od:communicatie">
				<xsl:variable name="csoort" select="xs:string(od:soort)"/>
				<xsl:variable name="cadres" select="xs:string(od:nummer)"/>
				<xsl:if test="($csoort='e-mail') and (string-length($cadres) lt 4)">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Een e-mail adres is minimaal 4 tekens.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="($csoort='e-mail') and (string-length($cadres) gt 256)">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Een e-mail adres is niet langer dan 256 tekens.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="($csoort='e-mail') and not(contains($cadres,'@'))">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">In een e-mail adres is het @-teken verplicht.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
				<!-- 20250106: Validatie van voorwaarden van e-mail gewijzigd in begin van reguliere expressie om diakritische tekens toe te staan  -->
				<xsl:if test="($csoort='e-mail') and not(matches($cadres,'[\p{L}\p{N}!#$%*+=?^_`{|}~.-]+@[a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?(\.[a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?)*$'))">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Een e-mail adres moet voldoen aan de voorwaarden m.b.t. toegestane karakters voorgaand aan het @-teken en voor domeinnaam en extensie.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="//od:dossier/od:huidigeschool/od:communicatielijst/od:communicatie">
				<xsl:variable name="csoort" select="xs:string(od:soort)"/>
				<xsl:variable name="cadres" select="xs:string(od:nummer)"/>
				<xsl:if test="($csoort='e-mail') and (string-length($cadres) lt 4)">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het e-mail adres van de school is minimaal 4 tekens.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="($csoort='e-mail') and (string-length($cadres) gt 256)">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het e-mail adres van de school is niet langer dan 256 tekens.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="($csoort='e-mail') and not(contains($cadres,'@'))">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">In het e-mail adres van de school is het @-teken verplicht.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="($csoort='e-mail') and not(matches($cadres,'[\p{L}\p{N}!#$%*+=?^_`{|}~.-]+@[a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?(\.[a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?)*$'))">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het e-mail adres van de school moet voldoen aan de voorwaarden m.b.t. toegestane karakters voorgaand aan het @-teken en voor domeinnaam en extensie.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			<!-- 20250526:  Validatie van vullingsregel bij <contactemail> aangepast: nu geen foutmelding als veld <contactemail> ontbreekt -->
			<xsl:for-each select="/descendant::*/od:overstapadvies">
				<xsl:if test="(od:contactemail) ">
					<xsl:variable name="cadres" select="xs:string(od:contactemail)"/>
					<xsl:if test="(string-length($cadres) lt 4)">
						<xsl:call-template name="melding">
							<xsl:with-param name="tekst">Het e-mail adres van de contactpersoon bij het overstapadvies is minimaal 4 tekens.</xsl:with-param>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="(string-length($cadres) gt 256)">
						<xsl:call-template name="melding">
							<xsl:with-param name="tekst">Het e-mail adres van de contactpersoon bij het overstapadvies is niet langer dan 256 tekens.</xsl:with-param>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="not(contains($cadres,'@'))">
						<xsl:call-template name="melding">
							<xsl:with-param name="tekst">In het e-mail adres van de contactpersoon bij het overstapadvies is het @-teken verplicht.</xsl:with-param>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="not(matches($cadres,'[\p{L}\p{N}!#$%*+=?^_`{|}~.-]+@[a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?(\.[a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?)*$'))">
						<xsl:call-template name="melding">
							<xsl:with-param name="tekst">Het e-mail adres van de contactpersoon bij het overstapadvies moet voldoen aan de voorwaarden m.b.t. toegestane karakters voorgaand aan het @-teken en voor domeinnaam en extensie.</xsl:with-param>
						</xsl:call-template>
					</xsl:if>
				</xsl:if>
				
			</xsl:for-each>
			
			<!-- Telefoonnummer format controle van veld "Nummer" binnen "Communicatie": 
				Formaat AN  10…20 (karakterset afkomstig van basistype) met reguliere expressie
				Beschrijving controles: 
				- Het telefoonnummer moet minimaal 1 teken bevatten (vooralsnog geen strenge validatie van mnimaal 10 tekens).
				- Het telefoonnummer mag tot 20 tekens lang zijn. 
				- Er mogen alleen cijfers, spaties, haakjes, plustekens en mintekens/streepjes in voorkomen. 
				Actuele reguliere expressie: "^[0-9\s\-\+\(\)]{1,20}$" -->
			<!-- 20250214: Validatie van deze vullingsregel aangepast voor telefoonnummer validaties -->
			<!-- 20250106: Validatie van deze vullingsregel toegevoegd voor school en contactpersoon bij overstapadvies -->
			<!-- 20250106: Validatie van deze vullingsregel toegevoegd voor alle .../od:communicatie, inclusief voor school en contactpersoon bij school-->
			<xsl:for-each select="/descendant::*/od:communicatie">
				<xsl:variable name="csoort" select="xs:string(od:soort)"/>
				<xsl:variable name="cadres" select="xs:string(od:nummer)"/>
				<xsl:if test="($csoort='telefoon') and (string-length($cadres) lt 10)">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Een telefoonnummer is minimaal 10 tekens.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="($csoort='telefoon') and (string-length($cadres) gt 20)">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Een telefoonnummer is niet langer dan 20 tekens.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="($csoort='telefoon') and not(matches($cadres,'^[0-9\s\-\+\(\)]{1,20}$'))">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Een telefoonnummer moet voldoen aan de voorwaarden m.b.t. toegestane karakters: alleen cijfers, spaties, haakjes, plustekens en mintekens zijn toegestaan.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="//od:dossier/od:huidigeschool/od:communicatielijst/od:communicatie">
				<xsl:variable name="csoort" select="xs:string(od:soort)"/>
				<xsl:variable name="cadres" select="xs:string(od:nummer)"/>
				<xsl:if test="($csoort='telefoon') and (string-length($cadres) lt 10)">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het telefoonnummer van de school is minimaal 10 tekens.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="($csoort='telefoon') and (string-length($cadres) gt 20)">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het telefoonnummer van de school is niet langer dan 20 tekens.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="($csoort='telefoon') and not(matches($cadres,'^[0-9\s\-\+\(\)]{1,20}$'))">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het telefoonnummer van de school moet voldoen aan de voorwaarden m.b.t. toegestane karakters: alleen cijfers, spaties, haakjes, plustekens en mintekens zijn toegestaan.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			<!-- 20250526:  Validatie van vullingsregel bij telefoonnummer aangepast: nu geen foutmelding als veld <contacttelefoon> ontbreekt -->
			<xsl:for-each select="/descendant::*/od:overstapadvies">
				<xsl:if test="(od:contacttelefoon) ">
					<xsl:variable name="ctelnr" select="xs:string(od:contacttelefoon)"/>
					<xsl:if test="(string-length($ctelnr) lt 10)">
						<xsl:call-template name="melding">
							<xsl:with-param name="tekst">Het telefoonnummer van de contactpersoon bij het overstapadvies is minimaal 10 tekens.</xsl:with-param>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="(string-length($ctelnr) gt 20)">
						<xsl:call-template name="melding">
							<xsl:with-param name="tekst">Het telefoonnummer van de contactpersoon bij het overstapadvies is niet langer dan 20 tekens.</xsl:with-param>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="not(matches($ctelnr,'^[0-9\s\-\+\(\)]{1,20}$'))">
						<xsl:call-template name="melding">
							<xsl:with-param name="tekst">Het telefoonnummer van de contactpersoon bij het overstapadvies moet voldoen aan de voorwaarden m.b.t. toegestane karakters: alleen cijfers, spaties, haakjes, plustekens en mintekens zijn toegestaan.</xsl:with-param>
						</xsl:call-template>
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
			
			<!-- Afspraak OSO gegevensset, business rule OG.02 -->
			<!-- Veld <standaardversie> binnen <metadata> heeft waarde "2026.1" -->
			<!-- Is de waarde van veld dossier.metadata.standaardversie conform afspraak -->
			<!-- 20251217: Validatie van deze veldwaarde gewijzigd in "2026.1" -->
			<!-- 20250106: Validatie van deze veldwaarde gewijzigd in "2025.1" -->
			<!-- 20231220: Validatie van deze veldwaarde gewijzigd in "2024.1", inclusief gewijzigde foutmelding -->
			<!-- 20211201: Validatie van deze veldwaarde gewijzigd in "2022.1" -->
			<!-- 20190101: Validatie van deze veldwaarde gewijzigd in "2019.1" -->
			<!-- 20180102: Validatie van deze veldwaarde gewijzigd in "2018.1" -->
			<xsl:for-each select="/descendant::*/od:metadata/od:standaardversie">
				<xsl:if test="not(text()='2026.1')">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'Versienummer van standaard' bevat een waarde die niet gelijk is aan de verplichte waarde "2026.1".</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			<!-- Afspraak OSO gegevensset, business rule OG.03 -->
			<!-- lwoo einddatum format controle van veld "lwoo_einddatum" binnen "lwoo" (zie Tabel A.20): 
				Formaat "EEJJ-07-31"
				reguliere expressie: "[0-9][0-9][0-9][0-9]-07-31" -->
			<!-- 20160120: Validatie van deze veldwaarde toegevoegd (is verbodig want XSD controleert dit ook) -->
			<xsl:for-each select="/descendant::*/od:lwoo_einddatum">
				<xsl:if test="not(matches(text(),'[0-9][0-9][0-9][0-9]-07-31'))">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">Het veld 'LWOO einddatum' bevat een waarde die niet gelijk is aan het formaat "EEJJ-07-31".</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			
			<!-- Afspraak OSO gegevensset, business rule OG.04 -->
			<!-- Gegevensveld "Overlijdensdatum van ouders/verzorgers" is alleen toegestaan indien is overleden (overleden heeft waarde “true”). -->
			<!-- 20180115 volgende regel toegevoegd -->
			<xsl:for-each select="/descendant::*/od:verzorger">
				<xsl:if test="not(od:overleden) and (od:overlijdensdatum) ">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">De gegevens over ouder/verzorger mogen geen overlijdensdatum bevatten wanneer het kenmerk van overlijden ontbreekt.</xsl:with-param>
					</xsl:call-template>
			    </xsl:if>
				<xsl:if test="not(xs:boolean(od:overleden)) and (od:overlijdensdatum) ">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">De gegevens over ouder/verzorger mogen geen overlijdensdatum bevatten wanneer kenmerk van overlijden anders aangeeft.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			<!-- Afspraak OSO gegevensset, business rule OG.05 -->
			<!-- Gegevensvelden "Geslacht" en "Adresgeheim" is niet toegestaan binnen huisarts. -->
			<!-- 20190101 volgende regel toegevoegd -->
			<xsl:for-each select="/descendant::*/od:huisarts">
				<xsl:if test="(od:roepnaam) ">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">De gegevens over huisarts mogen geen roepnaam bevatten .</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="(od:geslacht) ">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">De gegevens over huisarts mogen geen geslacht bevatten .</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="(xs:boolean(od:adresgeheim)) ">
					<xsl:call-template name="melding">
						<xsl:with-param name="tekst">De gegevens over huisarts mogen geen aanduiding dat het adres geheim is bevatten.</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			
			<!-- ________________________________________________________________________________________ -->
			<!--   Validatie van Categorie velden wanneer verplicht, verboden of uitgezet in Gegevensset  -->
			<!-- ________________________________________________________________________________________ -->
			
			<!-- Afspraak OSO gegevensset, business rule OS.cat01 (cat_metadata) -->
			<!-- Gegevens van categorie "Ouderinzage" zijn verboden wanneer verboden of uitgezet in dossier -->
			<!-- 20190101 regels voor VERPLICHT en VERBODEN toegevoegd -->
			<!-- 20170308 volgende regel toegevoegd -->
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_metadata='VERPLICHT') and not((//od:dossier/od:metadata) or (//od:dossier/od:overdrachtsoort)) )">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier moet gegevens uit de categorie "Metadata" bevatten wanneer deze categorie verplicht is.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_metadata='VERBODEN') and (//od:dossier/od:metadata))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens uit de categorie "Metadata" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_metadata='VERBODEN') and (//od:dossier/od:overdrachtsoort))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens over de overdracht uit de categorie "Metadata" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_metadata='OPT-UIT') and (//od:dossier/od:metadata))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens uit de categorie "Metadata" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_metadata='OPT-UIT') and (//od:dossier/od:overdrachtsoort))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens over de overdracht uit de categorie "Metadata" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			
			<!-- Afspraak OSO gegevensset, business rule OS.cat02 (cat_ouderinzage) -->
			<!-- Gegevens van categorie "Ouderinzage" zijn verboden wanneer verboden of uitgezet in dossier -->
			<!-- 20190101 regels voor VERPLICHT en VERBODEN toegevoegd -->
			<!-- 20170308 volgende regel toegevoegd -->
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_ouderinzage='VERPLICHT') and not(//od:dossier/od:inzage))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier moet gegevens uit de categorie "Ouderinzage" bevatten wanneer deze categorie verplicht is.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_ouderinzage='VERBODEN') and (//od:dossier/od:inzage))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens uit de categorie "Ouderinzage" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_ouderinzage='OPT-UIT') and (//od:dossier/od:inzage))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens uit de categorie "Ouderinzage" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			
			<!-- Afspraak OSO gegevensset, business rule OS.cat03 (cat_school) -->
			<!-- Gegevens van categorie "School" zijn altijd verplicht in dossier middels XSD -->

			<!-- Afspraak OSO gegevensset, business rule OS.cat04 (cat_leerling) -->
			<!-- Gegevens van categorie "Leerling" zijn altijd verplicht in dossier middels XSD -->
			
			<!-- Afspraak OSO gegevensset, business rule OS.cat05 (cat_oudersverzorgers) -->
			<!-- Gegevens van categorie "Ouders/Verzorgers" zijn verboden wanneer verboden of uitgezet in dossier -->
			<!-- 20190101 regels voor VERPLIVHT en VERBODEN toegevoegd -->
			<!-- 20170308 volgende regel toegevoegd -->
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_oudersverzorgers='VERPLICHT') and 
				not((//od:dossier/od:huidigeschool/od:leerling/od:verzorgersaansprakelijk) or (//od:dossier/od:huidigeschool/od:leerling/od:verzorger) or (//od:dossier/od:huidigeschool/od:leerling/od:aansprakelijkeinstelling) ) )">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier moet gegevens uit de categorie "Ouders/Verzorgers" bevatten wanneer deze categorie verplicht is.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_oudersverzorgers='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:verzorgersaansprakelijk))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens uit de categorie "Ouders/Verzorgers" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_oudersverzorgers='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:verzorger))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen ouders/verzorger gegevens uit de categorie "Ouders/Verzorgers" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_oudersverzorgers='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:aansprakelijkeinstelling))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen aansprakelijke instelling gegevens bevatten uit de categorie "Ouders/Verzorgers" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_oudersverzorgers='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:verzorgersaansprakelijk))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens uit de categorie "Ouders/Verzorgers" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_oudersverzorgers='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:verzorger))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen ouders/verzorger gegevens uit de categorie "Ouders/Verzorgers" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_oudersverzorgers='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:aansprakelijkeinstelling))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen aansprakelijke instelling gegevens bevatten uit de categorie "Ouders/Verzorgers" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			
			<!-- Afspraak OSO gegevensset, business rule OS.cat06 (cat_vve) -->
			<!-- Gegevens van categorie "VVE" zijn verboden wanneer verboden of uitgezet in dossier -->
			<!-- 20190101 regels voor VERPLICHT en VERBODEN toegevoegd -->
			<!-- 20170308 volgende regels toegevoegd -->
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_vve='VERPLICHT') and 
				not((//od:dossier/od:huidigeschool/od:leerling/od:vanpeuterspeelzaal) or (//od:dossier/od:huidigeschool/od:leerling/od:naampeuterspeelzaal)
				or (//od:dossier/od:huidigeschool/od:leerling/od:voorschools) or (//od:dossier/od:huidigeschool/od:leerling/od:vroegschools) ) )">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier moet gegevens uit de categorie "VVE" bevatten wanneer deze categorie verplicht is.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_vve='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:vanpeuterspeelzaal))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen PSZ gegevens uit de categorie "VVE" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_vve='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:naampeuterspeelzaal))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen PSZ naam uit de categorie "VVE" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_vve='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:voorschools))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen Voorschoolse educatie gegevens uit de categorie "VVE" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_vve='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:vroegschools))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen Vroegschoolse educatie gegevens uit de categorie "VVE" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_vve='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:vanpeuterspeelzaal))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen PSZ gegevens uit de categorie "VVE" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_vve='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:naampeuterspeelzaal))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen PSZ naam uit de categorie "VVE" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_vve='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:voorschools))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen Voorschoolse educatie gegevens uit de categorie "VVE" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_vve='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:vroegschools))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen Vroegschoolse educatie gegevens uit de categorie "VVE" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			
			<!-- Afspraak OSO gegevensset, business rule OS.cat07 (cat_schoolloopbaan) -->
			<!-- Gegevens van categorie "Schoolloopbaan" zijn verboden verboden of wanneer uitgezet in dossier -->
			<!-- 20190101 regels voor VERPLICHT en VERBODEN toegevoegd -->
			<!-- 20170308 volgende regel toegevoegd -->
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_schoolloopbaan='VERPLICHT') and not(//od:dossier/od:huidigeschool/od:leerling/od:schoolloopbaanlijst))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier moet gegevens uit de categorie "Schoolloopbaan" bevatten wanneer deze categorie verplicht is.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_schoolloopbaan='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:schoolloopbaanlijst))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens uit de categorie "Schoolloopbaan" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_schoolloopbaan='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:schoolloopbaanlijst))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens uit de categorie "Schoolloopbaan" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			
			<!-- Afspraak OSO gegevensset, business rule OS.cat08 (cat_overstapadvies) -->
			<!-- Gegevens van categorie "Overstapadvies" zijn verboden verboden of wanneer uitgezet in dossier -->
			<!-- 20190101 regels voor VERPLICHT en VERBODEN toegevoegd -->
			<!-- 20170308 volgende regel toegevoegd -->
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_overstapadvies='VERPLICHT') and not(//od:dossier/od:huidigeschool/od:leerling/od:overstapadvies))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier moet gegevens uit de categorie "Overstapadvies" bevatten wanneer deze categorie verplicht is.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_overstapadvies='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:overstapadvies))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens uit de categorie "Overstapadvies" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_overstapadvies='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:overstapadvies))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens uit de categorie "Overstapadvies" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			
			<!-- Afspraak OSO gegevensset, business rule OS.cat09 (cat_onderwijsondersteuning) -->
			<!-- Gegevens van categorie "Onderwijsondersteuning" (voorheen "Zorg en Begeleiding") zijn verboden wanneer verboden of uitgezet in dossier -->
			<!-- 20190311 regels van categorie onderwijsondersteuning gecorrigeerd naar validatie van aanwezigheid van de deelelementen van het blok onderwijsondersteuning -->
			<!-- 20190101 regel gewijzigd -->
			<!-- 20190101 regels voor VERPLICHT en VERBODEN toegevoegd -->
			<!-- 20170308 volgende regels toegevoegd -->
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_onderwijsondersteuning='VERPLICHT') and 
				not((//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:toelichting_onderwijsbehoeften) or (//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:diagnose) or 
				(//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:medicijngebruik) or (//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:opp) or 
				(//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:tlv) or (//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:arrangement_cluster12) or 
				(//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:arrangement_pao) or (//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:lwoo) or 
				(//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:rvc)) )">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier moet gegevens uit de categorie "Onderwijsondersteuning" bevatten wanneer deze categorie verplicht is.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_onderwijsondersteuning='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:toelichting_onderwijsbehoefte))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen "Toelichting onderwijsbehoeften" uit de categorie "Onderwijsondersteuning" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_onderwijsondersteuning='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:diagnose))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen Diagnose-gegevens uit de categorie "Onderwijsondersteuning" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_onderwijsondersteuning='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:medicijngebruik))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag het gegeven Medicijngebruik uit de categorie "Onderwijsondersteuning" niet bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_onderwijsondersteuning='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:opp))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen OPP uit de categorie "Onderwijsondersteuning" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_onderwijsondersteuning='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:tlv))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen TLV-gegevens uit de categorie "Onderwijsondersteuning" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_onderwijsondersteuning='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:arrangement_cluster12))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens m.b.t. arrangement (cluster 1 en 2) uit de categorie "Onderwijsondersteuning" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_onderwijsondersteuning='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:arrangement_pao))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens m.b.t. arrangement (passend onderwijs) uit de categorie "Onderwijsondersteuning" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_onderwijsondersteuning='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:lwoo))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen LWOO-aanwijzing uit de categorie "Onderwijsondersteuning" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_onderwijsondersteuning='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:rvc))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen RVC-gegevens uit de categorie "Onderwijsondersteuning" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_onderwijsondersteuning='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:toelichting_onderwijsbehoefte))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen "Toelichting onderwijsbehoeften" uit de categorie "Onderwijsondersteuning" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_onderwijsondersteuning='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:diagnose))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen Diagnose-gegevens uit de categorie "Onderwijsondersteuning" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_onderwijsondersteuning='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:medicijngebruik))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag het gegeven Medicijngebruik uit de categorie "Onderwijsondersteuning" niet bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_onderwijsondersteuning='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:opp))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen OPP uit de categorie "Onderwijsondersteuning" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_onderwijsondersteuning='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:tlv))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen TLV-gegevens uit de categorie "Onderwijsondersteuning" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_onderwijsondersteuning='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:arrangement_cluster12))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens m.b.t. arrangement (cluster 1 en 2) uit de categorie "Onderwijsondersteuning" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_onderwijsondersteuning='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:arrangement_pao))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens m.b.t. arrangement (passend onderwijs) uit de categorie "Onderwijsondersteuning" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_onderwijsondersteuning='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:lwoo))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen LWOO-aanwijzing uit de categorie "Onderwijsondersteuning" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_onderwijsondersteuning='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:rvc))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen RVC-gegevens uit de categorie "Onderwijsondersteuning" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			
			<!-- Afspraak OSO gegevensset, business rule OS.cat10 (cat_verzuim) -->
			<!-- Gegevens van categorie "Verzuim" zijn verboden wanneer verboden of uitgezet in dossier -->
			<!-- 20190101 regels voor VERPLICHT en VERBODEN toegevoegd -->
			<!-- 20170308 volgende regel toegevoegd -->
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_verzuim='VERPLICHT') and not(//od:dossier/od:huidigeschool/od:leerling/od:verzuim))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier moet gegevens uit de categorie "Verzuim" bevatten wanneer deze categorie verplicht is.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_verzuim='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:verzuim))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens uit de categorie "Verzuim" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_verzuim='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:verzuim))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens uit de categorie "Verzuim" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			
			<!-- Afspraak OSO gegevensset, business rule OS.cat11 (cat_doorstroomtoets) -->
			<!-- Gegevens van categorie "Doorstroomtoets" zijn verboden verboden of wanneer uitgezet in dossier -->
			<!-- 20231220 cat_eindtoetsbo gewijzigd in cat_doorstroomtoets en <eindtoets_basisonderwijs> gewijzigd in <doorstroomtoets>, incusief gewijzigde foutmeldingen -->
			<!-- 20190101 regels voor VERPLICHT en VERBODEN toegevoegd -->
			<!-- 20170308 volgende regel toegevoegd -->
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_doorstroomtoets='VERPLICHT') and not(//od:dossier/od:huidigeschool/od:leerling/od:doorstroomtoets))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier moet gegevens uit de categorie "Doorstroomtoets" bevatten wanneer deze categorie verplicht is.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_doorstroomtoets='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:doorstroomtoets))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens uit de categorie "Doorstroomtoets" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_doorstroomtoets='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:doorstroomtoets))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens uit de categorie "Doorstroomtoets" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			
			<!-- Afspraak OSO gegevensset, business rule OS.cat120 (cat_toetsresultaten) -->
			<!-- Gegevens van categorie "Toetsresultaten" zijn verboden verboden of wanneer uitgezet in dossier -->
			<!-- 20190101 regels voor VERPLICHT en VERBODEN toegevoegd -->
			<!-- 20170308 volgende regel toegevoegd -->
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_toetsresultaten='VERPLICHT') and not(//od:dossier/od:huidigeschool/od:leerling/od:toetslijst))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier moet gegevens uit de categorie "Toetsresultaten" bevatten wanneer deze categorie verplicht is.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_toetsresultaten='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:toetslijst))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens uit de categorie "Toetsresultaten" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_toetsresultaten='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:toetslijst))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens uit de categorie "Toetsresultaten" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			
			<!-- Afspraak OSO gegevensset, business rule OS.cat13 (cat_handelingsplannen) -->
			<!-- Gegevens van categorie "Handelingsplannen" zijn verboden verboden of wanneer uitgezet in dossier -->
			<!-- 20190101 regels voor VERPLICHT en VERBODEN toegevoegd -->
			<!-- 20170308 volgende regel toegevoegd -->
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_handelingsplannen='VERPLICHT') and not(//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:handelingsplan))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier moet gegevens uit de categorie "Handelingsplannen" bevatten wanneer deze categorie verplicht is.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_handelingsplannen='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:handelingsplan))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens uit de categorie "Handelingsplannen" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_handelingsplannen='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:onderwijsondersteuning/od:handelingsplan))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens uit de categorie "Handelingsplannen" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			
			<!-- Afspraak OSO gegevensset, business rule OS.cat14 (cat_cijferlijsten) -->
			<!-- Gegevens van categorie "Cijferlijsten" zijn verboden verboden of wanneer uitgezet in dossier -->
			<!-- 20190101 regels voor VERPLICHT en VERBODEN toegevoegd -->
			<!-- 20170308 volgende regel toegevoegd -->
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_cijferlijsten='VERPLICHT') and not(//od:dossier/od:huidigeschool/od:leerling/od:cijferlijstlijst))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens uit de categorie "Cijferlijsten" bevatten wanneer deze categorie verplicht is.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_cijferlijsten='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:cijferlijstlijst))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens uit de categorie "Cijferlijsten" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_cijferlijsten='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:cijferlijstlijst))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens uit de categorie "Cijferlijsten" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			
			<!-- Afspraak OSO gegevensset versie "2022.1", business rule OS.cat15 (cat_vombo) -->
			<!-- Gegevens van categorie "VO-MBO" zijn verboden wanneer verboden of uitgezet in dossier -->
			<!-- 20220101 regels voor deze categorie verwijderd -->
			<!-- 20190101 regels voor VERPLICHT en VERBODEN toegevoegd -->
			<!-- 20170308 volgende regels toegevoegd -->
			<!--<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_vombo='VERPLICHT') and 
				not((//od:dossier/od:huidigeschool/od:leerling/od:bevorderd) or (//od:dossier/od:huidigeschool/od:leerling/od:examenresultaat) or
				(//od:dossier/od:huidigeschool/od:leerling/od:resultaatvakkenvo) or (//od:dossier/od:huidigeschool/od:leerling/od:certificaat) or
				(//od:dossier/od:huidigeschool/od:leerling/od:competenties)or (//od:dossier/od:huidigeschool/od:leerling/od:stage) or
				(//od:dossier/od:huidigeschool/od:leerling/od:overigvombo) ) )">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier moet gegevens uit de categorie "VO-MBO" bevatten wanneer deze categorie verplicht is.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_vombo='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:bevorderd))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen Bevorderd gegevens uit de categorie "VO-MBO" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_vombo='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:examenresultaat))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen Examens en uitslagen uit de categorie "VO-MBO" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_vombo='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:resultaatvakkenvo))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen VO vakken en resultaten uit de categorie "VO-MBO" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_vombo='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:certificaat))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen Certificaat gegevens uit de categorie "VO-MBO" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_vombo='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:competenties))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen Competentie gegevens uit de categorie "VO-MBO" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_vombo='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:stage))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen Stage gegevens uit de categorie "VO-MBO" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_vombo='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:overigvombo))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen Overige VO-MBO gegevens uit de categorie "VO-MBO" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_vombo='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:bevorderd))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen Bevorderd gegevens uit de categorie "VO-MBO" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_vombo='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:examenresultaat))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen Examens en uitslagen uit de categorie "VO-MBO" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_vombo='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:resultaatvakkenvo))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen VO vakken en resultaten uit de categorie "VO-MBO" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_vombo='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:certificaat))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen Certificaat gegevens uit de categorie "VO-MBO" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_vombo='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:competenties))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen Competentie gegevens uit de categorie "VO-MBO" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_vombo='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:stage))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen Stage gegevens uit de categorie "VO-MBO" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_vombo='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:overigvombo))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen Overige VO-MBO gegevens uit de categorie "VO-MBO" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>-->
			
			<!-- Afspraak OSO gegevensset, business rule OS.cat15, voorheen OS.cat16 (cat_bijlagedocs) -->
			<!-- Gegevens van categorie "Bijlagedocumenten" zijn verboden wanneer verboden of uitgezet in dossier -->
			<!-- 20190101 regels voor VERPLICHT en VERBODEN toegevoegd -->
			<!-- 20170308 volgende regel toegevoegd -->
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_bijlagedocs='VERPLICHT') and not(//od:dossier/od:huidigeschool/od:leerling/od:overigdocumentlijst))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier moet gegevens uit de categorie "Bijlagedocumenten" bevatten wanneer deze categorie verplicht is.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_bijlagedocs='VERBODEN') and (//od:dossier/od:huidigeschool/od:leerling/od:overigdocumentlijst))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens uit de categorie "Bijlagedocumenten" bevatten wanneer deze categorie is verboden.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="((//od:dossier/od:metadata/od:categorie_uitlevering/od:cat_bijlagedocs='OPT-UIT') and (//od:dossier/od:huidigeschool/od:leerling/od:overigdocumentlijst))">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">Een dossier mag geen gegevens uit de categorie "Bijlagedocumenten" bevatten wanneer deze categorie is uitgezet.</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			
			
			<xsl:apply-templates/>
		</meldingen>
	</xsl:template>


</xsl:stylesheet>
