<?xml version="1.0" encoding="UTF-8"?>
<!--Overzicht van wijzigingen -->
<!-- 20251217: Release van Validatie van SWV-profielen versie "2026.1.1" voor afspraak versie "2026.1":
	 			Versienummer van de namespace, Naam van included XSLT-bestand en Validatie veld validatieversie aangepast naar 2026,
				Business rules PaO.LL03 (bij Geboortemaand), PaO.LL07 (bij Postcode4adres), PaO.LL10 (bij Geboorteplaats) en PaO.LL11 (bij Nationaliteit) zijn verwijderd,
				Business rule PaO.OV06 (bij Banknummer) is verwijderd. -->
<!-- 20250120: Release van Validatie van SWV-profielen versie "2025.1.1" voor afspraak versie "2025.1":
	 			Versienummer van de namespace, Naam van included XSLT-bestand en Validatie veld validatieversie aangepast naar 2025,
	            Validatie van business rules PaO.SC01, PaO.LL05, PaO.OV03 aangepast m.b.t. buitenlandadres
	            Validatie van business rules PaO.SC02, PaO.LL05A, PaO.HA01, PaO.OV04 toegevoegd m.b.t. maximaal aantal adressen  -->
<!-- 20231220:  Release van Validatie van SWV-profielen versie "2024.1.1" voor afspraak versie "2024.1", inclusief wijzigingen:
	 			Versienummer van de namespace aangepast naar "2024" (i.p.v. "2022"),
	 			Validatie van regel bij validatieversie aangepast,
			    Validatie van regels bij eindtoets_basisonderwijs vervangen door regel bij doorstroomtoets.     -->
<!-- 20230221:	Correctie van typefouten -->
<!-- 20211201:	Release van Validatie van SWV-profielen versie "2022.1.1" voor afspraak versie "2022.1", inclusief wijzigingen: 
                Validatie van codelijsten 15, 35 en 36 verwijderd
                Validatie van BR PaO.MD02 (veld <validatieversie>) gewijzigd: toegestane waarde is nu "2022.1.1" -->
<!-- 20210916:	UPDATE: Validatie van BR PaO.MD02 (veld <validatieversie>) gewijzigd: toegestane waarden zijn nu "2019.1.2" en "2019.1.1" -->
<!-- 20210901:	Release van Validatie van SWV PaO profielen versie 2019.1.2, inclusief wijzigingen: 
                Validatie van codelijst 9 aangepast (2 codes toegevoegd) en van codelijst 11 aangepast (3 codes toegevoegd) 
                Validatie van BR PaO.MD02 (veld <validatieversie>) gewijzigd: toegestane waarde is nu "2019.1.2" -->
<!-- 20190101:	Eerste concept release van Validatie van SWV PaO profielen versie 2019.1.1, inclusief wijzigingen: 
                Validatie van BRs OVa.ZB01 en OVa.ZB02 (mbt Zorg) verwijderd -->
<!-- 20180102:	Eerste concept release van Validatie van SWV PaO profielen versie 2018.1.1, inclusief wijzigingen: 
				Validatie van BR OV.MD02 (veld <validatieversie>) gewijzigd
				Namespace definitie naar versie 2018.1 (ipv 2017.1)  -->
<!-- 20170308:	Eerste officiele release van Validatie van SWV PaO profielen versie 2017.1.1, gemaakt op basis van Overstapprofielen validatie XSLT -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs" xmlns:od="http://www.edustandaard.nl/oso_gegevensset/2026/dossier" 
	xmlns="http://www.edustandaard.nl/oso_gegevensset/2026/schemas/Meldingen" version="2.0" extension-element-prefixes="od">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>

	<!-- We lezen een paar gegevens uit het dossier die we later goed kunnen gebruiken -->
	<!--<xsl:variable name="typeDocument" select="local-name(/node())"/>-->
	<xsl:variable name="typeDocument" select="//od:overdrachtsoort/text()"/>
	<xsl:variable name="typeOverstap" select="/descendant-or-self::*/od:metadata/od:overstap/text()"/>
	<xsl:variable name="soortSchool" select="//od:huidigeschool/od:soort/text()"/>

	<xsl:variable name="dossierdeel" select="//od:metadata/od:deeldossier/text()"/>
	<xsl:variable name="heeftLAS">
		<xsl:choose>
			<xsl:when test="$dossierdeel='LAS' or $dossierdeel='LASLVS'">
				<xsl:text>Y</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>N</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="heeftLVS">
		<xsl:choose>
			<xsl:when test="$dossierdeel='LVS' or $dossierdeel='LASLVS'">
				<xsl:text>Y</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>N</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<!-- 20251217: Verwijzing naar deze validatie-XSLT gewijzigd -->
	<!-- 20250120: Verwijzing naar deze validatie-XSLT gewijzigd -->
	<!-- 20231220: Verwijzing naar deze validatie-XSLT gewijzigd -->
	<!-- 20211201: Verwijzing naar deze validatie-XSLT gewijzigd -->
	<!-- 20210901: Verwijzing naar deze validatie-XSLT gewijzigd -->
	<!-- 20190101: Verwijzing naar deze validatie-XSLT gewijzigd -->
	<!-- 20180102: Verwijzing naar deze validatie-XSLT gewijzigd -->
	<xsl:include href="include/ValideerOSOgegevensset_2026.1.xsl"/>


	<xsl:template match="*|text()|@*">
		<xsl:apply-templates/>
	</xsl:template>

	<!-- _______________________________________________________ -->
	<!-- Metadata business rules t.b.v. SWV-profielen            -->
	<!-- _______________________________________________________ -->
	<xsl:template name="metadata" match="//od:dossier/od:metadata">
		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.MD01 -->
		<!-- Elk dossier moet minimaal LAS bevatten -->
		<xsl:if test="$heeftLAS='N'">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Het dossier voor SWV-profielen moet een LAS deel bevatten, en mag niet alleen een LVS of TIB deel bevatten.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.MD02 -->
		<!-- 20251217 aanpassing van de regel aan actuele versie "2026.1.1" -->
		<!-- 20250120 aanpassing van de regel aan actuele versie "2025.1.1" -->
		<!-- 20231220 aanpassing van de regel aan actuele versie "2024.1.1" -->
		<!-- 20211201 aanpassing van de regel aan actuele versie "2022.1.1" -->
		<!-- Veld validatieversie heeft waarde "2019.1.2" -->
		<!-- 20180102 aanpassing volgende regel aan actuele versie -->
		<xsl:if test="($typeDocument='swv-dossier') and  not(od:validatieversie='2026.1.1')">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">De validatieversie is niet correct voor deze versie "2026.1.1" van de validatie XSLT.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.MD03 -->
		<!-- Veld categorie_uitlevering is verplicht  -->
		<xsl:if test="($typeDocument='swv-dossier') and not(od:categorie_uitlevering)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Een SWV-dossier moet het blok "Categorie uitlevering" bevatten.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.SO01 -->
		<!-- Veld Soort overstap/dossier is verplicht bij alle SWV-dossiers -->
		<xsl:if test="($typeDocument='swv-dossier') and  not(od:overstap)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Een SWV-dossier moet de aanduiding voor soort overstap/dossier bevatten.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.SO02 -->
		<!-- Veld Soort overstap/dossier heeft waarde POSWV of VOSWV -->
		<xsl:if test="($typeDocument='swv-dossier') and not($typeOverstap='POSWV') and not($typeOverstap='VOSWV')">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Het veld 'Soort overstap/dossier' heeft waarde "POSWV" of "VOSWV" binnen een SWV-dossier.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.SO03 -->
		<!-- Veld Soort overstap verboden bij alle SWV-dossiers -->
		<xsl:if test="not($typeDocument='swv-dossier')">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Een SWV-dossier moet de aanduiding "swv-dossier" voor soort overdracht bevatten.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

	</xsl:template>

	<!-- ________________________________________________________ -->
	<!-- Huidige school business rules t.b.v. SWV-profielen       -->
	<!-- ________________________________________________________ -->
	<xsl:template name="huidigeschool" match="od:huidigeschool">
		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.SC01 -->
		<!-- In een SWV-dossier is bij school adres verplicht -->
		<!-- 20250120: validatie van deze business rule voor buitenlands adres toegevoegd -->
		<xsl:if test="($typeDocument='swv-dossier') and not(od:adreslijst/od:adres) and not(od:adreslijst/od:buitenlandadres)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">In een SWV-dossier is minimaal één adres verplicht bij een school.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.SC02 -->
		<!-- Bij school zijn maximaal vijf adressen toegestaan -->
		<!-- 20250120: validatie van deze business rule toegevoegd -->
		<xsl:if test="($typeDocument='swv-dossier') and (count(od:adreslijst/od:adres)+count(od:adreslijst/od:buitenlandadres) &gt; 5)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">In een SWV-dossier zijn meer dan vijf adressen (binnenlands of buitenlands) bij de school verboden!</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.SC03 -->
		<!-- In een SWV-dossier is bij school communicatie verplicht -->
		<xsl:if test="($typeDocument='swv-dossier') and not(od:communicatielijst/od:communicatie)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">In een SWV-dossier is minimaal één set communicatiegegevens verplicht bij een school.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<xsl:apply-templates/>
	</xsl:template>

	<!-- ________________________________________________________ -->
	<!-- Leerling business rules t.b.v. SWV-profielen             -->
	<!-- ________________________________________________________ -->
	<xsl:template name="leerling" match="od:leerling">
		
		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.LL01 -->
		<!-- In een SWV-dossier is bij leerling voornaam verplicht -->
		<xsl:if test="($typeDocument='swv-dossier') and not(od:voornaam)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">In een SWV-dossier is minimaal één voornaam verplicht bij een leerling.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.LL02 -->
		<!-- In een SWV-dossier is bij leerling geboortedatum verplicht -->
		<xsl:if test="($typeDocument='swv-dossier') and not(od:geboortedatum)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">In een SWV-dossier is de geboortedatum verplicht bij een leerling.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + SWV-profielen voor versies 2025.1 en eerder, business rule PaO.LL03 -->
		<!-- In een SWV-dossier is bij leerling geboortemaand verboden -->
		<!-- 20251217 verwijderd omdat het veld <geboortemaand> is verwijderd uit de gegevensset bij versie 2026.1 -->
		<!-- <xsl:if test="($typeDocument='swv-dossier') and (od:geboortemaand)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">In een SWV-dossier is de geboortemaand verboden bij een leerling.</xsl:with-param>
			</xsl:call-template>
		</xsl:if> -->
		
		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.LL04 -->
		<!-- In een SWV-dossier is bij leerling indicatie adresgeheim verplicht -->
		<xsl:if test="($typeDocument='swv-dossier') and not(od:adresgeheim)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">In een SWV-dossier is de indicatie 'adres geheim' verplicht bij een leerling.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.LL05  -->
		<!-- Bij leerling adres of adresbuitenland verplicht (todo: toevoegen of NL-adres of buitenlands adres, niet beiden?) -->
		<!-- 20250120: validatie van deze business rule voor buitenlands adres buitenlandadres toegevoegd -->
		<!-- 20150529 gewijzigd naar adres of adresbuitenland verplicht indien adres niet geheim is -->
		<!-- 20131128 gewijzigd van adres verplicht naar adres of adresbuitenland verplicht -->
		<xsl:if test="($typeDocument='swv-dossier') and not(xs:boolean(od:adresgeheim)) and not(od:adreslijst/od:adres) and not(od:adreslijst/od:buitenlandadres) and not(od:adresbuitenland)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Minimaal één Nederlands of buitenlands adres is verplicht bij een leerling waarvan het adres niet geheim is.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.LL05A -->
		<!-- Bij leerling zijn maximaal vijf adressen toegestaan -->
		<!-- 20250120: validatie van deze business rule toegevoegd -->
		<xsl:if test="($typeDocument='swv-dossier') and (count(od:adreslijst/od:adres)+count(od:adreslijst/od:buitenlandadres) &gt; 5)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">In een SWV-dossier zijn meer dan vijf adressen (binnenlands of buitenlands) bij een leerling verboden!</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.LL06  -->
		<!-- Bij leerling is indien adres geheim adres verboden -->
		<!-- 20250120: validatie van deze business rule aangepast (adreslijst ipv adres) -->
		<xsl:if test="($typeDocument='swv-dossier') and (xs:boolean(od:adresgeheim)) and (od:adreslijst)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Indien een adres van leerling geheim, is ieder leerlingadres in SWV-dossier verboden.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<!-- Afspraak OSO gegevensset + SWV-profielen voor versies 2025.1 en eerder, business rule PaO.LL07 -->
		<!-- In een SWV-dossiers is postcode4adrres verboden -->
		<!-- 20251217 verwijderd omdat het veld <postcode4adres> is verwijderd uit de gegevensset bij versie 2026.1 -->
		<!-- <xsl:if test="($typeDocument='swv-dossier') and (od:postcode4adres)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">In een SWV-dossier is de postcode4-adres verboden bij een leerling.</xsl:with-param>
			</xsl:call-template>
		</xsl:if> -->
		
		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.LL08 (=ALGEMEEN?) -->
		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.OV05 (=ALGEMEEN?) -->
		<!-- In een SWV-dossier bij persoon (leerling, verzorger, etc.) geheimwaarde van communicatie doorgeven wanneer deze communicatie geheim is -->
		<xsl:for-each select="/descendant::*/od:communicatie">
			<xsl:if test="($typeDocument='swv-dossier') and (xs:boolean(od:geheim)) and (xs:string(od:soort)='telefoon') and not(xs:string(od:nummer)='9999999999')">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">In een SWV-dossier is geheime communicatieinfo over telefoon verplicht middels de geheimwaarde "9999999999".</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="($typeDocument='swv-dossier') and (xs:boolean(od:geheim)) and (xs:string(od:soort)='e-mail') and not(xs:string(od:nummer)='geheim@geheim.geheim')">
				<xsl:call-template name="melding">
					<xsl:with-param name="tekst">In een SWV-dossier is geheime communicatieinfo over e-mail verplicht middels de geheimwaarde "geheim@geheim.geheim".</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
		</xsl:for-each>
		
		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.LL09 (=ALGEMEEN?) -->
		<!-- Bij leerling is indien adres geheim adresbuitenland verboden -->
		<xsl:if test="($typeDocument='swv-dossier') and (xs:boolean(od:adresgeheim)) and (od:adresbuitenland)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Indien een adres van leerling geheim, is een buitenlands leerlingadres in 'Adres buitenland' verboden.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<!-- Afspraak OSO gegevensset + SWV-profielen voor versies 2025.1 en eerder, business rule PaO.LL10 -->
		<!-- geboorteplaats verboden bij alle SWV-dossiers -->
		<!-- 20251217 verwijderd omdat het veld <geboorteplaats> is verwijderd uit de gegevensset bij versie 2026.1 -->
		<!-- <xsl:if test="($typeDocument='swv-dossier') and (od:geboorteplaats)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">De geboorteplaats van de leerling is verboden in alle SWV-dossiers.</xsl:with-param>
			</xsl:call-template>
		</xsl:if> -->

		<!-- Afspraak OSO gegevensset + SWV-profielen voor versies 2025.1 en eerder, business rule PaO.LL11 -->
		<!-- nationaliteit verboden bij alle SWV-dossiers -->
		<!-- 20251217 verwijderd omdat het veld <nationaliteit> is verwijderd uit de gegevensset bij versie 2026.1 -->
		<!-- 20131128 toegevoegd -->
		<!-- <xsl:if test="($typeDocument='swv-dossier') and (od:nationaliteit)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">De nationaliteit van de leerling is verboden in een SWV-dossier.</xsl:with-param>
			</xsl:call-template>
		</xsl:if> -->

		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.LL12 -->
		<!-- BSN of onderwijsnummer is verboden in alle SWV-dossiers -->
		<xsl:if test="($typeDocument='swv-dossier') and ((od:bsn) or (od:onderwijsnummer))">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">BSN of onderwijsnummer is verboden bij een leerling in een SWV-dossier.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + overstapprofielen, business rule PaO.HA01 -->
		<!-- Maximaal vijf adressen zijn toegestaan bij een huisarts. -->
		<!-- 20250120: validatie van deze business rule toegevoegd -->
		<xsl:if test="($typeDocument='overstapdossier') and (count(od:huisarts/od:adreslijst/od:adres)+count(od:huisarts/od:adreslijst/od:buitenlandadres) &gt; 5)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">In een SWV-dossier zijn niet meer dan vijf adressen (binnenlands of buitenlands) bij een huisarts toegestaan!</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.VV01 -->
		<!-- Afkomstig van PSZ niet toegestaan bij VO-SWV -->
		<xsl:if test="($typeDocument='swv-dossier') and ($typeOverstap='VOSWV') and od:vanpeuterspeelzaal">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Het veld "Afkomstig van PSZ" is niet toegestaan in een VO SWV-dossier.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.VV02 -->
		<!-- Naam PSZ niet toegestaan bij VO-SWV -->
		<xsl:if test="($typeDocument='swv-dossier') and ($typeOverstap='VOSWV') and od:naampeuterspeelzaal">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Het veld "Naam van PSZ" is niet toegestaan in een VO SWV-dossier.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.VV03 -->
		<!-- Voorschools niet toegestaan bij VO-SWV -->
		<xsl:if test="($typeDocument='swv-dossier') and ($typeOverstap='VOSWV') and od:voorschools">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Voorschools is niet toegestaan in een VO SWV-dossier.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.VV04 -->
		<!-- Vroegschools niet toegestaan bij VO-SWV  -->
		<xsl:if test="($typeDocument='swv-dossier') and ($typeOverstap='VOSWV') and od:vroegschools">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Vroegschools is niet toegestaan in een VO SWV-dossier.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.SL01 -->
		<!-- In een SWV-profiel is schoolloopbaan verplicht -->
		<xsl:if test="($typeDocument='swv-dossier') and not(od:schoolloopbaanlijst/od:schoolloopbaan)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Minimaal één schoolloopbaan is verplicht bij een leerling in een SWV-dossier .</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.EB01 -->
		<!-- Doorstroomtoets niet toegestaan bij PO-SWV  -->
		<!-- 20231220 eindtoets_basisonderwijs vervangen door doorstroomtoets, inclusief gewijzigde foutmelding -->
		<xsl:if test="($typeDocument='swv-dossier') and ($typeOverstap='POSWV') and od:doorstroomtoets">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Het blok "Doorstroomtoets" is niet toegestaan in een PO SWV-dossier.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.OV01 -->
		<!-- Test of het blok verzorger afwezig is wanneer 'verzorgersaansprakelijk' waar is-->
		<xsl:if test="($typeDocument='swv-dossier') and  (xs:boolean(od:verzorgersaansprakelijk)) and not(od:verzorger)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Minimaal één verzorger is verplicht in een SWV-dossier als de verzorgers aansprakelijk zijn.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<xsl:apply-templates/>
	</xsl:template>

	<!-- ________________________________________________________ -->
	<!-- Verzorger business rules t.b.v. SWV-profielen            -->
	<!-- ________________________________________________________ -->
	<xsl:template name="verzorger" match="od:verzorger">
		
		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.OV03 -->
		<!-- Bij verzorger is indien adres geheim adres verboden -->
		<!-- 20250120: validatie van deze business rule aangepast (adreslijst ipv adres) -->
		<xsl:if test="($typeDocument='swv-dossier') and (xs:boolean(od:adresgeheim)) and (od:adreslijst)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Indien het adres van de verzorger geheim, is ieder verzorgeradres in SWV-dossier verboden.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.OV04 -->
		<!-- Bij verzorger zijn maximaal vijf adressen toegestaan -->
		<!-- 20250120: validatie van deze business rule toegevoegd -->
		<xsl:if test="($typeDocument='swv-dossier') and (count(od:adreslijst/od:adres)+count(od:adreslijst/od:buitenlandadres) &gt; 5)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">In SWV-dossier zijn meer dan vijf adressen (binnenlands of buitenlands) bij een verzorger verboden!</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.OV06 -->
		<!-- Bij verzorger is banknummer verboden -->
		<!-- 20251217 verwijderd omdat het veld <banknummer> is verwijderd uit de gegevensset bij versie 2026.1 -->
		<!--<xsl:if test="($typeDocument='swv-dossier') and (od:banknummer)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Voor een verzorger is een banknummer in SWV-dossier verboden.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>-->

		<xsl:apply-templates/>
	</xsl:template>
	
	<!-- _____________________________________________________________ -->
	<!-- Overstapadvies business rules t.b.v. SWV-profielen            -->
	<!-- _____________________________________________________________ -->
	<xsl:template name="overstapadvies" match="od:overstapadvies">
		
		<xsl:apply-templates/>
	</xsl:template>

	<!-- ________________________________________________________ -->
	<!-- Doorstroomtoets business rules t.b.v. SWV-profielen      -->
	<!-- ________________________________________________________ -->
	<xsl:template name="doorstroomtoets" match="od:doorstroomtoets">
		<!-- 20231220 eindtoets_basisonderwijs vervangen door doorstroomtoets -->
		
		<xsl:apply-templates/>
	</xsl:template>
	
	<!-- ______________________________________________________________ -->
	<!-- Toetsresultaten Business rules t.b.v. SWV-profielen            -->
	<!-- ______________________________________________________________ -->
	<xsl:template name="toets" match="od:toets">
		
		<xsl:apply-templates/>
	</xsl:template>
	
	
	<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.TR01 (=ALGEMEEN?) -->
	<!-- Een toetsresultaat moet minimaal een score, een referentiescore of een bijlage bevatten	-->
	<xsl:template name="toetsresultaat" match="od:resultaat">
		<xsl:if test="($typeDocument='swv-dossier') and not(od:toetsscore) and not(od:referentiescore) and not(od:document)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Een toetsresultaat moet minimaal een score, een referentiescore of een bijlage bevatten.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<xsl:apply-templates/>
	</xsl:template>

	<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.TR02 (=ALGEMEEN?) -->
	<!-- Een toetsscore moet minimaal het aantal goed, het aantal fout, het aantal gelezen, de tijd of de vaardigheidsscore bevatten -->
	<!-- 20230221: correctie van typefout in opgaven (was oipgaven) en vaardigheidsscore (was vaardigeheidsscore) in meldingstekst -->
	<xsl:template name="toetsscore" match="od:toetsscore">
		<xsl:if test="($typeDocument='swv-dossier') and not(od:aantalopgaven)and not(od:aantalgoed) and not(od:aantalfout) and not(od:aantalgelezen) and not(od:tijd) and not(od:vaardigheidsscore)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Een toetsscore moet minimaal het aantal opgaven, het aantal goed, het aantal fout, het aantal gelezen, de tijd of de vaardigheidsscore bevatten.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<xsl:apply-templates/>
	</xsl:template>

	<!-- Afspraak OSO gegevensset + SWV-profielen, business rule PaO.CL01 (=ALGEMEEN?) -->
	<!-- Een score moet minimaal een waarde of een kwalificatie bevatten -->
	<!-- 20250120: Opmerking: validatie overbodig door schemavalidatie (waarde is verplicht veld binnen referentiescore en dus altijd aanwezig) -->
	<xsl:template name="toetsreferentiescore" match="od:score">
		<xsl:if test="($typeDocument='swv-dossier') and not(od:waarde) and not(od:kwalificatie)">
			<xsl:call-template name="melding">
				<xsl:with-param name="tekst">Een score moet minimaal een waarde of een kwalificatie bevatten.</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template name="melding">
		<xsl:param name="tekst"/>

		<melding>
			<type>Fout</type>
			<locatie>
				<xsl:call-template name="xpath">
					<xsl:with-param name="postfix"/>
				</xsl:call-template>
			</locatie>
			<tekst>
				<xsl:value-of select="$tekst"/>
			</tekst>
		</melding>
	</xsl:template>

	<xsl:template name="xpath">
		<xsl:param name="postfix"/>

		<xsl:variable name="local" select="local-name()"/>
		<xsl:variable name="name" select="concat('/', $local, '[', count(preceding-sibling::*[local-name()=$local])+1, ']', $postfix)"/>
		<xsl:choose>
			<xsl:when test="not(parent::*)">
				<xsl:value-of select="$name"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:for-each select="parent::*">
					<xsl:call-template name="xpath">
						<xsl:with-param name="postfix" select="$name"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
